/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import projections.gui.Analysis;
import projections.gui.TimelineData;

public class TimelineLabelCanvas
extends Canvas {
    private TimelineData data;
    private FontMetrics fm;
    private Image offscreen;

    public TimelineLabelCanvas(TimelineData timelineData) {
        this.data = timelineData;
        this.setBackground(Analysis.background);
        this.setForeground(Analysis.foreground);
    }

    public void makeNewImage() {
        this.offscreen = null;
        if (this.data.lcw > 0 && this.data.tlh > 0) {
            this.offscreen = this.createImage(this.data.lcw, this.data.tlh);
            if (this.offscreen == null) {
                return;
            }
            Graphics graphics = this.offscreen.getGraphics();
            graphics.setClip(0, 0, this.data.lcw, this.data.tlh);
            Color color = graphics.getColor();
            graphics.setColor(Analysis.background);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setColor(color);
            if (this.fm == null) {
                this.fm = graphics.getFontMetrics(graphics.getFont());
                this.data.lcw = Math.max(this.fm.stringWidth("PE 999999") + 15, this.fm.stringWidth("(999,999)") + 20);
            }
            graphics.setColor(Analysis.foreground);
            this.data.processorList.reset();
            for (int i = 0; i < this.data.numPs; ++i) {
                String string = "PE " + this.data.processorList.nextElement();
                graphics.drawString(string, 10, this.data.tluh / 2 + i * this.data.tluh);
                string = "(" + (int)(100.0f - this.data.idleUsage[i]) + "," + (int)this.data.processorUsage[i] + ")";
                graphics.drawString(string, 15, this.data.tluh / 2 + i * this.data.tluh + this.fm.getHeight() + 2);
            }
            graphics.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen != null) {
            int n = this.data.timelineWindow.getVSBValue();
            graphics.drawImage(this.offscreen, 0, 0, this.data.lcw, this.data.vph, 0, n, this.data.lcw, n + this.data.vph, null);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

