/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class UserEventsWindow
extends GenericGraphWindow
implements ActionListener,
ColorSelectable {
    private UserEventsWindow thisWindow;
    private JPanel mainPanel;
    private JPanel controlPanel;
    int startInterval;
    int endInterval;
    long intervalSize;
    OrderedIntList processorList;
    private int numActivities = Analysis.getNumUserDefinedEvents();
    private String[] activityNames = Analysis.getUserEventNames();
    private double[][] graphData;
    private long[][] numCalls;
    private Color[] graphColors = ColorManager.createColorMap(this.numActivities);

    public UserEventsWindow(MainWindow mainWindow, Integer n) {
        super("Projections User Events Tool - " + Analysis.getFilename() + ".sts", mainWindow, n);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    private void createLayout() {
        this.mainPanel = new JPanel();
        this.getContentPane().add(this.mainPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gridBagLayout);
        JPanel jPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.controlPanel, gridBagConstraints, 0, 1, 1, 0, 0, 0);
    }

    protected void createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, null, this));
        jMenuBar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, null, this));
        jMenuBar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(jMenuBar);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    if (UserEventsWindow.this.dialog.isModified()) {
                        UserEventsWindow.this.constructToolData();
                    }
                    return null;
                }

                public void finished() {
                    UserEventsWindow.this.setGraphSpecificData();
                    UserEventsWindow.this.thisWindow.setVisible(true);
                }
            };
            swingWorker.start();
        }
    }

    public void getDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = intervalRangeDialog.getIntervalSize();
        this.startInterval = (int)intervalRangeDialog.getStartInterval();
        this.endInterval = (int)intervalRangeDialog.getEndInterval();
        this.processorList = intervalRangeDialog.getValidProcessors();
        super.getDialogData();
    }

    public void setDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        intervalRangeDialog.setIntervalSize(this.intervalSize);
        intervalRangeDialog.setValidProcessors(this.processorList);
        super.setDialogData();
    }

    private void constructToolData() {
        int n = 0;
        int n2 = 0;
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading log files", "", 0, this.processorList.size());
        progressMonitor.setNote("Reading");
        progressMonitor.setProgress(0);
        this.graphData = new double[this.processorList.size()][];
        this.numCalls = new long[this.processorList.size()][];
        while (this.processorList.hasMoreElements()) {
            n = this.processorList.nextElement();
            progressMonitor.setProgress(n2);
            progressMonitor.setNote("[PE: " + n + " ] Reading Data.");
            if (progressMonitor.isCanceled()) {
                return;
            }
            this.graphData[n2] = new double[this.numActivities];
            this.numCalls[n2] = new long[this.numActivities];
            GenericLogReader genericLogReader = new GenericLogReader(n, Analysis.getVersion());
            LogEntryData logEntryData = new LogEntryData();
            LogEntryData logEntryData2 = new LogEntryData();
            logEntryData.time = 0L;
            try {
                while (logEntryData.time < (long)this.startInterval * this.intervalSize) {
                    genericLogReader.nextEventOfType(100, logEntryData);
                    genericLogReader.nextEventOfType(100, logEntryData2);
                }
                int n3 = 0;
                do {
                    n3 = Analysis.getUserDefinedEventIndex(logEntryData.userEventID);
                    double[] dArray = this.graphData[n2];
                    int n4 = n3;
                    dArray[n4] = dArray[n4] + (double)(logEntryData2.time - logEntryData.time);
                    long[] lArray = this.numCalls[n2];
                    int n5 = n3;
                    lArray[n5] = lArray[n5] + 1L;
                    genericLogReader.nextEventOfType(100, logEntryData);
                    genericLogReader.nextEventOfType(100, logEntryData2);
                } while (logEntryData2.time <= (long)this.endInterval * this.intervalSize);
                genericLogReader.close();
            }
            catch (EOFException eOFException) {
                try {
                    genericLogReader.close();
                }
                catch (IOException iOException) {
                    System.err.println("ERROR: UserEvents Window failed to read log file for processor " + n);
                    System.err.println(eOFException);
                    System.exit(-1);
                }
            }
            catch (IOException iOException) {
                System.err.println("ERROR: UserEvents Window failed to read log file for processor " + n);
                System.err.println(iOException);
                System.exit(-1);
            }
            ++n2;
        }
        progressMonitor.close();
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Processors", this.processorList);
        this.setYAxis("Time (us)", "us");
        this.setDataSource("User Events", this.graphData, this.graphColors, this);
        this.refreshGraph();
    }

    public void showWindow() {
    }

    public void applyDialogColors() {
        this.setDataSource("User Events", this.graphData, this.graphColors, this);
        this.refreshGraph();
    }

    public String[] getPopup(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        String[] stringArray = new String[]{"Name: " + this.activityNames[n2], "Time Spent: " + U.t((long)this.graphData[n][n2]), "Count: " + this.numCalls[n][n2]};
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
        } else if (actionEvent.getSource() instanceof JMenuItem) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            if (string.equals("Close")) {
                this.close();
            } else if (string.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }
}

