/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.event.MouseEvent;
import projections.gui.Clickable;
import projections.gui.PopUpAble;
import projections.gui.ResponsiveToMouse;
import projections.gui.graph.DataSource;

public class DataSource2D
extends DataSource {
    private String title;
    private double[][] data;
    private int xValues;
    private ResponsiveToMouse parent;

    public DataSource2D(String string, double[][] dArray) {
        this.title = string;
        this.data = dArray;
        this.xValues = this.data.length;
        this.parent = null;
    }

    public DataSource2D(String string, double[][] dArray, ResponsiveToMouse responsiveToMouse) {
        this.title = string;
        this.data = dArray;
        this.parent = responsiveToMouse;
        this.xValues = this.data.length;
    }

    public DataSource2D(String string, int[][] nArray) {
        this.title = string;
        this.data = this.intToDouble(nArray);
        this.xValues = this.data.length;
        this.parent = null;
    }

    public DataSource2D(String string, int[][] nArray, ResponsiveToMouse responsiveToMouse) {
        this.title = string;
        this.data = this.intToDouble(nArray);
        this.parent = responsiveToMouse;
        this.xValues = this.data.length;
    }

    public String[] getPopup(int n, int n2) {
        if (this.parent != null && this.parent instanceof PopUpAble) {
            return ((PopUpAble)this.parent).getPopup(n, n2);
        }
        return null;
    }

    public void toolClickResponse(MouseEvent mouseEvent, int n, int n2) {
        if (this.parent != null && this.parent instanceof Clickable) {
            ((Clickable)this.parent).toolClickResponse(mouseEvent, n, n2);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public int getIndexCount() {
        return this.xValues;
    }

    public int getValueCount() {
        return this.data[0].length;
    }

    public void getValues(int n, double[] dArray) {
        for (int i = 0; i < this.data[n].length; ++i) {
            dArray[i] = this.data[n][i];
        }
    }

    private double[][] intToDouble(int[][] nArray) {
        double[][] dArrayArray = new double[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            dArrayArray[i] = new double[nArray[i].length];
            for (int j = 0; j < nArray[i].length; ++j) {
                dArrayArray[i][j] = nArray[i][j];
            }
        }
        return dArrayArray;
    }
}

