/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import projections.gui.Analysis;
import projections.gui.Bubble;
import projections.gui.graph.DataSource;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.XAxis;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxis;
import projections.gui.graph.YAxisAuto;

public class Graph
extends JPanel
implements MouseInputListener {
    public static final int STACKED = 0;
    public static final int UNSTACKED = 1;
    public static final int AREA = 2;
    public static final int SINGLE = 3;
    public static final int BAR = 4;
    public static final int LINE = 5;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private int GraphType;
    private boolean GraphStacked;
    private DataSource dataSource;
    private XAxis xAxis;
    private YAxis yAxis;
    private int originX;
    private int originY;
    private double xscale;
    private double yscale;
    private static final int FONT_SIZE = 12;
    private static final double PI = Math.PI;
    private Font font = null;
    private FontMetrics fm = null;
    private JLabel yLabel;
    double pixelincrementX;
    double pixelincrementY;
    double tickIncrementX;
    double tickIncrementY;
    long valuesPerTickX;
    long valuesPerLabelX;
    long valuesPerTickY;
    long valuesPerLabelY;
    private double barWidth;
    private double[][] stackArray;
    private double maxSumY;
    private int width;
    private int w;
    private int h;
    private int baseWidth = -1;
    private int baseHeight = -1;
    private double maxvalueX;
    private double maxvalueY;
    private Bubble bubble;
    private int bubbleXVal;
    private int bubbleYVal;

    public Graph() {
        this.setPreferredSize(new Dimension(400, 300));
        this.GraphType = 4;
        this.GraphStacked = true;
        this.stackArray = null;
        this.dataSource = null;
        this.xscale = 1.0;
        this.yscale = 1.0;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public Graph(DataSource dataSource, XAxis xAxis, YAxis yAxis) {
        this();
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.dataSource = dataSource;
        this.createStackArray();
    }

    public Dimension getMinimumSize() {
        return new Dimension(400, 300);
    }

    public void setGraphType(int n) {
        if (n == 5 || n == 4) {
            this.GraphType = n;
            this.repaint();
        } else if (n == 2) {
            this.GraphType = n;
            this.repaint();
        }
    }

    public int getGraphType() {
        return this.GraphType;
    }

    public void setStackGraph(boolean bl) {
        this.GraphStacked = bl;
        this.repaint();
    }

    public void setData(DataSource dataSource, XAxis xAxis, YAxis yAxis) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.dataSource = dataSource;
        this.createStackArray();
        this.repaint();
    }

    public void setData(DataSource dataSource) {
        this.dataSource = dataSource;
        this.createStackArray();
        this.repaint();
    }

    public void setScaleX(double d) {
        this.xscale = d;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth * this.xscale), (int)((double)this.baseHeight * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    public void setScaleY(double d) {
        this.yscale = d;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth * this.xscale), (int)((double)this.baseHeight * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    private void createStackArray() {
        if (this.dataSource != null) {
            double d = 0.0;
            int n = this.dataSource.getValueCount();
            this.stackArray = new double[this.dataSource.getIndexCount()][];
            for (int i = 0; i < this.dataSource.getIndexCount(); ++i) {
                this.stackArray[i] = new double[n];
                this.dataSource.getValues(i, this.stackArray[i]);
                for (int j = 1; j < n; ++j) {
                    double[] dArray = this.stackArray[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + this.stackArray[i][j - 1];
                }
                if (!(d < this.stackArray[i][n - 1])) continue;
                d = this.stackArray[i][n - 1];
            }
            this.maxSumY = d;
        } else {
            this.stackArray = null;
        }
    }

    private int getXValue(int n) {
        if (n > this.originX && n < this.width + this.originX) {
            int n2 = n - this.originX;
            int n3 = (int)((double)n2 / this.pixelincrementX);
            int n4 = this.originX + (int)((double)n3 * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
            if ((this.GraphType == 4 || this.GraphType == 2) && (double)n > (double)n4 - this.barWidth / 2.0 && (double)n < (double)n4 + this.barWidth / 2.0) {
                return n3;
            }
        }
        return -1;
    }

    private int getYValue(int n, int n2) {
        if (n >= 0 && n2 < this.originY && n2 > 30 && this.stackArray != null) {
            int n3 = this.dataSource.getValueCount();
            for (int i = 0; i < n3; ++i) {
                int n4 = this.originY - (int)(this.stackArray[n][i] * this.pixelincrementY);
                if (n2 <= n4) continue;
                return i;
            }
        }
        return -1;
    }

    public void paint(Graphics graphics) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            graphics.setFont(this.font);
            this.fm = graphics.getFontMetrics(this.font);
        }
        this.drawDisplay(graphics);
    }

    public void print(Graphics graphics) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            graphics.setFont(this.font);
            this.fm = graphics.getFontMetrics(this.font);
        }
        Color color = Analysis.background;
        Color color2 = Analysis.foreground;
        Analysis.background = Color.white;
        Analysis.foreground = Color.black;
        this.drawDisplay(graphics);
        Analysis.background = color;
        Analysis.foreground = color2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getXValue(n);
        int n4 = this.getYValue(n3, n2);
        if (n3 > -1 || n4 > -1) {
            this.toolClickResponse(mouseEvent, n3, n4);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getXValue(n);
        int n4 = this.getYValue(n3, n2);
        if (n3 > -1 && n4 > -1) {
            this.showPopup(n3, n4, n, n2);
        } else if (this.bubble != null) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private Point getBubbleOffset() {
        Container container = this;
        int n = container.getLocation().x;
        int n2 = container.getLocation().y;
        while ((container = container.getParent()) != null) {
            n += container.getLocation().x;
            n2 += container.getLocation().y;
        }
        return new Point(n, n2);
    }

    public void showPopup(int n, int n2, int n3, int n4) {
        Point point = this.getBubbleOffset();
        String[] stringArray = this.dataSource.getPopup(n, n2);
        if (stringArray == null) {
            return;
        }
        if (this.bubble != null && (this.bubbleXVal != n || this.bubbleYVal != n2)) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
        if (this.bubble == null && this.GraphStacked) {
            this.bubble = new Bubble(this, stringArray);
            this.bubble.setLocation(n3 + point.x, n4 + point.y);
            this.bubble.setVisible(true);
            this.bubbleXVal = n;
            this.bubbleYVal = n2;
        }
    }

    public void toolClickResponse(MouseEvent mouseEvent, int n, int n2) {
        this.dataSource.toolClickResponse(mouseEvent, n, n2);
    }

    private void drawDisplay(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setBackground(Analysis.background);
        graphics2D.setColor(Analysis.foreground);
        this.w = this.getWidth();
        this.h = this.getHeight();
        graphics2D.clearRect(0, 0, this.w, this.h);
        if (this.dataSource == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        this.baseWidth = this.getParent().getWidth();
        this.baseHeight = this.getParent().getHeight();
        String string = this.xAxis.getTitle();
        graphics2D.drawString(string, (this.w - this.fm.stringWidth(string)) / 2 + n, this.h - 10 + n2);
        string = this.dataSource.getTitle();
        graphics2D.drawString(string, (this.w - this.fm.stringWidth(string)) / 2 + n, 10 + this.fm.getHeight() + n2);
        string = this.yAxis.getTitle();
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.drawString(string, -(this.h + this.fm.stringWidth(string)) / 2 + n2, this.fm.getHeight() + n);
        graphics2D.rotate(1.5707963267948966);
        this.maxvalueX = this.dataSource.getIndexCount();
        this.maxvalueY = this.GraphType == 4 && this.GraphStacked || this.GraphType == 5 && this.GraphStacked || this.GraphType == 2 ? this.maxSumY : this.yAxis.getMax();
        this.originX = this.fm.getHeight() * 2 + this.fm.stringWidth("" + (long)this.maxvalueY);
        this.originY = this.h - (30 + this.fm.getHeight() * 2);
        if (this.xAxis != null && this.yAxis != null) {
            this.drawXAxis(graphics2D);
            this.drawYAxis(graphics2D);
            if (this.GraphType == 4) {
                this.drawBarGraph(graphics2D);
            } else if (this.GraphType == 2) {
                this.drawAreaGraph(graphics2D);
            } else {
                this.drawLineGraph(graphics2D);
            }
        }
    }

    private void drawXAxis(Graphics2D graphics2D) {
        this.width = (int)((double)(this.baseWidth - 30 - this.originX) * this.xscale);
        this.pixelincrementX = (double)this.width / this.maxvalueX;
        this.setBestIncrements(0, this.pixelincrementX, (int)this.maxvalueX);
        graphics2D.drawLine(this.originX, this.originY, this.width + this.originX, this.originY);
        int n = 0;
        int n2 = (int)this.maxvalueX;
        int n3 = n;
        while (n3 < n2) {
            int n4 = this.originX + (int)((double)n3 * this.pixelincrementX);
            if (this.valuesPerTickX == 1L) {
                n4 += (int)(this.tickIncrementX / 2.0);
            }
            if ((long)n3 % this.valuesPerLabelX == 0L) {
                graphics2D.drawLine(n4, this.originY + 5, n4, this.originY - 5);
                String string = this.xAxis.getIndexName(n3);
                graphics2D.drawString(string, n4 - this.fm.stringWidth(string) / 2, this.originY + 10 + this.fm.getHeight());
            } else {
                graphics2D.drawLine(n4, this.originY + 2, n4, this.originY - 2);
            }
            n3 = (int)((long)n3 + this.valuesPerTickX);
        }
    }

    private void drawYAxis(Graphics2D graphics2D) {
        graphics2D.drawLine(this.originX, this.originY, this.originX, 30);
        this.pixelincrementY = (double)(this.originY - 30) / this.maxvalueY;
        this.setBestIncrements(1, this.pixelincrementY, (long)this.maxvalueY);
        int n = this.fm.getHeight();
        long l = 0L;
        while ((double)l <= this.maxvalueY) {
            int n2 = this.originY - (int)((double)l * this.pixelincrementY);
            if (l % this.valuesPerLabelY == 0L) {
                graphics2D.drawLine(this.originX + 5, n2, this.originX - 5, n2);
                String string = "" + l;
                graphics2D.drawString(string, this.originX - this.fm.stringWidth(string) - 5, n2 + n / 2);
            } else {
                graphics2D.drawLine(this.originX + 2, n2, this.originX - 2, n2);
            }
            l += this.valuesPerTickY;
        }
    }

    private void drawBarGraph(Graphics2D graphics2D) {
        int n = this.dataSource.getIndexCount();
        int n2 = this.dataSource.getValueCount();
        double[] dArray = new double[n2];
        this.barWidth = this.valuesPerTickX == 1L && this.tickIncrementX >= 3.0 ? 0.8 * this.tickIncrementX : 1.0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            this.dataSource.getValues(i, dArray);
            if (this.GraphStacked) {
                n5 = 0;
                for (n4 = 0; n4 < n2; ++n4) {
                    n5 = this.originY - (int)(this.stackArray[i][n4] * this.pixelincrementY);
                    graphics2D.setColor(this.dataSource.getColor(n4));
                    if (this.valuesPerTickX == 1L) {
                        graphics2D.fillRect(this.originX + (int)((double)i * this.pixelincrementX + this.tickIncrementX / 2.0 - this.barWidth / 2.0), n5, (int)this.barWidth, (int)(dArray[n4] * this.pixelincrementY));
                        continue;
                    }
                    graphics2D.fillRect(this.originX + (int)((double)i * this.pixelincrementX), n5, (int)((double)(i + 1) * this.pixelincrementX) - (int)((double)i * this.pixelincrementX), (int)(dArray[n4] * this.pixelincrementY));
                }
                continue;
            }
            n5 = 0;
            n4 = 0;
            double d = 0.0;
            double[][] dArray2 = new double[n2][2];
            for (n3 = 0; n3 < n2; ++n3) {
                dArray2[n3][0] = n3;
                dArray2[n3][1] = dArray[n3];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                int n6;
                d = dArray2[n3][1];
                n5 = n3;
                for (n6 = n3; n6 < n2; ++n6) {
                    if (!(dArray2[n6][1] > d)) continue;
                    n5 = n6;
                    d = dArray2[n6][1];
                }
                n6 = (int)dArray2[n3][0];
                double d2 = dArray2[n3][1];
                dArray2[n3][0] = dArray2[n5][0];
                dArray2[n3][1] = d;
                dArray2[n5][0] = n6;
                dArray2[n5][1] = d2;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                graphics2D.setColor(this.dataSource.getColor((int)dArray2[n3][0]));
                n4 = this.originY - (int)(dArray2[n3][1] * this.pixelincrementY);
                if (this.valuesPerTickX == 1L) {
                    graphics2D.fillRect(this.originX + (int)((double)i * this.pixelincrementX + this.tickIncrementX / 2.0 - this.barWidth / 2.0), n4, (int)this.barWidth, (int)(dArray2[n3][1] * this.pixelincrementY));
                    continue;
                }
                graphics2D.fillRect(this.originX + (int)((double)i * this.pixelincrementX), n4, (int)((double)(i + 1) * this.pixelincrementX) - (int)((double)i * this.pixelincrementX), (int)(dArray2[n3][1] * this.pixelincrementY));
            }
        }
    }

    public void drawLineGraph(Graphics2D graphics2D) {
        int n;
        int n2 = this.dataSource.getIndexCount();
        int n3 = this.dataSource.getValueCount();
        double[] dArray = new double[n3];
        int n4 = -1;
        int[] nArray = new int[n3];
        int n5 = 0;
        int[] nArray2 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < n2; ++n) {
            if (this.GraphStacked) {
                dArray = this.stackArray[n];
            } else {
                this.dataSource.getValues(n, dArray);
            }
            n5 = this.originX + (int)((double)n * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
            for (int i = 0; i < n3; ++i) {
                graphics2D.setColor(this.dataSource.getColor(i));
                nArray2[i] = this.originY - (int)(dArray[i] * this.pixelincrementY);
                if (n4 != -1) {
                    graphics2D.drawLine(n4, nArray[i], n5, nArray2[i]);
                }
                nArray[i] = nArray2[i];
            }
            n4 = n5;
        }
    }

    public void drawAreaGraph(Graphics2D graphics2D) {
        int n = this.dataSource.getIndexCount();
        int n2 = this.dataSource.getValueCount();
        double[] dArray = new double[n2];
        Polygon polygon = new Polygon();
        for (int i = n2 - 1; i >= 0; --i) {
            polygon = new Polygon();
            int n3 = -2;
            for (int j = 0; j < n; ++j) {
                this.dataSource.getValues(j, dArray);
                int n4 = this.originX + (int)((double)j * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
                this.prefixSum(dArray);
                int n5 = this.originY - (int)(dArray[i] * this.pixelincrementY) + n3;
                if (j == 0) {
                    polygon.addPoint(n4, this.originY + n3);
                }
                polygon.addPoint(n4, n5);
                if (j != n - 1) continue;
                polygon.addPoint(n4, this.originY + n3);
            }
            graphics2D.setColor(this.dataSource.getColor(i));
            graphics2D.fill(polygon);
            graphics2D.setColor(Color.black);
            graphics2D.draw(polygon);
        }
    }

    private void prefixSum(double[] dArray) {
        for (int i = 0; i < dArray.length - 1; ++i) {
            dArray[i + 1] = dArray[i + 1] + dArray[i];
        }
    }

    private double findMaxOfSums() {
        double d = 0.0;
        int n = this.dataSource.getIndexCount();
        int n2 = this.dataSource.getValueCount();
        double[] dArray = new double[n2];
        for (int i = 0; i < n; ++i) {
            this.dataSource.getValues(i, dArray);
            this.prefixSum(dArray);
            if (!(d < dArray[n2 - 1])) continue;
            d = dArray[n2 - 1];
        }
        return d;
    }

    private void setBestIncrements(int n, double d, long l) {
        long l2 = 0L;
        long l3 = this.getNextLabelValue(l2);
        long l4 = this.getNextTickValue(l2++);
        int n2 = 0;
        while (true) {
            if ((double)(n2 = n == 0 ? this.fm.stringWidth(this.xAxis.getIndexName((int)(l - 1L))) : this.fm.getHeight()) > d * (double)l3 * 0.8) {
                l3 = this.getNextLabelValue(l2);
                l4 = this.getNextTickValue(l2++);
                continue;
            }
            if (!(d * (double)l4 < 2.0)) break;
            l3 = this.getNextLabelValue(l2);
            l4 = this.getNextTickValue(l2++);
        }
        if (n == 0) {
            this.tickIncrementX = (double)l4 * d;
            this.valuesPerTickX = l4;
            this.valuesPerLabelX = l3;
        } else if (n == 1) {
            this.tickIncrementY = (double)l4 * d;
            this.valuesPerTickY = l4;
            this.valuesPerLabelY = l3;
        }
    }

    private long getNextLabelValue(long l) {
        if (l == 0L) {
            return 1L;
        }
        if (l % 2L == 0L) {
            return (long)Math.pow(10.0, l / 2L);
        }
        return (long)Math.pow(10.0, (l + 1L) / 2L) / 2L;
    }

    private long getNextTickValue(long l) {
        if (l == 0L) {
            return 1L;
        }
        return (long)Math.pow(10.0, (l - 1L) / 2L);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        double[][] dArrayArray = new double[][]{{20.0, 21.0, 49.0, 3.0}, {25.0, 34.0, 8.0, 10.0}, {23.0, 20.0, 54.0, 3.0}, {20.0, 27.0, 4.0, 40.0}, {25.0, 21.0, 7.0, 4.0}, {20.0, 21.0, 8.0, 10.0}, {24.0, 26.0, 44.0, 4.0}, {22.0, 26.0, 20.0, 5.0}, {29.0, 29.0, 5.0, 20.0}, {20.0, 21.0, 8.0, 7.0}, {24.0, 20.0, 10.0, 3.0}, {21.0, 25.0, 6.0, 8.0}, {34.0, 23.0, 11.0, 11.0}, {20.0, 20.0, 20.0, 20.0}, {27.0, 25.0, 4.0, 5.0}, {21.0, 20.0, 5.0, 7.0}, {21.0, 24.0, 5.0, 8.0}, {26.0, 22.0, 5.0, 3.0}, {26.0, 29.0, 7.0, 10.0}, {29.0, 20.0, 8.0, 6.0}, {21.0, 24.0, 9.0, 4.0}};
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        DataSource2D dataSource2D = new DataSource2D("Histogram", dArrayArray);
        XAxisFixed xAxisFixed = new XAxisFixed("Entry Point Execution Time", "ms");
        YAxisAuto yAxisAuto = new YAxisAuto("Count", "", dataSource2D);
        Graph graph = new Graph();
        graph.setGraphType(2);
        graph.setData(dataSource2D, xAxisFixed, yAxisAuto);
        jPanel.add(graph);
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        jFrame.setSize(500, 400);
        jFrame.setTitle("Projections");
        jFrame.setVisible(true);
    }
}

