/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.util.LinkedList;
import java.util.ListIterator;
import projections.gui.graph.XAxis;

public class XAxisDiscrete
extends XAxis {
    String title;
    String[] discreteNames;

    public XAxisDiscrete(String string, LinkedList linkedList) {
        this.title = string;
        try {
            this.discreteNames = new String[linkedList.size()];
            for (int i = 0; i < this.discreteNames.length; ++i) {
                this.discreteNames[i] = (String)linkedList.get(i);
            }
        }
        catch (ClassCastException classCastException) {
            ListIterator listIterator = linkedList.listIterator();
            this.discreteNames = new String[linkedList.size()];
            int n = 0;
            try {
                while (listIterator.hasNext()) {
                    this.discreteNames[n++] = ((Integer)listIterator.next()).toString();
                }
            }
            catch (ClassCastException classCastException2) {
                System.err.println("Internal Error: XAxisDiscrete expects either an Integer or String LinkedList . Please report this error to a developer.");
                System.err.println(classCastException2);
                System.exit(-1);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getIndexName(int n) {
        return this.discreteNames[n];
    }

    public double getMultiplier() {
        return 1.0;
    }
}

