/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.io.File;
import projections.analysis.StsReader;
import projections.gui.OrderedIntList;

public class FileUtils {
    private static OrderedIntList[] validPEs;
    private static String[] validPEStrings;
    private static boolean[] hasFiles;

    public static String getBaseName(String string) {
        String string2 = null;
        if (string.endsWith(".sum.sts")) {
            string2 = string.substring(0, string.length() - 8);
        } else if (string.endsWith(".sts")) {
            string2 = string.substring(0, string.length() - 4);
        } else {
            System.err.println("Invalid sts filename! Exiting ...");
            System.exit(-1);
        }
        return string2;
    }

    public static String dirFromFile(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n != -1) {
            return string.substring(0, n);
        }
        return ".";
    }

    public static void detectFiles(StsReader stsReader, String string, String string2) {
        hasFiles = new boolean[5];
        validPEs = new OrderedIntList[5];
        validPEStrings = new String[5];
        for (int i = 0; i < 5; ++i) {
            FileUtils.validPEs[i] = new OrderedIntList();
            FileUtils.detectFiles(stsReader, string, string2, i);
            FileUtils.validPEStrings[i] = validPEs[i].listToString();
        }
    }

    public static void detectFiles(StsReader stsReader, String string, String string2, int n) {
        File file = null;
        String string3 = "";
        if (n == 4) {
            file = new File(FileUtils.getSumAccumulatedName(string2));
            if (file.isFile() && file.length() > 0L && file.canRead()) {
                FileUtils.hasFiles[n] = true;
            }
            return;
        }
        file = new File(string);
        if (!file.isDirectory()) {
            System.err.println("Internal Error: Path [" + string + "] " + "supplied for file detection is not a " + "directory! Please report to developers!");
            System.exit(-1);
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            if (!stringArray[i].endsWith(FileUtils.getTypeExtension(n))) continue;
            FileUtils.hasFiles[n] = true;
            int n3 = -1;
            int n4 = stringArray[i].lastIndexOf(".");
            if (n4 == -1 || (n2 = stringArray[i].substring(0, n4).lastIndexOf(".")) == -1 || n2 + 1 >= n4) break;
            n3 = Integer.parseInt(stringArray[i].substring(n2 + 1, n4));
            validPEs[n].insert(n3);
        }
    }

    public static boolean hasLogFiles() {
        return hasFiles[0];
    }

    public static boolean hasSumFiles() {
        return hasFiles[1];
    }

    public static boolean hasSumAccumulatedFile() {
        return hasFiles[4];
    }

    public static boolean hasSumDetailFiles() {
        return hasFiles[2];
    }

    public static boolean hasPoseDopFiles() {
        return hasFiles[3];
    }

    public static String getFileName(String string, int n, int n2) {
        return string + "." + n + "." + FileUtils.getTypeExtension(n2);
    }

    public static String getSumAccumulatedName(String string) {
        return string + ".sum";
    }

    public static String getTypeExtension(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "sum";
                break;
            }
            case 2: {
                string = "sumd";
                break;
            }
            case 0: {
                string = "log";
                break;
            }
            case 3: {
                string = "poselog";
                break;
            }
            default: {
                System.err.println("Internal Error: Unknown file type index " + n);
                System.exit(-1);
            }
        }
        return string;
    }

    public static OrderedIntList getValidProcessorList(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "Warning: No log files.";
                break;
            }
            case 1: {
                string = "Warning: No summary files.";
                break;
            }
            case 2: {
                string = "Warning: No summary detail files.";
                break;
            }
            case 3: {
                string = "Warning: No poselog files found.";
                break;
            }
            default: {
                System.err.println("Internal Error: Unsupported log type index " + n + " for valid processor " + "info.");
                System.exit(-1);
            }
        }
        if (!hasFiles[n]) {
            System.err.println(string);
        }
        return validPEs[n];
    }

    public static String getValidProcessorString(int n) {
        return FileUtils.getValidProcessorList(n).listToString();
    }
}

