/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.fmt.PConsumer;
import charm.debug.fmt.PList;
import java.io.IOException;

public class CpdUtil {
    private CcsServer ccs;

    CpdUtil(CcsServer ccsServer) {
        this.ccs = ccsServer;
    }

    public void abort(String string) {
        System.out.println(string);
        System.exit(1);
    }

    public int getListLength(String string, int n) {
        try {
            int n2 = string.length();
            int n3 = 4 + n2 + 1;
            byte[] byArray = new byte[n3];
            CcsServer.writeInt(byArray, 0, n2);
            CcsServer.writeString(byArray, 4, n2 + 1, string);
            CcsServer.Request request2 = this.ccs.sendRequest("ccs_list_len", n, byArray);
            byte[] byArray2 = this.ccs.recvResponse(request2);
            if (byArray2.length < 4) {
                return -1;
            }
            return CcsServer.readInt(byArray2, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.abort("Network error connecting to PE " + n + " to access list " + string);
            return 0;
        }
    }

    public byte[] byteList(String string, String string2, int n, int n2, int n3, byte[] byArray) {
        try {
            int n4 = string.length();
            int n5 = byArray != null ? byArray.length : 0;
            int n6 = 12 + n5 + 4 + n4 + 1;
            byte[] byArray2 = new byte[n6];
            System.out.println("byteList: " + n2 + " " + n3 + " " + n5);
            for (int i = 0; i < n5; ++i) {
                System.out.print(byArray[i]);
            }
            System.out.println("");
            CcsServer.writeInt(byArray2, 0, n2);
            CcsServer.writeInt(byArray2, 4, n3);
            CcsServer.writeInt(byArray2, 8, n5);
            if (n5 > 0) {
                CcsServer.writeBytes(byArray2, 12, n5, byArray);
            }
            CcsServer.writeInt(byArray2, 12 + n5, n4);
            CcsServer.writeString(byArray2, 16 + n5, n4 + 1, string);
            CcsServer.Request request2 = this.ccs.sendRequest("ccs_list_items." + string2, n, byArray2);
            byte[] byArray3 = this.ccs.recvResponse(request2);
            return byArray3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.abort("Network error connecting to PE " + n + " to access list " + string);
            return null;
        }
    }

    public String stringList(String string, int n, int n2, int n3, byte[] byArray) {
        return new String(this.byteList(string, "txt", n, n2, n3, byArray));
    }

    public String stringList(String string, int n, int n2, int n3) {
        return this.stringList(string, n, n2, n3, null);
    }

    public String stringList(String string, int n, byte[] byArray) {
        return this.stringList(string, n, 0, this.getListLength(string, n), byArray);
    }

    public String stringList(String string, int n) {
        return this.stringList(string, n, null);
    }

    public PList getPList(String string, int n, int n2, int n3, byte[] byArray) {
        byte[] byArray2 = this.byteList(string, "fmt", n, n2, n3, byArray);
        PConsumer pConsumer = new PConsumer();
        pConsumer.decode(byArray2);
        return pConsumer.getList();
    }

    public PList getPList(String string, int n, int n2, int n3) {
        return this.getPList(string, n, n2, n3, null);
    }

    public PList getPList(String string, int n, byte[] byArray) {
        return this.getPList(string, n, 0, this.getListLength(string, n), byArray);
    }

    public PList getPList(String string, int n) {
        return this.getPList(string, n, null);
    }

    public void setListItem(String string, int n, int n2, byte[] byArray) {
        try {
            int n3 = string.length();
            int n4 = 12 + byArray.length + 4 + n3 + 1;
            byte[] byArray2 = new byte[n4];
            int n5 = 0;
            CcsServer.writeInt(byArray2, n5, n2);
            CcsServer.writeInt(byArray2, n5 += 4, n2 + 1);
            CcsServer.writeInt(byArray2, n5 += 4, byArray.length);
            n5 += 4;
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[n5++] = byArray[i];
            }
            CcsServer.writeInt(byArray2, n5, n3);
            CcsServer.writeString(byArray2, n5 += 4, n3 + 1, string);
            if ((n5 += n3 + 1) != n4) {
                this.abort("Size mismatch during CpdList set");
            }
            CcsServer.Request request2 = this.ccs.sendRequest("ccs_list_items.set", n, byArray2);
            this.ccs.recvResponse(request2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.abort("Network error connecting to PE " + n + " to write list " + string);
        }
    }

    public String sendCcsRequest(String string, String string2, int n) {
        try {
            int n2 = string2.length();
            int n3 = n2 + 1;
            byte[] byArray = new byte[n3];
            CcsServer.writeString(byArray, 0, n2 + 1, string2);
            CcsServer.Request request2 = this.ccs.sendRequest(string, n, byArray);
            if (string2.equalsIgnoreCase("freeze") || string.equalsIgnoreCase("ccs_debug_quit") || string.equalsIgnoreCase("ccs_remove_all_break_points") || string.equalsIgnoreCase("ccs_set_break_point") || string.equalsIgnoreCase("ccs_remove_break_point") || string.equalsIgnoreCase("ccs_continue_break_point")) {
                return null;
            }
            byte[] byArray2 = this.ccs.recvResponse(request2);
            return new String(byArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.abort("Network error connecting to PE " + n + " to perform " + string);
            return null;
        }
    }

    public void bcastCcsRequest(String string, String string2, int n, int n2, boolean[] blArray) {
        if (n <= 0) {
            for (int i = 0; i < n2; ++i) {
                this.sendCcsRequest(string, string2, i);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (!blArray[i]) continue;
                this.sendCcsRequest(string, string2, i);
            }
        }
    }
}

