/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.ParDebug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class ServThread
extends Thread {
    String hostName = null;
    String portno = null;
    Runtime runtime = null;
    Process p = null;
    ParDebug mainThread = null;
    public FileWriter debugOutput;
    public static String infoStr;
    public BufferedWriter charmrunIn;
    public BufferedReader charmrunOut;

    public ServThread(ParDebug parDebug, Process process) {
        this.mainThread = parDebug;
        this.p = process;
        try {
            this.charmrunIn = new BufferedWriter(new OutputStreamWriter(this.p.getOutputStream()));
            this.charmrunOut = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
            this.debugOutput = new FileWriter("servthread_debug.out");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error in ServThread while opening the streams");
        }
    }

    public void run() {
        this.runtime = Runtime.getRuntime();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            boolean bl = false;
            try {
                String string;
                do {
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string = bufferedReader.readLine()) != null) {
                        if (!bl && string.indexOf("ccs: Server IP =", 0) != -1) {
                            int n = string.indexOf("Server IP = ", 0);
                            int n2 = string.indexOf(",", n += 12);
                            this.hostName = string.substring(n, n2);
                            int n3 = string.indexOf("Server port = ", 0);
                            int n4 = string.indexOf("$", 0);
                            this.portno = string.substring(n3 += 14, n4 - 1);
                            bl = true;
                        }
                        if (string.indexOf("Break point reached", 0) != -1) {
                            this.mainThread.setStatusMessage(string);
                        } else {
                            stringBuffer.append(string + "\n");
                        }
                        if (bufferedReader.ready() && stringBuffer.length() < 51200) continue;
                    }
                    System.out.println("Parallel program printed: " + stringBuffer.toString());
                    this.mainThread.displayProgramOutput(stringBuffer.toString());
                } while (string != null);
                System.out.println("ServThread terminated");
            }
            catch (Exception exception) {
                System.out.println("Failed to print");
            }
            System.out.println("Finished running parallel program");
            this.mainThread.quitProgram();
            this.debugOutput.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("error in ServThread. Exception caught");
        }
    }

    public String infoCommand(String string) {
        try {
            this.charmrunIn.write(string);
            this.charmrunIn.flush();
            this.debugOutput.write("question: {" + string + "}\n");
            StringBuffer stringBuffer = new StringBuffer();
            while (!stringBuffer.toString().endsWith("(gdb) ")) {
                Thread.yield();
                while (this.charmrunOut.ready()) {
                    stringBuffer.append((char)this.charmrunOut.read());
                }
            }
            this.debugOutput.write("|" + stringBuffer + "|\n");
            stringBuffer.setLength(stringBuffer.length() - 6);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return "error";
        }
    }
}

