/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PDisplayStyle;

public class PNative
extends PAbstract {
    private float[] v_float;
    private double[] v_double;
    private int[] v_int;
    private long[] v_long;
    private int len;

    PNative(int[] nArray) {
        this.v_int = nArray;
        this.v_long = null;
        this.v_float = null;
        this.v_double = null;
        this.len = nArray.length;
    }

    PNative(long[] lArray) {
        this.v_int = null;
        this.v_long = lArray;
        this.v_float = null;
        this.v_double = null;
        this.len = lArray.length;
    }

    PNative(float[] fArray) {
        this.v_int = null;
        this.v_long = null;
        this.v_float = fArray;
        this.v_double = null;
        this.len = fArray.length;
    }

    PNative(double[] dArray) {
        this.v_int = null;
        this.v_long = null;
        this.v_float = null;
        this.v_double = dArray;
        this.len = dArray.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.len > 1) {
            stringBuffer.append("{");
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.v_int != null) {
                stringBuffer.append("" + this.v_int[i]);
            }
            if (this.v_long != null) {
                stringBuffer.append("" + this.v_long[i]);
            }
            if (this.v_float != null) {
                stringBuffer.append("" + this.v_float[i]);
            }
            if (this.v_double != null) {
                stringBuffer.append("" + this.v_double[i]);
            }
            if (i + 1 == this.len) continue;
            stringBuffer.append(", ");
        }
        if (this.len > 1) {
            stringBuffer.append("} ");
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.len;
    }

    public int getIntValue(int n) {
        return this.v_int[n];
    }

    public long getLongValue(int n) {
        return this.v_long[n];
    }

    public float getFloatValue(int n) {
        return this.v_float[n];
    }

    public double getDoubleValue(int n) {
        return this.v_double[n];
    }

    public boolean draw(PDisplayStyle pDisplayStyle, int n) {
        super.draw(pDisplayStyle, n);
        for (int i = 0; i < this.len; ++i) {
            String string = "??";
            if (this.v_int != null) {
                string = Integer.toString(this.v_int[i]);
            }
            if (this.v_long != null) {
                string = Long.toString(this.v_int[i]);
            }
            if (this.v_float != null) {
                string = Float.toString(this.v_float[i]);
            }
            if (this.v_double != null) {
                string = Double.toString(this.v_double[i]);
            }
            if (pDisplayStyle.drawString(string)) continue;
            return false;
        }
        return true;
    }
}

