/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.Consumer;

public class Verbose
extends Consumer {
    private int indent = 0;

    private String startLine(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indent + n; ++i) {
            stringBuffer.append("\t");
        }
        return stringBuffer.toString();
    }

    private String startLine() {
        return this.startLine(0);
    }

    private void beginCollection(String string) {
        System.out.println(this.startLine() + string + " = {");
        ++this.indent;
    }

    private void endCollection(String string) {
        --this.indent;
        System.out.println(this.startLine() + "} " + string);
    }

    private String beginArray(String string, int n) {
        if (n > 1) {
            this.beginCollection(string + " array");
            System.out.print(this.startLine());
            return "";
        }
        System.out.print(this.startLine() + string + "=");
        return "";
    }

    private void endArray(String string, int n) {
        if (n > 1) {
            System.out.println();
            this.endCollection(string + " array");
        } else {
            System.out.println();
        }
    }

    public void listByte(byte[] byArray) {
        System.out.println(this.startLine() + "byte[] = '" + new String(byArray) + "'");
    }

    public void listInt(int[] nArray) {
        String string = this.beginArray("int", nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print(string + nArray[i] + ", ");
        }
        this.endArray("int", nArray.length);
    }

    public void listFloat(float[] fArray) {
        String string = this.beginArray("float", fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            System.out.print(string + fArray[i] + ", ");
        }
        this.endArray("float", fArray.length);
    }

    public void listILong(long[] lArray) {
        String string = this.beginArray("long", lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            System.out.print(string + lArray[i] + ", ");
        }
        this.endArray("long", lArray.length);
    }

    public void listDouble(double[] dArray) {
        String string = this.beginArray("double", dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(string + dArray[i] + ", ");
        }
        this.endArray("double", dArray.length);
    }

    public void listComment(String string) {
        System.out.println(this.startLine() + "//" + string + "");
    }

    public void listSync(int n) {
        switch (n) {
            case 0x71100000: {
                this.beginCollection("array");
                break;
            }
            case 1913651200: {
                this.endCollection("array");
                break;
            }
            case 1897922560: {
                this.beginCollection("list");
                break;
            }
            case 0x72200000: {
                this.endCollection("list");
                break;
            }
            case 1898971136: {
                this.beginCollection("object");
                break;
            }
            case 1915748352: {
                this.endCollection("object");
                break;
            }
            case 1880227840: {
                System.out.println("\n" + this.startLine(-1) + "/* Index */");
                break;
            }
            case 0x70110000: {
                System.out.println(this.startLine(-1) + ",/* Element */");
                break;
            }
            case 0x79000000: {
                System.out.println(this.startLine() + ",/* --- end of system crap ---- */");
                break;
            }
            default: {
                System.out.println(this.startLine() + "  (sync=0x" + Integer.toHexString(n) + ")");
            }
        }
    }
}

