/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.ParDebug;
import charm.debug.inspect.FunctionType;
import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.SuperClassElement;
import charm.debug.inspect.TypeVisitor;
import charm.debug.inspect.TypedefType;
import charm.debug.inspect.UnknownType;
import charm.debug.inspect.VariableElement;
import java.nio.ByteBuffer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataType
extends GenericType {
    String desc;
    Vector superclasses;
    Vector variables;
    boolean isVirtual;
    boolean isUnion;
    boolean isEnum;
    int size;
    static final Matcher functionMatcher = Pattern.compile("[^()]+ \\Q(*)(\\E.*\\)").matcher("");

    public GenericType build(String string, String string2) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        this.name = string;
        if (string == null) {
            this.name = "";
        }
        this.desc = string2;
        this.isVirtual = false;
        this.isUnion = false;
        this.isEnum = false;
        this.superclasses = new Vector();
        this.variables = new Vector();
        if (this.desc == null) {
            this.desc = DataType.getDescription(this.name);
        }
        if (this.desc == null) {
            return this;
        }
        Object object2 = this;
        if (this.desc.indexOf("virtual") != -1) {
            this.isVirtual = true;
        }
        if ((n5 = this.desc.indexOf("{")) == -1) {
            System.out.println(this.name + "|" + this.desc + "|");
            this.desc = null;
            return this;
        }
        String[] stringArray = this.desc.substring(0, n5 - 1).split("\\s:\\s");
        if (stringArray.length > 2) {
            this.desc = null;
            return this;
        }
        int n6 = stringArray[0].trim().indexOf(" ");
        String string3 = stringArray[0].trim();
        if (n6 > 0) {
            string3 = string3.substring(0, n6);
        }
        if (!stringArray[0].trim().substring(n6 + 1).equals(this.name)) {
            object = new TypedefType();
            n4 = this.desc.lastIndexOf("}");
            n3 = this.desc.substring(n4 + 1).trim().length();
            ((TypedefType)object).build(this.name, this, n3);
            Inspector.putType(this.name, (GenericType)object);
            this.name = stringArray[0].trim().substring(n6 + 1);
            Inspector.putType(this.name, this);
            object2 = object;
        }
        if (!string3.equals("class") && !string3.equals("struct")) {
            if (string3.equals("union")) {
                this.isUnion = true;
            } else if (string3.equals("enum")) {
                this.isEnum = true;
            } else {
                System.out.println(this.name);
                System.out.println(this.desc);
                System.out.println("The returned info is not correct, type " + string3);
                this.desc = null;
                return this;
            }
        }
        if (stringArray.length == 2) {
            object = stringArray[1].trim() + ",";
            n4 = 0;
            n3 = 0;
            for (n2 = 0; n2 < ((String)object).length(); ++n2) {
                int n7;
                if (((String)object).charAt(n2) == '<') {
                    ++n3;
                }
                if (((String)object).charAt(n2) == '>') {
                    --n3;
                }
                if (((String)object).charAt(n2) != ',' || n3 != 0) continue;
                String string4 = ((String)object).substring(n4, n2);
                if (string4.startsWith("public") || string4.startsWith("protected") || string4.startsWith("private")) {
                    string4 = string4.substring(string4.indexOf(" ") + 1);
                }
                System.out.println("superName: " + string4);
                GenericType genericType = Inspector.getType(string4);
                if (genericType == null) {
                    genericType = new DataType();
                    Inspector.putType(string4, genericType);
                    genericType.build(string4, DataType.getDescription(string4));
                }
                if (genericType instanceof DataType) {
                    if (((DataType)genericType).isVirtual) {
                        this.isVirtual = true;
                    }
                } else if (genericType instanceof TypedefType && ((TypedefType)genericType).isVirtual()) {
                    this.isVirtual = true;
                }
                String string5 = ParDebug.infoCommand("info:print (class " + string4 + "*)((class " + this.name + "*)" + ParDebug.dataPos + ")\n");
                System.out.println("info:print (class " + string4 + "*)((class " + this.name + "*)" + ParDebug.dataPos + ") = " + string5);
                if (string5.indexOf(" 0x") != -1) {
                    int n8 = string5.indexOf(" 0x") + 1;
                    n = string5.indexOf(" ", n8);
                    if (n == -1) {
                        n = string5.length() - 1;
                    }
                    n7 = Integer.decode(string5.substring(n8, n)) - ParDebug.dataPos;
                } else {
                    n7 = -1;
                }
                this.superclasses.add(new SuperClassElement(genericType, n7));
                n4 = ++n2 + 1;
            }
        }
        String[] stringArray2 = this.desc.substring(n5).split("[:;][\n\r]");
        for (n3 = 1; n3 < stringArray2.length - 1; ++n3) {
            int n9;
            int n10;
            int n11;
            CharSequence charSequence;
            object = stringArray2[n3].trim();
            System.out.println("|" + (String)object + "|");
            if (((String)object).equals("public") || ((String)object).equals("protected") || ((String)object).equals("private") || ((String)object).indexOf("(") != -1 || ((String)object).indexOf("static") != -1) continue;
            if (((String)object).startsWith("volatile")) {
                object = ((String)object).substring(9);
            }
            n2 = ((String)object).lastIndexOf(" ");
            int n12 = ((String)object).indexOf("[");
            boolean bl = n12 != -1;
            int n13 = 0;
            while (((String)object).charAt(n2 + 1 + n13) == '*') {
                ++n13;
            }
            String string6 = ((String)object).substring(0, n2).trim();
            if (string6.startsWith("class") || string6.startsWith("struct")) {
                string6 = string6.substring(string6.indexOf(" ") + 1);
            }
            String string7 = ((String)object).substring(n2 + n13 + 1, bl ? n12 : ((String)object).length());
            n = 0;
            if (bl) {
                n = Integer.parseInt(((String)object).substring(n12 + 1, ((String)object).indexOf("]")));
            }
            System.out.println("Result: |" + string6 + "|" + string7 + "|" + (n13 > 0 ? "pointer" : "") + (bl ? Integer.toString(n) : ""));
            GenericType genericType = null;
            if (string6.startsWith("{")) {
                System.out.println("Conctructing anonymous type");
                charSequence = new StringBuffer();
                n11 = 1;
                n10 = stringArray2[n3].indexOf("{");
                n9 = n10 + 1;
                while (n3 < stringArray2.length - 1) {
                    ((StringBuffer)charSequence).append(stringArray2[n3]).append(";\n");
                    System.out.println("line: " + stringArray2[n3]);
                    while (n9 < ((StringBuffer)charSequence).length()) {
                        if (((StringBuffer)charSequence).charAt(n9) == '{') {
                            ++n11;
                        }
                        if (((StringBuffer)charSequence).charAt(n9) == '}') {
                            --n11;
                        }
                        System.out.println("j: " + n9 + " val: " + ((StringBuffer)charSequence).charAt(n9) + " depth: " + n11);
                        if (n11 == 0) {
                            String string8 = ((StringBuffer)charSequence).substring(0, n9 + 1);
                            System.out.println("anon desc: " + string8);
                            genericType = new DataType();
                            genericType.build("", string8);
                            break;
                        }
                        ++n9;
                    }
                    if (n9 < ((StringBuffer)charSequence).length()) {
                        string7 = ((StringBuffer)charSequence).substring(n9 + 1, ((StringBuffer)charSequence).indexOf(";", n9 + 1)).trim();
                        break;
                    }
                    ++n3;
                }
            } else {
                genericType = Inspector.getType(string6);
                if (genericType == null) {
                    charSequence = DataType.getDescription(string6);
                    genericType = charSequence == null ? new UnknownType() : (((String)charSequence).indexOf("{") != -1 ? new DataType() : (functionMatcher.reset(charSequence).matches() ? new FunctionType() : new TypedefType()));
                    Inspector.putType(string6, genericType);
                    genericType = genericType.build(string6, (String)charSequence);
                }
            }
            charSequence = ParDebug.infoCommand("info:print &((class " + this.name + "*)" + ParDebug.dataPos + ")->" + string7 + "\n");
            System.out.println("info:print &((class " + this.name + "*)" + ParDebug.dataPos + ")->" + string7 + " = " + (String)charSequence);
            if (((String)charSequence).indexOf(" 0x") == -1) {
                charSequence = ParDebug.infoCommand("info:print &((" + this.name + "*)" + ParDebug.dataPos + ")->" + string7 + "\n");
                System.out.println("info:print &((" + this.name + "*)" + ParDebug.dataPos + ")->" + string7 + " = " + (String)charSequence);
            }
            if (((String)charSequence).indexOf(" 0x") != -1) {
                n10 = ((String)charSequence).indexOf(" 0x") + 1;
                n9 = ((String)charSequence).indexOf(" ", n10);
                if (n9 == -1) {
                    n9 = ((String)charSequence).length() - 1;
                }
                n11 = Integer.decode(((String)charSequence).substring(n10, n9)) - ParDebug.dataPos;
            } else {
                n11 = -1;
            }
            this.variables.add(new VariableElement(genericType, string7, n, n13, n11));
        }
        return object2;
    }

    public int getSize() {
        return 0;
    }

    public int getChildren() {
        return this.superclasses.size() + this.variables.size();
    }

    public GenericElement getChild(int n) {
        if (n >= this.superclasses.size()) {
            if ((n -= this.superclasses.size()) >= this.variables.size()) {
                return null;
            }
            return (VariableElement)this.variables.elementAt(n);
        }
        return (SuperClassElement)this.superclasses.elementAt(n);
    }

    public String getValue(TypeVisitor typeVisitor) {
        return null;
    }

    public String toString(String string) {
        int n;
        if (this.name == null) {
            return "";
        }
        if (this.desc == null) {
            return "(no info available)";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEnum) {
            return "enum " + this.name;
        }
        String string2 = "  " + string;
        if (this.isUnion) {
            stringBuffer.append("union ");
        } else {
            stringBuffer.append("class ");
        }
        stringBuffer.append(this.name).append(" {\n");
        if (this.isVirtual) {
            stringBuffer.append(string2).append("(virtual)").append("\n");
        }
        for (n = 0; n < this.superclasses.size(); ++n) {
            stringBuffer.append(string2).append("super ").append(((SuperClassElement)this.superclasses.elementAt(n)).toString(string2)).append("\n");
        }
        for (n = 0; n < this.variables.size(); ++n) {
            stringBuffer.append(string2).append(((VariableElement)this.variables.elementAt(n)).toString(string2)).append("\n");
        }
        stringBuffer.append(string).append("}");
        return stringBuffer.toString();
    }

    public String memoryToString(String string, ByteBuffer byteBuffer, int n) {
        int n2;
        if (this.name == null) {
            return "?";
        }
        if (this.desc == null) {
            return "(no info available)";
        }
        System.out.println(this.name + " start = " + n);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "  " + string;
        stringBuffer.append("{\n");
        if (this.isVirtual) {
            stringBuffer.append(string2).append("virtual table: ").append(DataType.printPointer(byteBuffer, n)).append("\n");
        }
        for (n2 = 0; n2 < this.superclasses.size(); ++n2) {
            stringBuffer.append(string2).append("super ").append(((SuperClassElement)this.superclasses.elementAt(n2)).memoryToString(string2, byteBuffer, n)).append("\n");
        }
        for (n2 = 0; n2 < this.variables.size(); ++n2) {
            stringBuffer.append(string2).append(((VariableElement)this.variables.elementAt(n2)).memoryToString(string2, byteBuffer, n)).append("\n");
        }
        if (this.isEnum) {
            stringBuffer.append(string2).append("enum\n");
        }
        stringBuffer.append(string).append("}");
        return stringBuffer.toString();
    }

    public void visit(TypeVisitor typeVisitor) {
        int n;
        if (this.name == null || this.desc == null) {
            return;
        }
        typeVisitor.push();
        if (this.isVirtual) {
            typeVisitor.addType("virtual table");
            typeVisitor.addValue(typeVisitor.printPointer());
        }
        for (n = 0; n < this.superclasses.size(); ++n) {
            ((SuperClassElement)this.superclasses.elementAt(n)).visit(typeVisitor);
        }
        for (n = 0; n < this.variables.size(); ++n) {
            ((VariableElement)this.variables.elementAt(n)).visit(typeVisitor);
        }
        typeVisitor.pop();
    }
}

