/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.TypeVisitor;
import java.nio.ByteBuffer;

class VariableElement
extends GenericElement {
    String name;
    int size;
    int pointer;

    VariableElement(GenericType genericType, String string, int n, int n2, int n3) {
        this.type = genericType;
        this.name = string;
        this.size = n;
        this.pointer = n2;
        this.offset = n3;
    }

    public String getName() {
        return this.name;
    }

    public int getPointer() {
        return this.pointer;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.pointer > 0) {
            stringBuffer.append(this.type.getName());
            for (int i = 0; i < this.pointer; ++i) {
                stringBuffer.append("*");
            }
        } else {
            stringBuffer.append(this.type.toString(string));
        }
        stringBuffer.append(" ").append(this.name);
        if (this.size > 0) {
            stringBuffer.append("[").append(this.size).append("]");
        }
        stringBuffer.append(" (").append(this.offset).append(")");
        return stringBuffer.toString();
    }

    public String memoryToString(String string, ByteBuffer byteBuffer, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type.getName());
        for (n2 = 0; n2 < this.pointer; ++n2) {
            stringBuffer.append("*");
        }
        stringBuffer.append(" ").append(this.name);
        if (this.size > 0) {
            stringBuffer.append("[").append(this.size).append("]");
        }
        stringBuffer.append(" = ");
        int n3 = n2 = this.offset >= 0 && n >= 0 ? this.offset + n : -1;
        if (this.pointer > 0) {
            stringBuffer.append(GenericType.printPointer(byteBuffer, n2));
        } else {
            if (this.size > 0) {
                stringBuffer.append("{ ");
            }
            stringBuffer.append(this.type.memoryToString(string, byteBuffer, n2));
            for (int i = 1; i < this.size; ++i) {
                stringBuffer.append(", ").append(this.type.memoryToString(string, byteBuffer, n2 >= 0 ? n2 + this.type.getSize() * i : -1));
            }
            if (this.size > 0) {
                stringBuffer.append(" }");
            }
        }
        return stringBuffer.toString();
    }

    public void visit(TypeVisitor typeVisitor) {
        typeVisitor.seek(this.offset);
        typeVisitor.addType(this.type.getName());
        typeVisitor.addName(this.name);
        this.type.visit(typeVisitor);
        typeVisitor.revertSeek();
        if (this.pointer > 0) {
            typeVisitor.setPointer(this.pointer);
        }
    }
}

