/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.Symbol;
import java.util.Vector;

public class Slot
implements Comparable {
    private int location;
    private int size;
    private boolean isLeak;
    private int type;
    private Vector backtrace;
    public static final int LEAK_FLAG = 8;
    public static final int TYPE_MASK = 7;
    public static final int UNKNOWN_TYPE = 0;
    public static final int SYSTEM_TYPE = 1;
    public static final int USER_TYPE = 2;
    public static final int CHARE_TYPE = 3;
    public static final int MESSAGE_TYPE = 4;

    public Slot(int n) {
        this.location = n;
        this.isLeak = false;
        this.type = 0;
        this.backtrace = new Vector();
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setLeak(boolean bl) {
        this.isLeak = bl;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void addTrace(Object object) {
        this.backtrace.add(object);
    }

    public int getLocation() {
        return this.location;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isLeak() {
        return this.isLeak;
    }

    public int getType() {
        return this.type;
    }

    public int getTraceSize() {
        return this.backtrace.size();
    }

    public Object getTrace(int n) {
        return this.backtrace.elementAt(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isLeak()) {
            stringBuffer.append("*** LEAKING ***\n");
        }
        stringBuffer.append("Memory type: ");
        switch (this.type) {
            case 1: {
                stringBuffer.append("system");
                break;
            }
            case 2: {
                stringBuffer.append("user");
                break;
            }
            case 3: {
                stringBuffer.append("chare object");
                break;
            }
            case 4: {
                stringBuffer.append("message");
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        stringBuffer.append("\nSlot at position 0x" + Integer.toHexString(this.location) + " of size " + this.size + " bytes. Backtrace:\n");
        for (int i = 0; i < this.backtrace.size(); ++i) {
            stringBuffer.append("\tfunction ").append((Symbol)this.backtrace.elementAt(i) + "\n");
        }
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        Slot slot = (Slot)object;
        return this.location == slot.location ? 0 : (this.location > slot.location ? 1 : -1);
    }
}

