/*

   interpolatelog.C

   Author: Isaac Dooley
   email : idooley2@uiuc.edu
   date  : Jan 06, 2007

    This uses the gsl library for least-square fitting. Gnu Scientific Library is available under GPL

    Currently we hard code in two parameters some places. This should be fixed


*/

#include "blue.h"
#include "blue_impl.h"
#include "blue.h"
#include "blue_impl.h"
#include "blue_types.h"
#include "bigsim_logs.h"
#include "assert.h"
#include <sys/stat.h>
#include <sys/types.h>

#include <EventInterpolator.h>

#include <string>
#include <iostream>
#include <fstream>
#include <map>
#include <utility> // for std::pair
#include <vector>

extern BgTimeLineRec* currTline;
extern int currTlineIdx;

#define OUTPUTDIR "newtraces/"
#define CYCLE_TIMES_FILE "nopme"

int main()
{
    // Load in Mambo Times
    EventInterpolator interpolator(CYCLE_TIMES_FILE);

    int totalProcs, numX, numY, numZ, numCth, numWth, numPes;
    BgTimeLineRec *tlinerecs;


    // load bg trace summary file
    printf("Loading bgTrace ... \n");
    int status = BgLoadTraceSummary("bgTrace", totalProcs, numX, numY, numZ, numCth, numWth, numPes);
    if (status == -1) exit(1);
    printf("========= BgLog Version: %d ========= \n", bglog_version);
    printf("Found %d (%dx%dx%d:%dw-%dc) emulated procs on %d real procs.\n", totalProcs, numX, numY, numZ, numWth, numCth, numPes);

    int* allNodeOffsets = BgLoadOffsets(totalProcs,numPes);

    tlinerecs = new BgTimeLineRec[totalProcs];

    printf("========= Loading All Logs ========= \n");

    // load each individual trace file for each bg proc
    assert(totalProcs == 4);

    unsigned rewritten_count=0;
    unsigned total_count=0;
    bool negative_durations_occured = false;

    for (int i=0; i<totalProcs; i++)
    {
        int procNum = i;
        currTline = &tlinerecs[i];
        currTlineIdx = procNum;
        int fileNum = BgReadProc(procNum,numWth,numPes,totalProcs,allNodeOffsets,tlinerecs[i]);
        CmiAssert(fileNum != -1);
        printf("Load log of BG proc %d from bgTrace%d... \n", i, fileNum);

        BgTimeLine &timeLine = tlinerecs[i].timeline; // Really a CkQ< BgTimeLog *>

        printf("%d entries in timeLine\n", timeLine.length());

        // Scan through each event for this emulated processor
        for(int j=0;j<timeLine.length();j++){
            BgTimeLog* timeLog = timeLine[j];
            std::string name(timeLog->name);
            total_count++;
            // If name of this event is one that needs to have its duration modified
            if( interpolator.haveNewTiming(i,timeLog->seqno) ) {

                double newduration = interpolator.predictTime(i,timeLog->seqno);

                if(newduration > 0.0){

                    rewritten_count++;

                    double oldstart = timeLog->startTime;
                    double oldend   = timeLog->endTime;
                    double newstart = oldstart;
                    double newend   = oldstart+newduration;

                    timeLog->startTime = newstart;
                    timeLog->endTime   = newend;

//                     printf("Rewriting duration of event %d name=%s from [%.10lf , %.10lf] to [%.10lf , %.10lf]\n", j, timeLog->name, oldstart,oldend,newstart,newend);

                    for(int m=0;m<timeLog->msgs.length();m++){
                        double oldsendtime = timeLog->msgs[m]->sendTime;
                        double newsendtime;

                        if(oldstart == oldend){
                            newsendtime = oldstart;
                        } else {
                            // Linearly map the old range onto the new range
                            newsendtime = newstart + (oldsendtime-oldstart)/(oldend-oldstart) * (newend-newstart);
                        }

                        timeLog->msgs[m]->sendTime = newsendtime;
                        printf("changing message %d send time from %.10lf to %.10lf\n", m, oldsendtime, newsendtime);
                    }
                }
                else {
                    negative_durations_occured=true;
                }
            }

        }
    }
    if(negative_durations_occured){
        cerr << "======================  WARNING ======================" << endl;
        cerr << "||  One or more new durations were less than zero. \n||  This probably means your model or input times are \n||  not good enough." << endl;
        cerr << "======================================================" << endl;
    }

    // Create output directory
    mkdir(OUTPUTDIR, 0777);

    // We should write out the timelines to the same number of files as we started with.
    // The mapping from VP to file was probably round robin. Here we cheat and make just one file
    // TODO : fix this to write out in same initial pattern
    BgWriteTraceSummary(totalProcs, 1, numX, numY, numZ, numCth, numWth, OUTPUTDIR);
    //  for(int i=0; i<numPes; i++)
    BgWriteTimelines(0, &tlinerecs[0], totalProcs, numWth, OUTPUTDIR);

    delete [] allNodeOffsets;

    std::cout << " We successfully replaced the durations of " << rewritten_count << " events out of " <<  total_count << std::endl;
    std::cout << "End of program" << std::endl;

}

