/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import projections.analysis.AsciiIntegerReader;
import projections.analysis.ProjDefs;
import projections.analysis.StsReader;
import projections.misc.ProgressDialog;

public class LogReader
extends ProjDefs {
    public static final int SYS_Q = 0;
    public static final int SYS_CPU = 1;
    public static final int SYS_IDLE = 2;
    public static final int IDLE_ENTRY = -1;
    public static final int CREATE = 0;
    public static final int PROCESS = 1;
    public static final int TIME = 2;
    private int[][][] sysUsgData;
    private int[][][][] userEntries;
    private int[][][][] categorized;
    private long progStartTime;
    private int numProcessors;
    private int numUserEntries;
    private long startTime;
    private int currentEntry;
    private int currentMtype;
    private int interval;
    private int curPe;
    private int numIntervals;
    private long intervalSize;
    private int processing;
    private boolean byEntryPoint;

    private final void addToInterval(int n, int n2, boolean bl) {
        if (this.processing <= 0) {
            return;
        }
        if (this.currentEntry == -1) {
            int[] nArray = this.sysUsgData[2][this.curPe];
            int n3 = n2;
            nArray[n3] = nArray[n3] + (bl ? 100 : n);
        } else {
            int[] nArray = this.sysUsgData[1][this.curPe];
            int n4 = n2;
            nArray[n4] = nArray[n4] + (bl ? 100 : n);
            if (this.byEntryPoint) {
                int[] nArray2 = this.userEntries[this.currentEntry][2][this.curPe];
                int n5 = n2;
                nArray2[n5] = nArray2[n5] + n;
                int n6 = this.mtypeToCategoryIdx(this.currentMtype);
                if (n6 != -1) {
                    int[] nArray3 = this.categorized[n6][2][this.curPe];
                    int n7 = n2;
                    nArray3[n7] = nArray3[n7] + n;
                }
            }
        }
        this.startTime += (long)n;
    }

    private final void count(int n, int n2, int n3) {
        if (!this.byEntryPoint) {
            return;
        }
        if (this.userEntries[n2][n3] == null) {
            this.userEntries[n2][n3] = new int[this.numProcessors][this.numIntervals + 1];
            if (n3 == 1) {
                this.userEntries[n2][2] = new int[this.numProcessors][this.numIntervals + 1];
            }
        }
        int[] nArray = this.userEntries[n2][n3][this.curPe];
        int n4 = this.interval;
        nArray[n4] = nArray[n4] + 1;
        int n5 = this.mtypeToCategoryIdx(n);
        if (n5 != -1) {
            if (this.categorized[n5][n3] == null) {
                this.categorized[n5][n3] = new int[this.numProcessors][this.numIntervals + 1];
                if (n3 == 1) {
                    this.categorized[n5][2] = new int[this.numProcessors][this.numIntervals + 1];
                }
            }
            int[] nArray2 = this.categorized[n5][n3][this.curPe];
            int n6 = this.interval;
            nArray2[n6] = nArray2[n6] + 1;
        }
    }

    private void fillToInterval(int n) {
        if (this.interval >= n) {
            return;
        }
        int n2 = (int)((long)(this.interval + 1) * this.intervalSize - this.startTime);
        this.addToInterval(n2, this.interval, false);
        this.rescale(this.interval);
        int n3 = this.interval + 1;
        while (n3 < n) {
            this.addToInterval((int)this.intervalSize, n3, true);
            ++n3;
        }
        this.interval = n;
    }

    public int[][][][] getSystemMsgs() {
        return this.categorized;
    }

    public int[][][] getSystemUsageData() {
        return this.sysUsgData;
    }

    public int[][][][] getUserEntries() {
        return this.userEntries;
    }

    private void intervalCalc(int n, int n2, int n3, long l) throws IOException {
        this.fillToInterval((int)(l / this.intervalSize));
        switch (n) {
            case 4: {
                int[] nArray = this.sysUsgData[0][this.curPe];
                int n4 = this.interval;
                nArray[n4] = nArray[n4] + 1;
                break;
            }
            case 1: {
                int[] nArray = this.sysUsgData[0][this.curPe];
                int n5 = this.interval;
                nArray[n5] = nArray[n5] + 1;
                this.count(n2, n3, 0);
                break;
            }
            case 2: {
                ++this.processing;
                this.startTime = l;
                int[] nArray = this.sysUsgData[0][this.curPe];
                int n6 = this.interval;
                nArray[n6] = nArray[n6] - 1;
                this.currentMtype = n2;
                this.currentEntry = n3;
                this.count(this.currentMtype, this.currentEntry, 1);
                break;
            }
            case 3: {
                this.addToInterval((int)(l - this.startTime), this.interval, false);
                --this.processing;
                break;
            }
            case 14: {
                ++this.processing;
                this.startTime = l;
                this.currentEntry = -1;
                break;
            }
            case 15: {
                this.addToInterval((int)(l - this.startTime), this.interval, false);
                --this.processing;
                break;
            }
            default: {
                System.out.println("Unhandled type " + n + " in logreader!");
            }
        }
    }

    private final int mtypeToCategoryIdx(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 12: {
                return 3;
            }
            case 14: 
            case 15: {
                return 4;
            }
        }
        return -1;
    }

    public void read(StsReader stsReader, long l, long l2, boolean bl) {
        this.numProcessors = stsReader.getProcessorCount();
        this.numUserEntries = stsReader.getEntryCount();
        this.intervalSize = l2;
        this.numIntervals = (int)((double)l / (double)this.intervalSize + 1.0);
        this.byEntryPoint = bl;
        ProgressDialog progressDialog = new ProgressDialog("Reading log files...");
        double d = 0.5;
        double d2 = d + (double)stsReader.getProcessorCount();
        progressDialog.progress(0.0, "allocating");
        this.sysUsgData = new int[3][this.numProcessors][this.numIntervals + 1];
        if (this.byEntryPoint) {
            this.userEntries = new int[this.numUserEntries][3][][];
            this.categorized = new int[5][3][][];
        }
        int n = stsReader.getProcessorCount();
        this.curPe = 0;
        while (this.curPe < n) {
            try {
                this.processing = 0;
                this.interval = 0;
                this.currentEntry = -1;
                this.startTime = 0L;
                FileReader fileReader = new FileReader(stsReader.getLogName(this.curPe));
                AsciiIntegerReader asciiIntegerReader = new AsciiIntegerReader(new BufferedReader(fileReader));
                asciiIntegerReader.nextLine();
                asciiIntegerReader.nextInt();
                this.progStartTime = 0L;
                int n2 = 2;
                if (!progressDialog.progress(d + (double)this.curPe, d2, "Loading " + (this.curPe + 1) + " of " + n)) break;
                try {
                    block11: while (true) {
                        asciiIntegerReader.nextLine();
                        int n3 = asciiIntegerReader.nextInt();
                        ++n2;
                        switch (n3) {
                            case 14: 
                            case 15: {
                                long l3 = asciiIntegerReader.nextLong();
                                int n4 = asciiIntegerReader.nextInt();
                                this.intervalCalc(n3, 0, 0, l3 - this.progStartTime);
                                continue block11;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                int n5 = asciiIntegerReader.nextInt();
                                int n6 = asciiIntegerReader.nextInt();
                                long l3 = asciiIntegerReader.nextLong();
                                int n7 = asciiIntegerReader.nextInt();
                                int n4 = asciiIntegerReader.nextInt();
                                int n8 = asciiIntegerReader.nextInt();
                                this.intervalCalc(n3, n5, n6, l3 - this.progStartTime);
                                continue block11;
                            }
                            case 4: {
                                int n5 = asciiIntegerReader.nextInt();
                                long l3 = asciiIntegerReader.nextLong();
                                int n7 = asciiIntegerReader.nextInt();
                                int n4 = asciiIntegerReader.nextInt();
                                this.intervalCalc(n3, n5, 0, l3 - this.progStartTime);
                                continue block11;
                            }
                            case 7: {
                                long l3 = asciiIntegerReader.nextLong();
                                this.fillToInterval(this.numIntervals);
                                continue block11;
                            }
                        }
                    }
                }
                catch (EOFException eOFException) {
                    asciiIntegerReader.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Exception reading log file #" + this.curPe);
                return;
            }
            ++this.curPe;
        }
        progressDialog.done();
    }

    private void rescale(int n) {
        this.sysUsgData[1][this.curPe][n] = (int)((long)(this.sysUsgData[1][this.curPe][n] * 100) / this.intervalSize);
        this.sysUsgData[2][this.curPe][n] = (int)((long)(this.sysUsgData[2][this.curPe][n] * 100) / this.intervalSize);
    }
}

