/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import projections.analysis.ProjDefs;
import projections.analysis.StsReader;
import projections.misc.SummaryFormatException;

public class SumAnalyzer
extends ProjDefs {
    private StsReader sts;
    private int NumIntervals;
    private int[][][][] dataArray;
    private StreamTokenizer tokenizer;
    private long[][] ChareTime;
    private int[][] NumEntryMsgs;
    private int PhaseCount;
    private long IntervalSize;
    private int IntervalCount;
    private long TotalTime;
    private long[][][] PhaseChareTime;
    private int[][][] PhaseNumEntryMsgs;
    private int[][] ProcessorUtilization;

    public SumAnalyzer(StsReader stsReader) throws IOException, SummaryFormatException {
        this.sts = stsReader;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        this.IntervalCount = 0;
        this.TotalTime = 0L;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            FileReader fileReader = new FileReader(this.sts.getSumName(n4));
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.tokenizer = new StreamTokenizer(bufferedReader);
            this.tokenizer.parseNumbers();
            this.tokenizer.eolIsSignificant(true);
            this.tokenizer.whitespaceChars(47, 47);
            this.tokenizer.whitespaceChars(58, 58);
            this.tokenizer.whitespaceChars(91, 91);
            this.tokenizer.whitespaceChars(93, 93);
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.checkNextString("ver");
            n3 = (int)this.nextNumber("Version Number");
            int n6 = (int)this.nextNumber("processor number");
            n = (int)this.nextNumber("number of processors");
            this.checkNextString("count");
            int n7 = (int)this.nextNumber("count");
            if (this.IntervalCount < n7) {
                this.IntervalCount = n7;
            }
            this.checkNextString("ep");
            n2 = (int)this.nextNumber("number of entry methods");
            this.checkNextString("interval");
            double d = this.nextScientific("processor usage sample interval");
            this.IntervalSize = (long)Math.floor(d * 1000000.0);
            if (this.TotalTime < (long)this.IntervalCount * this.IntervalSize) {
                this.TotalTime = (long)this.IntervalCount * this.IntervalSize;
            }
            if (n3 > 2) {
                this.checkNextString("phases");
                this.PhaseCount = (int)this.nextNumber("phases");
            } else {
                this.PhaseCount = 1;
            }
            if (10 != this.tokenizer.nextToken()) {
                throw new SummaryFormatException("extra garbage at end of line 1");
            }
            if (n4 == 0) {
                this.ProcessorUtilization = new int[n][this.IntervalCount + 20];
                this.ChareTime = new long[n][n2];
                this.NumEntryMsgs = new int[n][n2];
            }
            int n8 = 0;
            while (-2 == (n5 = this.tokenizer.nextToken())) {
                this.ProcessorUtilization[n4][n8++] = (int)this.tokenizer.nval;
            }
            if (10 != n5) {
                throw new SummaryFormatException("extra garbage at end of line 2");
            }
            int n9 = 0;
            while (-2 == (n5 = this.tokenizer.nextToken()) && n2 > n9) {
                this.ChareTime[n4][n9] = (int)this.tokenizer.nval;
                ++n9;
            }
            if (10 != n5) {
                throw new SummaryFormatException("extra garbage at end of line 3");
            }
            n9 = 0;
            while (-2 == (n5 = this.tokenizer.nextToken()) && n2 > n9) {
                this.NumEntryMsgs[n4][n9] = (int)this.tokenizer.nval;
                ++n9;
            }
            if (10 != n5) {
                throw new SummaryFormatException("extra garbage at end of line 4");
            }
            int n10 = (int)this.nextNumber("Number of Marked Events");
            int n11 = 0;
            while (n11 < n10) {
                this.nextNumber("Number of Marked Events");
                this.nextNumber("Number of Marked Events");
                ++n11;
            }
            if (10 != n5) {
                throw new SummaryFormatException("extra garbage at end of line 5");
            }
            if (this.PhaseCount > 1) {
                if (n4 == 0) {
                    this.PhaseChareTime = new long[this.PhaseCount][n][n2];
                    this.PhaseNumEntryMsgs = new int[this.PhaseCount][n][n2];
                }
                int n12 = 0;
                while (n12 < this.PhaseCount) {
                    n9 = 0;
                    this.tokenizer.nextToken();
                    this.tokenizer.nextToken();
                    while (-2 == (n5 = this.tokenizer.nextToken()) && n2 > n9) {
                        this.PhaseNumEntryMsgs[n12][n4][n9] = (int)this.tokenizer.nval;
                        ++n9;
                    }
                    if (10 != n5) {
                        throw new SummaryFormatException("extra garbage at end of line 3");
                    }
                    n9 = 0;
                    this.tokenizer.nextToken();
                    this.tokenizer.nextToken();
                    while (-2 == (n5 = this.tokenizer.nextToken()) && n2 > n9) {
                        this.PhaseChareTime[n12][n4][n9] = (int)this.tokenizer.nval;
                        ++n9;
                    }
                    if (10 != n5) {
                        throw new SummaryFormatException("extra garbage at end of line 4");
                    }
                    ++n12;
                }
            }
            this.tokenizer = null;
            fileReader.close();
            System.out.println("Finished reading in data for processor #" + n4);
            ++n4;
        }
        this.sts.setTotalTime(this.TotalTime);
    }

    private void checkNextString(String string) throws IOException, SummaryFormatException {
        String string2 = this.nextString(string);
        if (!string.equals(string2)) {
            throw new SummaryFormatException("Expected " + string + " got " + string2);
        }
    }

    public long[][] GetChareTime() {
        return this.ChareTime;
    }

    public int[][] GetNumEntryMsgs() {
        return this.NumEntryMsgs;
    }

    public long[][] GetPhaseChareTime(int n) {
        return this.PhaseChareTime[n];
    }

    public int GetPhaseCount() {
        return this.PhaseCount;
    }

    public int[][] GetPhaseNumEntryMsgs(int n) {
        return this.PhaseNumEntryMsgs[n];
    }

    public int[][] GetSystemUsageData(int n, long l) throws IOException, SummaryFormatException {
        int n2 = this.ProcessorUtilization.length;
        int[][] nArray = new int[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n5 < n) {
                if (n4 < this.ProcessorUtilization[n3].length) {
                    n6 += this.ProcessorUtilization[n3][n4];
                }
                ++n7;
                ++n4;
                if ((long)(n8 = (int)((long)n8 + this.IntervalSize)) < l) continue;
                nArray[n3][n5++] = n6 / n7;
                n8 = 0;
                n6 = 0;
                n7 = 0;
            }
            ++n3;
        }
        return nArray;
    }

    public long GetTotalTime() {
        return this.TotalTime;
    }

    private double nextNumber(String string) throws IOException, SummaryFormatException {
        if (-2 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read " + string);
        }
        return this.tokenizer.nval;
    }

    private double nextScientific(String string) throws IOException, SummaryFormatException {
        int n;
        double d = this.nextNumber(string + " mantissa");
        String string2 = this.nextString(string + " exponent");
        char c = string2.charAt(0);
        if (c != 'e' && c != 'd' && c != 'E' && c != 'D') {
            throw new SummaryFormatException("Couldn't find exponent in " + string2);
        }
        string2 = string2.substring(1);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SummaryFormatException("Couldn't parse exponent " + string2);
        }
        return d * Math.pow(10.0, n);
    }

    private String nextString(String string) throws IOException, SummaryFormatException {
        if (-3 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read string " + string);
        }
        return this.tokenizer.sval;
    }
}

