/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ColorPanel
extends Canvas
implements MouseListener {
    private int w;
    private int h;
    private Color background;
    private Color foreground;
    private int wDefault = 40;
    private int hDefault = 20;
    private boolean highlighted = false;
    private ActionListener actionListener = null;

    public ColorPanel(Color color) {
        this.background = Color.black;
        this.foreground = color;
        this.w = this.wDefault;
        this.h = this.hDefault;
        this.addMouseListener(this);
    }

    public ColorPanel(Color color, int n, int n2) {
        this.background = Color.black;
        this.foreground = color;
        this.w = n;
        this.h = n2;
        this.addMouseListener(this);
    }

    public ColorPanel(Color color, Color color2) {
        this.background = color;
        this.foreground = color2;
        this.w = this.wDefault;
        this.h = this.hDefault;
        this.addMouseListener(this);
    }

    public ColorPanel(Color color, Color color2, int n, int n2) {
        this.w = n;
        this.h = n2;
        this.background = color;
        this.foreground = color2;
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public Color getColor() {
        return this.foreground;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.w, this.h);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.w, this.h);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.processActionEvent();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.highlighted) {
            this.highlighted = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.highlighted) {
            this.highlighted = false;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.background);
        graphics.fillRect(0, 0, this.w, this.h);
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, this.w, 0);
        graphics.drawLine(0, 1, this.w, 1);
        graphics.drawLine(0, 0, 0, this.h);
        graphics.drawLine(1, 0, 1, this.h);
        graphics.setColor(Color.white);
        graphics.drawLine(0, this.h, this.w, this.h);
        graphics.drawLine(0, this.h - 1, this.w, this.h - 1);
        graphics.drawLine(this.w, this.h, this.w, 0);
        graphics.drawLine(this.w - 1, this.h, this.w - 1, 0);
        graphics.setColor(this.foreground);
        graphics.fillRect(5, 5, this.w - 10, this.h - 10);
        if (this.highlighted) {
            graphics.setColor(this.foreground.brighter().brighter());
            graphics.drawRect(5, 5, this.w - 10, this.h - 10);
        }
    }

    public void processActionEvent() {
        if (this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "ColorPanel Action");
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setColor(Color color) {
        this.foreground = color;
        this.repaint();
    }
}

