/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import projections.gui.GraphData;
import projections.gui.OrderedGraphDataList;
import projections.gui.ZItem;

public class GraphDisplayCanvas
extends Canvas {
    private GraphData data;
    private OrderedGraphDataList graphDataList;
    private Image offscreen;

    public GraphDisplayCanvas() {
        this.setBackground(Color.black);
    }

    private void addDataForBar(ZItem zItem, int n) {
        int n2 = this.getSize().height;
        int n3 = this.data.xmode == 0 ? zItem.curPData[n] : zItem.curIData[n];
        n3 = zItem.ymode == 12 ? n2 - (int)(this.data.wscale * (double)n3) : n2 - (int)(this.data.yscale * (double)n3);
        this.graphDataList.insert(n3, zItem.color);
    }

    private void drawDisplay(Graphics graphics) {
        if (this.data == null) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.clearRect(0, 0, n, n2);
        graphics.translate(-this.data.displayPanel.getHSBValue(), 0);
        if (this.data.graphtype == 20) {
            int n3 = 0;
            while (n3 < this.data.onGraph.length) {
                if (this.data.ymode == 11) {
                    if (this.data.onGraph[n3].ymode != 10) {
                        this.drawItemLine(graphics, this.data.onGraph[n3]);
                    }
                } else if (this.data.onGraph[n3].ymode != 11) {
                    this.drawItemLine(graphics, this.data.onGraph[n3]);
                }
                ++n3;
            }
        } else {
            this.graphDataList = new OrderedGraphDataList();
            int n4 = this.data.minx;
            while (n4 <= this.data.maxx) {
                this.graphDataList.removeAll();
                int n5 = 0;
                while (n5 < this.data.onGraph.length) {
                    if (this.data.ymode == 11) {
                        if (this.data.onGraph[n5].ymode != 10) {
                            this.addDataForBar(this.data.onGraph[n5], n4);
                        }
                    } else if (this.data.onGraph[n5].ymode != 11) {
                        this.addDataForBar(this.data.onGraph[n5], n4);
                    }
                    ++n5;
                }
                this.drawItemBar(graphics, n4);
                ++n4;
            }
        }
    }

    private void drawItemBar(Graphics graphics, int n) {
        int n2 = (int)(this.data.xscale * (double)n);
        int n3 = (int)(this.data.xscale * (double)(n + 1)) - n2 - 1;
        if (n3 < 1) {
            n3 = 1;
        }
        n2 += this.data.offset3;
        this.graphDataList.reset();
        while (this.graphDataList.hasMoreElements()) {
            int n4 = this.graphDataList.currentY();
            Color color = this.graphDataList.currentC();
            int n5 = this.getSize().height - n4;
            if (n5 > 0) {
                graphics.setColor(color);
                graphics.fillRect(n2, n4, n3, n5);
            }
            this.graphDataList.nextElement();
        }
    }

    private void drawItemLine(Graphics graphics, ZItem zItem) {
        graphics.setColor(zItem.color);
        int n = -1;
        int n2 = -1;
        int n3 = this.getSize().height;
        int n4 = this.data.minx;
        while (n4 <= this.data.maxx) {
            boolean bl = false;
            int n5 = this.data.offset3 + (int)((double)n4 * this.data.xscale);
            int n6 = this.data.xmode == 0 ? zItem.curPData[n4] : zItem.curIData[n4];
            n6 = zItem.ymode == 12 ? n3 - (int)(this.data.wscale * (double)n6) : n3 - (int)(this.data.yscale * (double)n6);
            if (n2 >= 0 && (n6 != n3 || n != n6)) {
                graphics.drawLine(n2, n, n5, n6);
            }
            n2 = n5;
            n = n6;
            ++n4;
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            return;
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        this.drawDisplay(graphics2);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.drawImage(this.offscreen, 0, 0, n, n2, 0, 0, n, n2, null);
    }

    public void print(Graphics graphics) {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.drawDisplay(graphics);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.getSize().width != n3 || this.getSize().height != n4) {
            try {
                this.offscreen = this.createImage(n3, n4);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.out.println("NOT ENOUGH MEMORY!");
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void setData(GraphData graphData) {
        this.data = graphData;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

