/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import projections.gui.MainWindow;
import projections.gui.Util;

public class HelpWindow
extends Frame
implements ActionListener {
    private MainWindow mainWindow;

    public HelpWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HelpWindow.this.setVisible(false);
            }
        });
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Close"}, this));
        Menu menu = new Menu("Help");
        menuBar.add(Util.makeMenu(menu, new Object[]{"About"}, this));
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
        TextArea textArea = new TextArea("", 100, 100, 1);
        textArea.setEditable(false);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("HelpWindow.txt")));
            while ((string = bufferedReader.readLine()) != null) {
                textArea.append(string + "\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.add((Component)textArea, "Center");
        this.pack();
        this.setTitle("Projections Help");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getLabel();
            if (string.equals("Close")) {
                this.dispose();
            } else if (string.equals("About")) {
                this.mainWindow.ShowAboutDialog(this);
            }
        }
    }
}

