/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ScaleSlider
extends Canvas
implements MouseMotionListener,
MouseListener {
    private double min = 0.0;
    private double value = 0.0;
    private double max = 100.0;
    private double tickStart = 0.0;
    private double tickSep = 10.0;
    private int orient;
    private ValueListener myListener;
    private int hw = 7;
    private int totalThickness = 16;
    private double val2slope;
    private double val2offset;
    private double coor2slope;
    private double coor2offset;
    private Image offscreen;
    private int off_w = -1;
    private int off_h = -1;

    public ScaleSlider(int n) {
        this.orient = n;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private final double coor2val(int n) {
        return this.coor2slope * (double)n + this.coor2offset;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.totalThickness, this.totalThickness);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.totalThickness, this.totalThickness);
    }

    public double getValue() {
        return this.value;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateValue(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.updateValue(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateValue(mouseEvent);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        if (this.off_w != n2 || this.off_h != n3) {
            this.off_w = n2;
            this.off_h = n3;
            this.offscreen = this.createImage(this.off_w, this.off_h);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        if (this.orient == 1) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        this.setVal2coor(n2);
        int[] nArray = new int[]{0, 0, 0, n3, n2, n3, n2, 0};
        this.poly(graphics2, nArray, Color.black, true, 0, 0);
        int n5 = 2;
        int n6 = n3 - 4;
        int[] nArray2 = new int[]{this.hw, 0, this.hw, n5, n2 - this.hw, n6, n2 - this.hw, 0};
        this.poly(graphics2, nArray2, Color.blue, true, 0, 0);
        double d = this.tickStart;
        while ((n = this.val2coor(d)) <= n2 - this.hw) {
            int[] nArray3 = new int[]{n, 0, n, n3};
            this.poly(graphics2, nArray3, Color.black, false, 0, 0);
            d += this.tickSep;
        }
        n = this.val2coor(this.value);
        int n7 = 1;
        int n8 = n7 + this.hw;
        int n9 = n3 - 3;
        int[] nArray4 = new int[]{n + this.hw, n8, n + this.hw, n9, n - this.hw, n9, n - this.hw, n8, n, n7};
        this.poly(graphics2, nArray4, Color.lightGray, true, 0, 0);
        int[] nArray5 = new int[]{nArray4[8], nArray4[9], nArray4[0], nArray4[1]};
        this.poly(graphics2, nArray5, Color.gray, false, 0, 0);
        int[] nArray6 = new int[]{nArray4[4], nArray4[5], nArray4[6], nArray4[7], nArray4[8], nArray4[9]};
        this.poly(graphics2, nArray6, Color.white, false, 0, 0);
        int[] nArray7 = new int[]{nArray4[0], nArray4[1], nArray4[2], nArray4[3], nArray4[4], nArray4[5]};
        this.poly(graphics2, nArray7, Color.darkGray, false, 0, 0);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    private void poly(Graphics graphics, int[] nArray, Color color, boolean bl, int n, int n2) {
        int[] nArray2 = new int[nArray.length / 2];
        int[] nArray3 = new int[nArray.length / 2];
        graphics.setColor(color);
        int n3 = 0;
        int n4 = 1;
        if (this.orient == 1) {
            n3 = 1;
            n4 = 0;
        }
        int n5 = 0;
        while (n5 < nArray2.length) {
            nArray2[n5] = nArray[n5 * 2 + n3] + n;
            nArray3[n5] = nArray[n5 * 2 + n4] + n2;
            ++n5;
        }
        if (bl) {
            graphics.fillPolygon(nArray2, nArray3, nArray2.length);
        } else {
            graphics.drawPolyline(nArray2, nArray3, nArray2.length);
        }
    }

    public void setMax(double d) {
        this.max = d;
        this.repaint();
    }

    public void setMin(double d) {
        this.min = d;
        this.repaint();
    }

    public void setTicks(double d, double d2) {
        this.tickStart = d;
        this.tickSep = d2;
        this.repaint();
    }

    private void setVal2coor(int n) {
        this.val2slope = (double)(n - 2 * this.hw) / (this.max - this.min);
        this.val2offset = (double)this.hw - this.val2slope * this.min;
        this.coor2slope = 1.0 / this.val2slope;
        this.coor2offset = -this.val2offset / this.val2slope;
    }

    public void setValue(double d) {
        this.value = d;
        this.repaint();
    }

    public void setValueListener(ValueListener valueListener) {
        this.myListener = valueListener;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void updateValue(MouseEvent mouseEvent) {
        double d;
        double d2;
        int n = mouseEvent.getX();
        if (this.orient == 1) {
            n = mouseEvent.getY();
        }
        if ((d2 = this.coor2val(n)) < this.min) {
            d2 = this.min;
        }
        if (d2 > this.max) {
            d2 = this.max;
        }
        if (d2 != (d = this.getValue())) {
            this.setValue(d2);
            if (this.myListener != null) {
                this.myListener.sliderChanged(this);
            }
        }
    }

    private final int val2coor(double d) {
        return (int)(this.val2slope * d + this.val2offset + 0.5);
    }

    public static interface ValueListener {
        public void sliderChanged(ScaleSlider var1);
    }
}

