/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import projections.gui.Analysis;
import projections.gui.ScalePanel;
import projections.gui.U;

public class StlPanel
extends ScalePanel.Child {
    private int[][] data;
    private int intervalSize;
    private int nPe;
    private long totalTime;
    private ColorModel colorMap;

    public String getPointInfo(double d, double d2) {
        int n = (int)d2;
        if (n < 0 || n >= this.nPe || d2 < 0.0) {
            return "";
        }
        long l = (long)d;
        if (l < 0L || l >= this.totalTime) {
            return "";
        }
        int n2 = this.data[n][(int)(l / (long)this.intervalSize)];
        return "Processor " + n + ": Usage = " + n2 + "%" + " at " + U.t(l) + " (" + l + " us). ";
    }

    public void paint(ScalePanel.Child.RepaintRequest repaintRequest) {
        double d = repaintRequest.y(1.0) - repaintRequest.y(0.0);
        double d2 = repaintRequest.x(1.0) - repaintRequest.x(0.0);
        double d3 = 1.0 / d;
        double d4 = 1.0 / d2;
        double d5 = repaintRequest.xInv(0.0);
        double d6 = repaintRequest.xInv(repaintRequest.w - 1);
        double d7 = repaintRequest.yInv(0.0);
        double d8 = repaintRequest.yInv(repaintRequest.h - 1);
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        if (d6 >= (double)this.totalTime) {
            d6 = (double)this.totalTime - 0.001;
        }
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        if (d8 >= (double)this.nPe) {
            d8 = (double)this.nPe - 0.001;
        }
        int n = (int)Math.ceil(repaintRequest.x(d5));
        int n2 = (int)Math.floor(repaintRequest.x(d6));
        int n3 = (int)Math.ceil(repaintRequest.y(d7));
        int n4 = (int)Math.floor(repaintRequest.y(d8));
        int n5 = n2 - n;
        int n6 = n4 - n3;
        double d9 = repaintRequest.xInv(n) / (double)this.intervalSize;
        double d10 = d4 / (double)this.intervalSize;
        if (n5 > 0 && n6 > 0) {
            byte[] byArray = new byte[n5 * n6];
            int n7 = (int)Math.floor(d7);
            int n8 = (int)Math.ceil(d8);
            int n9 = n7;
            while (n9 < n8) {
                int n10 = (int)Math.floor(repaintRequest.y(n9));
                int n11 = (int)Math.floor(repaintRequest.y(n9 + 1));
                if (n10 < n3) {
                    n10 = n3;
                }
                if (n11 > n4) {
                    n11 = n4;
                }
                this.renderRow(this.data[n9], d9, d10, byArray, n5, n10 - n3, n11 - n3, 0, n2 - n);
                ++n9;
            }
            Image image = this.createImage(new MemoryImageSource(n5, n6, this.colorMap, byArray, 0, n5));
            repaintRequest.g.drawImage(image, n, n3, null);
        }
        repaintRequest.g.setColor(Color.black);
        repaintRequest.g.fillRect(0, 0, n, n4);
        repaintRequest.g.fillRect(n, 0, repaintRequest.w, n3);
        repaintRequest.g.fillRect(n2, n3, repaintRequest.w, n4);
        repaintRequest.g.fillRect(0, n4, repaintRequest.w, repaintRequest.h);
    }

    private void renderRow(int[] nArray, double d, double d2, byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = (int)(65536.0 * d);
        int n7 = (int)(65536.0 * d2);
        int n8 = n6 + n4 * n7;
        int n9 = n4;
        while (n9 < n5) {
            byte by = (byte)nArray[n8 >> 16];
            n8 += n7;
            int n10 = n2 * n + n9;
            int n11 = n2;
            while (n11 < n3) {
                byArray[n10] = by;
                ++n11;
                n10 += n;
            }
            ++n9;
        }
    }

    public void setColorMap(ColorModel colorModel) {
        this.colorMap = colorModel;
        this.repaint();
    }

    public void setData(int n) {
        this.totalTime = Analysis.getTotalTime();
        this.intervalSize = (int)(this.totalTime / (long)n);
        Analysis.LoadGraphData(n, this.intervalSize, false);
        this.data = Analysis.getSystemUsageData(1);
        this.nPe = this.data.length;
        this.repaint();
    }
}

