/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.text.NumberFormat;
import projections.gui.TimelineData;

public class TimelineLabelCanvas
extends Canvas {
    private TimelineData data;
    private FontMetrics fm;
    private Image offscreen;

    public TimelineLabelCanvas(TimelineData timelineData) {
        this.data = timelineData;
        this.setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void makeNewImage() {
        this.offscreen = null;
        if (this.data.lcw > 0 && this.data.tlh > 0) {
            this.offscreen = this.createImage(this.data.lcw, this.data.tlh);
            if (this.offscreen == null) {
                return;
            }
            Graphics graphics = this.offscreen.getGraphics();
            graphics.setClip(0, 0, this.data.lcw, this.data.tlh);
            if (this.fm == null) {
                this.fm = graphics.getFontMetrics(graphics.getFont());
                this.data.lcw = this.fm.stringWidth("Processor 999") + 20;
            }
            graphics.setColor(this.getForeground());
            this.data.processorList.reset();
            NumberFormat numberFormat = NumberFormat.getInstance();
            int n = 0;
            while (n < this.data.numPs) {
                graphics.setColor(this.getForeground());
                String string = "Processor " + this.data.processorList.nextElement();
                graphics.drawString(string, 10, this.data.tluh / 2 + n * this.data.tluh);
                graphics.setColor(Color.lightGray);
                string = "(" + numberFormat.format(this.data.processorUsage[n]) + "%)";
                graphics.drawString(string, 20, this.data.tluh / 2 + n * this.data.tluh + this.fm.getHeight() + 2);
                ++n;
            }
            graphics.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen != null) {
            int n = this.data.timelineWindow.getVSBValue();
            graphics.drawImage(this.offscreen, 0, 0, this.data.lcw, this.data.vph, 0, n, this.data.lcw, n + this.data.vph, null);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

