#include "ampi.h"

extern "C"
void AMPI_Main(int argc,char **argv)
{
	AMPI_Init(&argc,&argv);
	double inval,outval;
	int rank,size;
	AMPI_Print("Driver called");
	AMPI_Comm_rank(AMPI_COMM_WORLD, &rank);
	AMPI_Comm_size(AMPI_COMM_WORLD, &size);
	inval = rank+1;
	AMPI_Reduce(&inval, &outval, 1, AMPI_DOUBLE, AMPI_SUM, 
                     0, AMPI_COMM_WORLD);
	int expect = (size*(size+1))/2;
	if(rank == 0) {
	  if (outval == expect) 
  	    AMPI_Print("reduce test passed");
  	  else
  	    AMPI_Print("reduce test failed");
	}
	AMPI_Finalize();
}
