! Sample migration FEM program
     MODULE my_block_mod 
       TYPE my_block 
         INTEGER :: n1,n2x,n2y 
         REAL*8, POINTER, DIMENSION(:) :: arr1 
         INTEGER, POINTER, DIMENSION(:,:) :: arr2 
       END TYPE my_block
     END MODULE my_block_mod

     SUBROUTINE pup_my_block(p,m) 
       USE my_block_mod 
       USE pupmod 
       IMPLICIT NONE 
       INTEGER :: p 
       TYPE(my_block) :: m
       call fpup_int(p,m%n1) 
       call fpup_int(p,m%n2x) 
       call fpup_int(p,m%n2y) 
       IF (fpup_isUnpacking(p)) THEN
         ALLOCATE(m%arr1(m%n1)) 
         ALLOCATE(m%arr2(m%n2x,m%n2y)) 
       END IF 
       call fpup_doubles(p,m%arr1,m%n1) 
       call fpup_ints(p,m%arr2,m%n2x*m%n2y) 
       IF (fpup_isDeleting(p)) THEN
         DEALLOCATE(m%arr1) 
         DEALLOCATE(m%arr2) 
       END IF 
     END SUBROUTINE

subroutine init()
implicit none
include 'femf.h'
  integer :: conn(4,4)
  conn(:,:)=1

  call FEM_Print('Init routine called');
  call FEM_Set_Mesh(4,1,4,conn)
end subroutine init

subroutine driver()
use my_block_mod
implicit none
include 'femf.h'
   interface
    subroutine pup_my_block(p,m)
      use my_block_mod
      INTEGER :: p
      TYPE(my_block) :: m
    end subroutine
  end interface

  integer  :: i,j,t,myId,udId
  TYPE(my_block) :: m

  call FEM_Print('Init routine called');

! Allocate and register heap data
  myId=FEM_My_Partition()
  udId=FEM_Register(m,pup_my_block)
  m%n1=93+40*myId
  m%n2x=13+9*myId
  m%n2y=15+12*myId
  ALLOCATE(m%arr1(m%n1))
  ALLOCATE(m%arr2(m%n2x,m%n2y))
  do i=1,m%n1
     m%arr1(i)=myId+i*i
  end do
  do i=1,m%n2x
    do j=1,m%n2y
      m%arr2(i,j)=myId+i*j
    end do
  end do

! Time loop-- migrate and re-check
  do t=1,20
    call FEM_Print('About to migrate')
    call FEM_Migrate
    call FEM_Print('Returned from migrate')
    
    do i=1,m%n1
     if (m%arr1(i) .ne. myId+i*i) then
       call FEM_Print('m%arr1 corrupted during migration!')
     end if
    end do
    do i=1,m%n2x
      do j=1,m%n2y
        if (m%arr2(i,j) .ne. myId+i*j) then
          call FEM_Print('m%arr2 corrupted during migration!')
        end if
      end do
    end do
  end do

end subroutine driver

subroutine mesh_updated(ts)
  implicit none
  include 'femf.h'
  integer ::ts
  call FEM_Print('mesh_updated called')
end subroutine

subroutine finalize()
  implicit none
  include 'femf.h'
  call FEM_Print('finalize called')
end subroutine
