!     ! 10        20        30        40        50        60        70
!23456789_C23456789_C23456789_C23456789_C23456789_C23456789_C23456789_

! *******************************************************************
! *                                                                 *
! *  SUBROUTINE:    cst_NL.f90                                      *
! *                                                                 *
! *  Date:     May 10, 2001                                         *
! *                                                                 *
! *      - subroutine for nonlinear elastic CST elements            *
! *                                                                 *
! *******************************************************************
      SUBROUTINE CST_NL_2( coor, lm, R_net, d, c, numnp, numel, S11o,S22o,S12o)

      implicit none

      integer numnp,               & ! number of nodal points
              numel,               & ! number of CST elements
              lm(3,numel),         & ! connectivity table for CST elem
              n1,n2,n3,            & ! node numbers
              i                  ! dummy and counters
      
      REAL*8, DIMENSION(2,numnp) :: coor      
      REAL*8, DIMENSION(2*numnp) ::    &
              R_net,                       &
              d 

      real*8 c(4),       & ! elastic stiffness constants
             S11,S11o(numel),           & ! CST stress
             S22,S22o(numel),           & !   "
             S12,S12o(numel),           & !   "
             u1,                   & ! x and y displacements of nodes
             u2,                   & !      "
             u3,                   & !      "
             v1,                   & !      "
             v2,                   & !      "
             v3,                   & !      "
             x21,                  & ! coor(1,n2)-coor(1,n1)
             y21,                  & !      "
             x31,                  & !      "
             y31,                  & !      "
             x32,                  & !      "
             y32,                  & !      "
             aa,                   & ! 2*area and the area
             B1,B2,B3,B4,B5,B6,    & ! spacial derivatives
             dudx,dvdy,dudy,dvdx,  & ! partial derivatives of disp
             E11,E22,E12             ! strains



      ! Loop over all the volumetric elements
      do i = 1,numel

          n1 = lm(1,i)
          n2 = lm(2,i)
          n3 = lm(3,i)

          ! Take care of subcycling here as well
            u1 = d(n1*2-1)
            u2 = d(n2*2-1)
            u3 = d(n3*2-1)
            v1 = d(n1*2)
            v2 = d(n2*2)
            v3 = d(n3*2)

          x21 = coor(1,n2)-coor(1,n1)
          y21 = coor(2,n2)-coor(2,n1)
          x31 = coor(1,n3)-coor(1,n1)
          y31 = coor(2,n3)-coor(2,n1)
          x32 = coor(1,n3)-coor(1,n2)
          y32 = coor(2,n3)-coor(2,n2)

          aa = x21*y31-x31*y21
          B1 = -y32/aa
          B2 = x32/aa
          B3 = y31/aa
          B4 = -x31/aa
          B5 = -y21/aa
          B6 = x21/aa

          dudx = B1*u1 + B3*u2 + B5*u3
          dvdy = B2*v1 + B4*v2 + B6*v3
          dudy = B2*u1 + B4*u2 + B6*u3
          dvdx = B1*v1 + B3*v2 + B5*v3
          E11 = dudx + 0.5d0*(dudx*dudx + dvdx*dvdx)
          E22 = dvdy + 0.5d0*(dvdy*dvdy + dudy*dudy)
          E12 = dudy + dvdx + dudx*dudy + dvdy*dvdx

          ! Calculate CST stresses
          S11 = E11*c(1) + E22*c(2)
          S22 = E11*c(2) + E22*c(3)
          S12 = E12*c(4)
          S11o(i)=S11
          S22o(i)=S22
          S12o(i)=S12

          ! Calculate R-internal force vector
          R_net(2*n1-1) = R_net(2*n1-1) - aa*0.5d0*(   &
               S11*B1*(1.d0+dudx) +                 &
               S22*B2*dudy +                        &
               S12*(B2*(1.d0+dudx) + B1*dudy))
          R_net(2*n1) = R_net(2*n1) - aa*0.5d0*(       &
               S11*B1*dvdx +                        &
               S22*B2*(1.d0+dvdy) +                 &
               S12*(B1*(1.d0+dvdy)+B2*dvdx))           
          R_net(2*n2-1) = R_net(2*n2-1) - aa*0.5d0*(   &
               S11*B3*(1.d0+dudx) +                 &
               S22*B4*dudy +                        &
               S12*(B4*(1.d0+dudx) + B3*dudy))
          R_net(2*n2) = R_net(2*n2) - aa*0.5d0*(       &
               S11*B3*dvdx +                        &
               S22*B4*(1.d0+dvdy) +                 &
               S12*(B3*(1.d0+dvdy)+B4*dvdx))           
          R_net(2*n3-1) = R_net(2*n3-1) - aa*0.5d0*(   &
               S11*B5*(1.d0+dudx) +                 &
               S22*B6*dudy +                        &
               S12*(B6*(1.d0+dudx) + B5*dudy))
          R_net(2*n3) = R_net(2*n3) - aa*0.5d0*(       &
               S11*B5*dvdx +                        &
               S22*B6*(1.d0+dvdy) +                 &
               S12*(B5*(1.d0+dvdy)+B6*dvdx))           

      enddo    ! End looping over elements (1,numel)
    
      return

      end subroutine cst_NL_2
