subroutine init()
implicit none
include 'mblockf.h'
   integer :: err
   integer :: nBlocks
   character*120 :: blockPrefix

! Read the global parameter file
   call MBLK_Print('Reading parameter file...')
   open(20, file='poisson.key')
   read(20,*) blockPrefix,nBlocks
   close(20)
   call MBLK_Set_prefix(blockPrefix,err)
   call MBLK_Set_nblocks(nBlocks,err)
   call MBLK_Set_dim(3,err)

   call MBLK_Print('Finished with init')
end subroutine init

! Boundary condition: impose the value 1.0 everywhere
subroutine BC_imposed(grid,dims,start,end)
implicit none
include 'mblockf.h'
  integer :: err ! Return value
  integer :: i,j,k
  integer :: dims(3)
  double precision :: grid(dims(1),dims(2),dims(3))
  integer :: start(3), end(3), si,sj,sk, ei,ej,ek ! My interior region
  integer,parameter :: ghostWidth=1;

  si=ghostWidth+start(1); sj=ghostWidth+start(2); sk=ghostWidth+start(3); 
  ei=ghostWidth+end(1);   ej=ghostWidth+end(2);   ek=ghostWidth+end(3); 
  do i=si,ei
     do j=sj,ej
        do k=sk,ek
           grid(i,j,k)=1.0;
        end do
     end do
  end do
end subroutine

subroutine driver()
implicit none
include 'mblockf.h'
  external :: BC_imposed
  integer :: err ! Return value
  integer :: blockNo
  integer :: i,j,k,c(3)  ! loop counters
  integer :: size(3),ni,nj,nk ! Allocated grid size
  integer :: si,sj,sk, ei,ej,ek ! My interior region
  double precision, allocatable :: grid(:,:,:),newGrid(:,:,:)
  integer :: tStep,nSteps ! Current and number of time steps
  integer :: fid
  integer,parameter :: ghostWidth=1;

! Sucessive over-relaxation parameters
  double precision :: w, cenWeight, neighWeight
  double precision :: total,sum
  integer :: nSum

! Read parameters
  nSteps=10 ! hardcoded sim. length (should come from parameter file)
  w=2.0-0.1 ! SOR parameter
  cenWeight=1.0-w
  neighWeight=0.25*w

! Allocate and initialize grid
  call MBLK_Get_myblock(blockNo,err)
  call MBLK_Get_blocksize(size,err)
  write(outstr,*) 'Entered driver',size(1),size(2),size(3)
  call MBLK_Print(outstr)

  ni=size(1)+2*ghostWidth; 
  nj=size(2)+2*ghostWidth; 
  nk=size(3)+2*ghostWidth;
  si=1+ghostWidth; sj=1+ghostWidth; sk=1+ghostWidth;
  ei=si+size(1)-1;   ej=sj+size(2)-1;   ek=sk+size(3)-1; 
  
  ALLOCATE(grid(ni,nj,nk),newGrid(ni,nj,nk))

  grid(:,:,:)=0.0
  newGrid(:,:,:)=0.0

  size(1)=ni; size(2)=nj; size(3)=nk;
  call MBLK_Create_field(&
       &size,1, MBLK_DOUBLE,1,&
       &offsetof(grid(1,1,1),grid(si,sj,sk)),&
       &offsetof(grid(1,1,1),grid(2,1,1)),fid,err)

! Register boundary condition functions
  call MBLK_Register_bc(0,ghostWidth,BC_imposed,err)

  call MBLK_Print('Beginning time loop')
  do tStep=1,nSteps
     call MBLK_Apply_bc_all(grid,size,err)

     call MBLK_Update_field(fid,ghostWidth,grid,err)

     do k=sk,ek
        do j=sj,ej
           do i=si,ei
              ! Only relax along I and J directions-- not K
              newGrid(i,j,k)=cenWeight*grid(i,j,k)&
               &+neighWeight*(grid(i+1,j,k)+grid(i,j+1,k)+grid(i-1,j,k)+grid(i,j-1,k))
           end do
        end do
     end do
! Copy the new grid back onto the old one (should do this with a simple pointer flip)
     grid(:,:,:)=newGrid(:,:,:)
  end do

  call MBLK_Print('Done with driver')

end subroutine driver

