#include "SimJob.h"
#include "heap.h"

extern double time;
extern minHeap * h;
extern int systemJobType;

extern Random *minpe, *workgen, *profitgen, *deadlinegen; 

int maxid = 0;          //!!Change later.

#include <math.h>
#define PI 3.1416

double SimJob::speedup(int p){
    return (double)p;
    
    double proc = p;
    
    double eff = 0.0;
    if( proc <= 1)
	eff = 1;
    else 
	eff = 47.77/ (proc + 52.3);
    
    return proc * eff;
}

double SimJob::speedup(int p, int njobs){
    /*
    if(njobs < 2)
	return speedup(p);
    else
	return speedup(p) / 1.3;
    */
    return speedup(p);
}

SimJob::SimJob(int np) : Job(np){
  
    arrivalTime = time;
    startTime = 0.0;

    previousEventTime = time;
    count = 0;
    
    max_proc = num_system_proc;

    switch(systemJobType){
    case MIGRATABLE:
	//min_proc = ((int) minpe->rand()) % ((num_system_proc*3)/4) + 1;
	//	min_proc = min_proc + num_system_proc/4;
	min_proc = ((int)minpe->rand()) % num_system_proc + 1;
	type = 0;
	break;
	
    case NON_MIGRATABLE:
	min_proc = ((int)minpe->rand()) % num_system_proc + 1;
	type = 1;
	break;
	
    case CONVENTIONAL:
	//	min_proc = ((int) minpe->rand())%((num_system_proc*3)/4)  + 1;
	//max_proc = min_proc = min_proc + num_system_proc/4;
	//	min_proc = max_proc = (num_system_proc + min_proc)/2;
	min_proc = ((int)minpe->rand()) % num_system_proc + 1;
	max_proc = min_proc;
	type = 2;
	break;
    }

    //work = min_proc * workgen->rand();     //CHECK!!!
    work =  speedup(num_system_proc) * (workgen->rand() * ITR_TIME);
    completionTime = time + work;
    dbid = maxid++;

    deadline = speedup(num_system_proc) * deadlinegen->rand() * ITR_TIME;
    profit = profitgen->rand();  
    req_min_proc = min_proc;
}

int SimJob::updateWork(){

    // Every Job has a startup cost which is constant and is independent of the number of processors.
    if((time >= startTime + STARTUP_TIME) && (previousEventTime - startTime <= STARTUP_TIME))
	previousEventTime = startTime + STARTUP_TIME;
	
    if(time >= startTime + STARTUP_TIME)
	work -= speedup(num_allocated_proc) * (time - previousEventTime);
    
    if(work < 0.0)
	work = 0.0;               //just in case due to precision problems.
    previousEventTime = time;
}

int SimJob::updateCompletionTime(){

    if(speedup(num_allocated_proc) == 0){
	printf("DIVIDE BY 0, %d\n", num_allocated_proc);
	exit(1);
    }
    
    if(time - startTime <= STARTUP_TIME)
	completionTime = startTime +  STARTUP_TIME + work/speedup(num_allocated_proc);
    else
	completionTime = time + work/speedup(num_allocated_proc);
    

    //schedule event for that time;

    count ++;
    Event * e = new Event();
    e->job = this;
    e->timeStamp = completionTime;
    e->eventType = JOBDONE;
    e->count = count;
    h->insert(e);
}





