#include "common.h"
#include <stdio.h>                 
#include <stdlib.h>
#include "mysql.h"

class DbInterface{

 private:
    MYSQL mysql;
    int nproc;
    
    Job *jobq;

    Job * fetch_jobs(int status);

 public:
    DbInterface();
    void set_nproc(int nproc);
    
    void connect(char *host, char *username, char *password);
    void connect(char *host, char *username, char *password, char *dbname);
    
    int insert_job(Job j);
    void update_pid(int id, int pid);
    void update_status(int id, int status);
    void update_bitmap(int id, char *bitmap);
    void update_startTime(int id, int startTime);
    void update_exitCode(int id, int code);

    void close();

    Job * fetch_running_jobs();
    Job * fetch_queued_jobs();
    int get_max_port();
    int get_exitCode(int id);

    void free_list(Job *);
};
