/*****************************************************************************
 * $Source: /cvsroot/charm/src/Common/ck-perf/trace-projections.C,v $
 * $Author: gzheng $
 * $Date: 2002/02/15 20:48:02 $
 * $Revision: 2.26 $
 *****************************************************************************/

#include "trace-projections.h"

#define DEBUGF(x)          // CmiPrintf x

CpvStaticDeclare(Trace*, _trace);
CpvStaticDeclare(LogPool*, _logPool);
CtvStaticDeclare(int,curThreadEvent);

static int _numEvents = 0;
static int warned = 0;
static int _threadMsg, _threadChare, _threadEP;

#ifdef CMK_OPTIMIZE
#define OPTIMIZED_VERSION 	\
	if (!warned) { warned=1; 	\
	CmiPrintf("\n\n!!!! Warning: traceUserEvent not availbale in optimized version!!!!\n\n\n"); }
#else
#define OPTIMIZED_VERSION /*empty*/
#endif

/*
On T3E, we need to have file number control by open/close files only when needed.
*/
#if CMK_TRACE_LOGFILE_NUM_CONTROL
#define OPEN_LOG  \
  do  {  \
    fp = fopen(fname, "a");   \
  } while (!fp && (errno == EINTR || errno == EMFILE)); 	\
  if(!fp) CmiAbort("Cannot open Projections Trace File for writing...\n");
#define CLOSE_LOG  fclose(fp);
#else
#define OPEN_LOG
#define CLOSE_LOG
#endif

void _createTraceprojections()
{
  DEBUGF(("%d createTraceProjections\n", CkMyPe()));
  CpvInitialize(Trace*, _trace);
  CpvAccess(_trace) = new  TraceProjections();
  CpvAccess(_traces)->addTrace(CpvAccess(_trace));
}

extern "C"
void traceProjectionsBeginIdle(void)
{
  CpvAccess(_trace)->beginIdle();
}

extern "C"
void traceProjectionsEndIdle(void)
{
  CpvAccess(_trace)->endIdle();
}

LogPool::LogPool(char *pgm, int b) {
  binary = b;
  pool = new LogEntry[CpvAccess(CtrLogBufSize)];
  numEntries = 0;
  poolSize = CpvAccess(CtrLogBufSize);
  char pestr[10];
  sprintf(pestr, "%d", CkMyPe());
  int len = strlen(pgm) + strlen(".log.") + strlen(pestr) + 1;
  fname = new char[len];
  sprintf(fname, "%s.%s.log", pgm, pestr);
  do
  {
    fp = fopen(fname, "w+");
  } while (!fp && (errno == EINTR || errno == EMFILE));
  if(!fp) {
    CmiAbort("Cannot open Projections Trace File for writing...\n");
  }
  if(!binary) {
    fprintf(fp, "PROJECTIONS-RECORD\n");
  }
  CLOSE_LOG 
}

LogPool::~LogPool() 
{
  if(binary) writeBinary();
  else write();
#if !CMK_TRACE_LOGFILE_NUM_CONTROL
  fclose(fp);
#endif
  delete[] pool;
  delete [] fname;
}

void LogPool::write(void) 
{
  OPEN_LOG
  for(UInt i=0; i<numEntries; i++)
    pool[i].write(fp);
  CLOSE_LOG
}

void LogPool::writeSts(void)
{
  char *fname = new char[strlen(CpvAccess(traceRoot))+strlen(".sts")+1];
  sprintf(fname, "%s.sts", CpvAccess(traceRoot));
  FILE *sts;
  do
  {
    sts = fopen(fname, "w");
  } while (!sts && (errno == EINTR || errno == EMFILE));
  if(sts==0)
    CmiAbort("Cannot open projections sts file for writing.\n");
  delete[] fname;
  fprintf(sts, "MACHINE %s\n",CMK_MACHINE_NAME);
  fprintf(sts, "PROCESSORS %d\n", CmiNumPes());
  fprintf(sts, "TOTAL_CHARES %d\n", _numChares);
  fprintf(sts, "TOTAL_EPS %d\n", _numEntries);
  fprintf(sts, "TOTAL_MSGS %d\n", _numMsgs);
  fprintf(sts, "TOTAL_PSEUDOS %d\n", 0);
  fprintf(sts, "TOTAL_EVENTS %d\n", _numEvents);
  int i;
  for(i=0;i<_numChares;i++)
    fprintf(sts, "CHARE %d %s\n", i, _chareTable[i]->name);
  for(i=0;i<_numEntries;i++)
    fprintf(sts, "ENTRY CHARE %d %s %d %d\n", i, _entryTable[i]->name,
                 _entryTable[i]->chareIdx, _entryTable[i]->msgIdx);
  for(i=0;i<_numMsgs;i++)
    fprintf(sts, "MESSAGE %d %d\n", i, _msgTable[i]->size);
  for(i=0;i<_numEvents;i++)
    fprintf(sts, "EVENT %d Event%d\n", i, i);
  fprintf(sts, "END\n");
  fclose(sts);
}

void LogPool::add(UChar type,UShort mIdx,UShort eIdx,double time,int event,int pe, int ml) 
{
  new (&pool[numEntries++])
    LogEntry(time, type, mIdx, eIdx, event, pe, ml);
  if(poolSize==numEntries) {
    double writeTime = CkTimer();
    if(binary) writeBinary(); else write();
    numEntries = 0;
    new (&pool[numEntries++]) LogEntry(writeTime, BEGIN_INTERRUPT);
    new (&pool[numEntries++]) LogEntry(CkTimer(), END_INTERRUPT);
  }
}

void LogEntry::write(FILE* fp)
{
  fprintf(fp, "%d ", type);

  switch (type) {
    case USER_EVENT:
      fprintf(fp, "%d %u %d %d\n", mIdx, (UInt) (time*1.0e6), event, pe);
      break;

    case BEGIN_IDLE:
    case END_IDLE:
    case BEGIN_PACK:
    case END_PACK:
    case BEGIN_UNPACK:
    case END_UNPACK:
      fprintf(fp, "%u %d\n", (UInt) (time*1.0e6), pe);
      break;

    case CREATION:
    case BEGIN_PROCESSING:
    case END_PROCESSING:
      fprintf(fp, "%d %d %u %d %d %d\n", mIdx, eIdx, (UInt) (time*1.0e6), event, pe, msglen);
      break;

    case ENQUEUE:
    case DEQUEUE:
      fprintf(fp, "%d %u %d %d\n", mIdx, (UInt) (time*1.0e6), event, pe);
      break;

    case BEGIN_INTERRUPT:
    case END_INTERRUPT:
      fprintf(fp, "%u %d %d\n", (UInt) (time*1.0e6), event, pe);
      break;

    case BEGIN_COMPUTATION:
    case END_COMPUTATION:
    fprintf(fp, "%u\n", (UInt) (time*1.0e6));
      break;

    default:
      CmiError("***Internal Error*** Wierd Event %d.\n", type);
      break;
  }
}

void LogEntry::writeBinary(FILE* fp)
{
  UInt ttime = (UInt) (time*1.0e6);

  fwrite(&type,sizeof(UChar),1,fp);

  switch (type) {
    case USER_EVENT:
      fwrite(&mIdx,sizeof(UShort),1,fp);
      fwrite(&ttime,sizeof(UInt),1,fp);
      fwrite(&event,sizeof(int),1,fp);
      fwrite(&pe,sizeof(int),1,fp);
      break;

    case BEGIN_IDLE:
    case END_IDLE:
    case BEGIN_PACK:
    case END_PACK:
    case BEGIN_UNPACK:
    case END_UNPACK:
      fwrite(&ttime,sizeof(UInt),1,fp);
      fwrite(&pe,sizeof(int),1,fp);
      break;

    case CREATION:
    case BEGIN_PROCESSING:
    case END_PROCESSING:
      fwrite(&mIdx,sizeof(UShort),1,fp);
      fwrite(&eIdx,sizeof(UShort),1,fp);
      fwrite(&ttime,sizeof(UInt),1,fp);
      fwrite(&event,sizeof(int),1,fp);
      fwrite(&pe,sizeof(int),1,fp);
      fwrite(&msglen,sizeof(int),1,fp);
      break;

    case ENQUEUE:
    case DEQUEUE:
      fwrite(&mIdx,sizeof(UShort),1,fp);
      fwrite(&ttime,sizeof(UInt),1,fp);
      fwrite(&event,sizeof(int),1,fp);
      fwrite(&pe,sizeof(int),1,fp);
      break;

    case BEGIN_INTERRUPT:
    case END_INTERRUPT:
      fwrite(&ttime,sizeof(UInt),1,fp);
      fwrite(&event,sizeof(int),1,fp);
      fwrite(&pe,sizeof(int),1,fp);
      break;

    case BEGIN_COMPUTATION:
    case END_COMPUTATION:
      fwrite(&ttime,sizeof(UInt),1,fp);
      break;

    default:
      CmiError("***Internal Error*** Wierd Event %d.\n", type);
      break;
  }
}

void TraceProjections::traceInit(char **argv)
{
  CpvInitialize(LogPool*, _logPool);
  CtvInitialize(int,curThreadEvent);
  CtvAccess(curThreadEvent)=0;
  int binary = CmiGetArgFlag(argv,"+binary-trace");
  CpvAccess(_logPool) = new LogPool(CpvAccess(traceRoot),binary);
}

int TraceProjections::traceRegisterUserEvent(const char*)
{
  OPTIMIZED_VERSION
  if(CmiMyPe()==0)
    return _numEvents++;
  else
    return 0;
}

void TraceProjections::traceClearEps(void)
{
  // In trace-summary, this zeros out the EP bins, to eliminate noise
  // from startup.  Here, this isn't useful, since we can do that in
  // post-processing
}

void TraceProjections::traceWriteSts(void)
{
  if(CmiMyPe()==0)
    CpvAccess(_logPool)->writeSts();
}

void TraceProjections::traceClose(void)
{
  CpvAccess(_trace)->endComputation();
  if(CmiMyPe()==0)
    CpvAccess(_logPool)->writeSts();
  delete CpvAccess(_logPool);
  delete CpvAccess(_trace);
  free(CpvAccess(traceRoot));
}

void TraceProjections::traceBegin(void)
{
  cancel_beginIdle = CcdCallOnConditionKeep(CcdPROCESSOR_BEGIN_IDLE,(CcdVoidFn)traceProjectionsBeginIdle,0);
  cancel_endIdle = CcdCallOnConditionKeep(CcdPROCESSOR_BEGIN_BUSY,(CcdVoidFn)traceProjectionsEndIdle,0);
}

void TraceProjections::traceEnd(void) 
{
  CcdCancelCallOnConditionKeep(CcdPROCESSOR_BEGIN_IDLE, cancel_beginIdle);
  CcdCancelCallOnConditionKeep(CcdPROCESSOR_BEGIN_BUSY, cancel_endIdle);
}

void TraceProjections::userEvent(int e)
{
  CpvAccess(_logPool)->add(USER_EVENT, e, 0, TraceTimer(),curevent++,CmiMyPe());
}

void TraceProjections::creation(envelope *e, int num)
{
  if(e==0) {
    CtvAccess(curThreadEvent)=curevent;
    CpvAccess(_logPool)->add(CREATION,ForChareMsg,_threadEP,TraceTimer(),
                             curevent++,CmiMyPe());
  } else {
    int type=e->getMsgtype();
    e->setEvent(curevent);
    for(int i=0; i<num; i++) {
      CpvAccess(_logPool)->add(CREATION,type,e->getEpIdx(),TraceTimer(),
                               curevent+i,CmiMyPe(),e->getTotalsize());
    }
    curevent += num;
  }
}

void TraceProjections::beginExecute(envelope *e)
{
  if(e==0) {
    execEvent = CtvAccess(curThreadEvent);
    execEp = (-1);
    CpvAccess(_logPool)->add(BEGIN_PROCESSING,ForChareMsg,_threadEP,TraceTimer(),
                             execEvent,CmiMyPe());
  } else {
    beginExecute(e->getEvent(),e->getMsgtype(),e->getEpIdx(),e->getSrcPe(),e->getTotalsize());
  }
}
void TraceProjections::beginExecute(int event,int msgType,int ep,int srcPe, int mlen)
{
  execEvent=event;
  execEp=ep;
  execPe=srcPe;
  CpvAccess(_logPool)->add(BEGIN_PROCESSING,msgType,ep,TraceTimer(),
                             event,srcPe, mlen);
}

void TraceProjections::endExecute(void)
{
  if(execEp == (-1)) {
    CpvAccess(_logPool)->add(END_PROCESSING,0,_threadEP,TraceTimer(),
                             execEvent,CmiMyPe());
  } else {
    CpvAccess(_logPool)->add(END_PROCESSING,0,execEp,TraceTimer(),
                             execEvent,execPe);
  }
}

void TraceProjections::beginIdle(void)
{
  if (isIdle == 0) {
    CpvAccess(_logPool)->add(BEGIN_IDLE, 0, 0, TraceTimer(), 0, CmiMyPe());
    isIdle = 1;
  }
}

void TraceProjections::endIdle(void)
{
  if (isIdle) {
    CpvAccess(_logPool)->add(END_IDLE, 0, 0, TraceTimer(), 0, CmiMyPe());
    isIdle = 0;
  }
}

void TraceProjections::beginPack(void)
{
  CpvAccess(_logPool)->add(BEGIN_PACK, 0, 0, TraceTimer(), 0, CmiMyPe());
}

void TraceProjections::endPack(void)
{
  CpvAccess(_logPool)->add(END_PACK, 0, 0, TraceTimer(), 0, CmiMyPe());
}

void TraceProjections::beginUnpack(void)
{
  CpvAccess(_logPool)->add(BEGIN_UNPACK, 0, 0, TraceTimer(), 0, CmiMyPe());
}

void TraceProjections::endUnpack(void)
{
  CpvAccess(_logPool)->add(END_UNPACK, 0, 0, TraceTimer(), 0, CmiMyPe());
}

void TraceProjections::beginCharmInit(void) {}

void TraceProjections::endCharmInit(void) {}

void TraceProjections::enqueue(envelope *) {}

void TraceProjections::dequeue(envelope *) {}

void TraceProjections::beginComputation(void)
{
  if(CmiMyRank()==0) {
    _threadMsg = CkRegisterMsg("dummy_thread_msg", 0, 0, 0, 0);
    _threadChare = CkRegisterChare("dummy_thread_chare", 0);
    _threadEP = CkRegisterEp("dummy_thread_ep", 0, _threadMsg,_threadChare);
  }
  CpvAccess(_logPool)->add(BEGIN_COMPUTATION, 0, 0, TraceTimer(), -1, -1);
}

void TraceProjections::endComputation(void)
{
  CpvAccess(_logPool)->add(END_COMPUTATION, 0, 0, TraceTimer(), -1, -1);
}
