/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import projections.analysis.Chare;
import projections.analysis.ProjDefs;
import projections.misc.LogLoadException;

public class StsReader
extends ProjDefs {
    private String baseName;
    private boolean hasSum;
    private boolean hasLog;
    private long totalTime;
    private int NumPe;
    private int EntryCount;
    private String[][] EntryNames;
    private int TotalChares;
    private int TotalMsgs;
    private String Machine;
    private String[] ClassNames;
    private Chare[] ChareList;
    private long[] MsgTable;

    public StsReader(String string) throws LogLoadException {
        this.baseName = string;
        this.hasSum = new File(this.getSumName(0)).isFile();
        this.hasLog = new File(this.getLogName(0)).isFile();
        this.totalTime = -1L;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string + ".sts")));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("MACHINE")) {
                    this.Machine = stringTokenizer.nextToken();
                    continue;
                }
                if (string3.equals("PROCESSORS")) {
                    this.NumPe = Integer.parseInt(stringTokenizer.nextToken());
                    continue;
                }
                if (string3.equals("TOTAL_CHARES")) {
                    this.TotalChares = Integer.parseInt(stringTokenizer.nextToken());
                    this.ChareList = new Chare[this.TotalChares];
                    this.ClassNames = new String[this.TotalChares];
                    continue;
                }
                if (string3.equals("TOTAL_EPS")) {
                    this.EntryCount = Integer.parseInt(stringTokenizer.nextToken());
                    this.EntryNames = new String[this.EntryCount][2];
                    continue;
                }
                if (string3.equals("TOTAL_MSGS")) {
                    this.TotalMsgs = Integer.parseInt(stringTokenizer.nextToken());
                    this.MsgTable = new long[this.TotalMsgs];
                    continue;
                }
                if (string3.equals("CHARE") || string2.equals("BOC")) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    this.ChareList[n] = new Chare();
                    this.ChareList[n].ChareID = n;
                    this.ChareList[n].NumEntries = 0;
                    this.ChareList[n].Name = stringTokenizer.nextToken();
                    this.ChareList[n].Type = new String(string3);
                    this.ClassNames[n] = this.ChareList[n].Name;
                    continue;
                }
                if (string3.equals("ENTRY")) {
                    String string4 = stringTokenizer.nextToken();
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    StringBuffer stringBuffer = new StringBuffer(stringTokenizer.nextToken());
                    String string5 = stringBuffer.toString();
                    if (-1 != string5.indexOf(40) && -1 == string5.indexOf(41)) {
                        String string6;
                        do {
                            string6 = stringTokenizer.nextToken();
                            stringBuffer.append(" ");
                            stringBuffer.append(string6);
                        } while (!string6.endsWith(")"));
                    }
                    string5 = stringBuffer.toString();
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    this.EntryNames[n][0] = string5;
                    this.EntryNames[n][1] = this.ClassNames[n2];
                    continue;
                }
                if (string3.equals("MESSAGE")) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    this.MsgTable[n] = n4;
                    continue;
                }
                if (string3.equals("END")) break;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LogLoadException(string + ".sts", 0);
        }
        catch (IOException iOException) {
            throw new LogLoadException(string + ".sts", 1);
        }
    }

    public int getEntryCount() {
        return this.EntryCount;
    }

    public String[][] getEntryNames() {
        return this.EntryNames;
    }

    public String getFilename() {
        return this.baseName;
    }

    public String getLogName(int n) {
        return this.baseName + "." + n + ".log";
    }

    public int getProcessorCount() {
        return this.NumPe;
    }

    public String getSumName(int n) {
        return this.baseName + "." + n + ".sum";
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public boolean hasLogFiles() {
        return this.hasLog;
    }

    public boolean hasSumFiles() {
        return this.hasSum;
    }

    public void setTotalTime(long l) {
        this.totalTime = l;
    }
}

