/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import projections.analysis.AsciiIntegerReader;
import projections.analysis.ProjDefs;
import projections.analysis.StsReader;

public class UsageCalc
extends ProjDefs {
    private long beginTime;
    private long endTime;
    private long startTime;
    private int pnum;
    private int dataLen;
    private long packtime;
    private long packstarttime;
    private long unpacktime;
    private long unpackstarttime;
    private int curEntry = -1;
    private int numUserEntries;

    private void intervalCalc(float[] fArray, int n, int n2, long l) {
        if (l < this.beginTime) {
            l = this.beginTime;
        }
        if (l > this.endTime) {
            l = this.endTime;
        }
        switch (n) {
            case 2: {
                this.packtime = 0L;
                this.unpacktime = 0L;
                this.curEntry = n2;
                this.startTime = l;
                break;
            }
            case 3: {
                int n3 = this.curEntry;
                fArray[n3] = fArray[n3] + (float)((int)(l - this.startTime - this.packtime - this.unpacktime));
                break;
            }
            case 14: {
                this.startTime = l;
                break;
            }
            case 15: {
                int n4 = this.numUserEntries;
                fArray[n4] = fArray[n4] + (float)((int)(l - this.startTime));
                break;
            }
            case 16: {
                this.packstarttime = l;
                break;
            }
            case 17: {
                this.packtime += l - this.packstarttime;
                int n5 = this.numUserEntries + 1;
                fArray[n5] = fArray[n5] + (float)((int)(l - this.packstarttime));
                break;
            }
            case 18: {
                this.unpackstarttime = l;
                break;
            }
            case 19: {
                this.unpacktime += l - this.unpackstarttime;
                int n6 = this.numUserEntries + 2;
                fArray[n6] = fArray[n6] + (float)((int)(l - this.unpackstarttime));
                break;
            }
        }
    }

    public float[] usage(StsReader stsReader, int n, long l, long l2) {
        this.beginTime = l;
        this.endTime = l2;
        this.pnum = n;
        this.dataLen = stsReader.getEntryCount() + 4;
        this.numUserEntries = stsReader.getEntryCount();
        float[] fArray = new float[this.dataLen];
        try {
            FileReader fileReader = new FileReader(stsReader.getLogName(this.pnum));
            AsciiIntegerReader asciiIntegerReader = new AsciiIntegerReader(new BufferedReader(fileReader));
            asciiIntegerReader.nextLine();
            asciiIntegerReader.nextInt();
            this.startTime = 0L;
            long l3 = 0L;
            try {
                while (l3 < this.endTime) {
                    asciiIntegerReader.nextLine();
                    int n2 = asciiIntegerReader.nextInt();
                    switch (n2) {
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: {
                            l3 = asciiIntegerReader.nextLong();
                            this.intervalCalc(fArray, n2, 0, l3);
                            break;
                        }
                        case 2: 
                        case 3: {
                            asciiIntegerReader.nextInt();
                            int n3 = asciiIntegerReader.nextInt();
                            l3 = asciiIntegerReader.nextLong();
                            this.intervalCalc(fArray, n2, n3, l3);
                            break;
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                asciiIntegerReader.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception while reading log file " + this.pnum);
        }
        float f = 0.0f;
        int n4 = 0;
        while (n4 < this.dataLen - 1) {
            fArray[n4] = 100.0f * fArray[n4] / (float)(this.endTime - this.beginTime);
            ++n4;
        }
        return fArray;
    }
}

