/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.Analysis;
import projections.gui.GraphWindow;
import projections.gui.IntTextField;
import projections.gui.TimeTextField;
import projections.gui.U;
import projections.gui.Util;

public class GraphIntervalDialog
extends Dialog
implements TextListener,
ActionListener {
    private GraphWindow graphWindow;
    private IntTextField numField;
    private TimeTextField sizeField;
    private long intervalSize;
    private long totalTime;
    private int numIntervals;
    private int oldnum;
    private Button bOK;
    private Button bCancel;

    public GraphIntervalDialog(GraphWindow graphWindow, int n) {
        super(graphWindow, "Set Interval Size", true);
        this.oldnum = n;
        this.numIntervals = n;
        this.graphWindow = graphWindow;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphIntervalDialog.this.setVisible(false);
                GraphIntervalDialog.this.dispose();
            }
        });
        this.totalTime = Analysis.getTotalTime();
        if (this.numIntervals < 0) {
            this.numIntervals = 50;
        }
        if ((long)this.numIntervals > this.totalTime) {
            this.numIntervals = (int)this.totalTime;
        }
        this.intervalSize = this.totalTime / (long)this.numIntervals;
        this.intervalSize = U.makeEven(this.intervalSize);
        this.numIntervals = (int)(this.totalTime / this.intervalSize + 1L);
        this.sizeField = new TimeTextField(this.intervalSize, 12);
        this.numField = new IntTextField(this.numIntervals, 12);
        this.sizeField.addTextListener(this);
        this.numField.addTextListener(this);
        this.sizeField.addActionListener(this);
        this.numField.addActionListener(this);
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        panel2.setLayout(new FlowLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        Util.gblAdd(panel, new Label("Total Time:", 2), gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, new Label(U.t(this.totalTime), 2), gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, new Label("Interval Size:", 2), gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(panel, this.sizeField, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(panel, new Label("# of Intervals:", 2), gridBagConstraints, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(panel, this.numField, gridBagConstraints, 1, 2, 1, 1, 1, 1);
        this.bOK = new Button("OK");
        this.bCancel = new Button("Cancel");
        panel2.add(this.bOK);
        panel2.add(this.bCancel);
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.add((Component)panel, "Center");
        this.add((Component)panel2, "South");
        this.pack();
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bOK) {
                this.graphWindow.setIntervalSize(this.intervalSize);
                this.graphWindow.setNumIntervals(this.numIntervals);
            }
            this.setVisible(false);
            this.dispose();
        } else {
            this.graphWindow.setIntervalSize(this.intervalSize);
            this.graphWindow.setNumIntervals(this.numIntervals);
            this.setVisible(false);
            this.dispose();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() instanceof TimeTextField) {
            TimeTextField timeTextField = (TimeTextField)textEvent.getSource();
            TimeTextField timeTextField2 = null;
            if (this.getFocusOwner() instanceof TimeTextField) {
                timeTextField2 = (TimeTextField)this.getFocusOwner();
            }
            if (timeTextField == this.sizeField && timeTextField2 == this.sizeField) {
                this.intervalSize = this.sizeField.getValue();
                if (this.intervalSize > this.totalTime) {
                    int n = this.sizeField.getCaretPosition();
                    this.intervalSize = this.totalTime;
                    this.sizeField.setText("" + this.intervalSize);
                    this.sizeField.setCaretPosition(n);
                }
                if (this.intervalSize != 0L) {
                    this.numIntervals = (int)Math.ceil((double)this.totalTime / (double)this.intervalSize);
                    this.numField.setText("" + this.numIntervals);
                }
            }
        } else if (textEvent.getSource() instanceof IntTextField) {
            IntTextField intTextField = (IntTextField)textEvent.getSource();
            IntTextField intTextField2 = null;
            if (this.getFocusOwner() instanceof IntTextField) {
                intTextField2 = (IntTextField)this.getFocusOwner();
            }
            if (intTextField == this.numField && intTextField2 == this.numField) {
                this.numIntervals = this.numField.getValue();
                if (this.numIntervals != 0) {
                    if ((long)this.numIntervals > this.totalTime) {
                        int n = this.numField.getCaretPosition();
                        this.numIntervals = (int)this.totalTime;
                        this.numField.setText("" + this.numIntervals);
                        this.numField.setCaretPosition(n);
                    }
                    this.intervalSize = this.totalTime / (long)this.numIntervals;
                    this.sizeField.setText("" + this.intervalSize);
                }
            }
        }
    }
}

