/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import projections.gui.GraphAttributesWindow;
import projections.gui.GraphData;
import projections.gui.Util;

public class GraphLegendPanel
extends Panel
implements ActionListener {
    private GridBagConstraints gbc;
    private Button bSelect;
    private LegendCanvas listPanel;
    private ScrollPane sp;
    private GraphData data = null;
    private GraphAttributesWindow attributesWindow;
    private PrintJob pjob;

    public GraphLegendPanel() {
        this.setBackground(Color.lightGray);
        this.sp = new ScrollPane();
        this.listPanel = new LegendCanvas(this.sp);
        this.bSelect = new Button("Select Display Items");
        this.sp.add(this.listPanel);
        this.sp.setBackground(Color.lightGray);
        this.bSelect.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        Util.gblAdd(this, new Label("LEGEND", 1), this.gbc, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(this, this.sp, this.gbc, 0, 1, 1, 1, 1, 10);
        Util.gblAdd(this, this.bSelect, this.gbc, 0, 2, 1, 1, 1, 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.data == null) {
            return;
        }
        Button button = (Button)actionEvent.getSource();
        if (button == this.bSelect) {
            if (this.attributesWindow == null) {
                this.attributesWindow = new GraphAttributesWindow(this.data);
            }
            this.attributesWindow.setVisible(true);
        }
    }

    public void closeAttributesWindow() {
        if (this.attributesWindow != null) {
            this.attributesWindow.setVisible(false);
            this.attributesWindow.dispose();
            this.attributesWindow = null;
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(80, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(140, 200);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        super.paint(graphics);
    }

    public void PrintLegend(Graphics graphics, PrintJob printJob) {
        this.pjob = printJob;
        this.listPanel.printAll(graphics);
    }

    public void setGraphData(GraphData graphData) {
        this.data = graphData;
    }

    public void UpdateLegend() {
        this.listPanel.repaint();
        this.sp.validate();
    }

    private class LegendCanvas
    extends Canvas {
        private FontMetrics fm;
        private int textheight;
        private ScrollPane sp;
        private int width;
        private int height;

        public LegendCanvas(ScrollPane scrollPane) {
            this.sp = scrollPane;
            this.setBackground(Color.black);
        }

        public void print(Graphics graphics) {
            int n;
            int n2;
            if (GraphLegendPanel.this.data == null) {
                return;
            }
            this.setBackground(Color.white);
            graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
            Dimension dimension = GraphLegendPanel.this.pjob.getPageDimension();
            if (dimension.width < dimension.height) {
                n2 = (int)(0.7 * (double)dimension.width / 8.5);
                n = (int)(0.7 * (double)dimension.height / 11.0);
            } else {
                n2 = (int)(0.7 * (double)dimension.width / 11.0);
                n = (int)(0.7 * (double)dimension.height / 8.5);
            }
            int n3 = dimension.width - 2 * n2;
            int n4 = dimension.height - 2 * n;
            graphics.translate(n2, n);
            if (this.fm == null) {
                this.fm = graphics.getFontMetrics(graphics.getFont());
                this.textheight = this.fm.getHeight() + 2;
            }
            this.height = this.textheight;
            graphics.setColor(Color.black);
            String string = "LEGEND";
            graphics.drawString(string, (n3 - this.fm.stringWidth(string)) / 2, this.height);
            this.height += this.textheight;
            this.width = 0;
            int n5 = 0;
            while (n5 < ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph.length) {
                if (((GraphLegendPanel)GraphLegendPanel.this).data.ymode == 11 && ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n5].ymode != 10 || ((GraphLegendPanel)GraphLegendPanel.this).data.ymode == 10 && ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n5].ymode != 11) {
                    graphics.setColor(((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n5].color);
                    string = ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n5].name;
                    if (!((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n5].type.equals("%") && !((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n5].type.equals("Msgs")) {
                        string = string + " " + ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n5].type;
                    }
                    if (((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n5].parent != null) {
                        string = string + "(" + ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n5].parent + ")";
                    }
                    graphics.drawString(string, this.width, this.height);
                    this.height += this.textheight;
                    if (this.height > n4) {
                        if (this.width == 0) {
                            this.height = 2 * this.textheight;
                            this.width = n3 / 2;
                        } else {
                            graphics.dispose();
                            graphics = null;
                            graphics = GraphLegendPanel.this.pjob.getGraphics();
                            graphics.translate(n2, n);
                            this.height = this.textheight;
                            this.width = 0;
                        }
                    }
                }
                ++n5;
            }
            this.setBackground(Color.black);
        }

        public void paint(Graphics graphics) {
            if (GraphLegendPanel.this.data == null) {
                return;
            }
            if (this.fm == null) {
                this.fm = graphics.getFontMetrics(graphics.getFont());
                this.textheight = this.fm.getHeight() + 2;
            }
            this.height = this.textheight;
            this.width = 0;
            int n = 0;
            while (n < ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph.length) {
                if (((GraphLegendPanel)GraphLegendPanel.this).data.ymode == 11 && ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n].ymode != 10 || ((GraphLegendPanel)GraphLegendPanel.this).data.ymode == 10 && ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n].ymode != 11) {
                    graphics.setColor(((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n].color);
                    String string = ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n].name;
                    if (!((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n].type.equals("%") && !((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n].type.equals("Msgs")) {
                        string = string + " " + ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n].type;
                    }
                    if (((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n].parent != null) {
                        string = string + "(" + ((GraphLegendPanel)GraphLegendPanel.this).data.onGraph[n].parent + ")";
                    }
                    graphics.drawString(string, 0, this.height);
                    this.height += this.textheight;
                    if (this.fm.stringWidth(string) > this.width) {
                        this.width = this.fm.stringWidth(string);
                    }
                }
                ++n;
            }
            if (this.sp.getViewportSize().width > this.width) {
                this.width = this.sp.getViewportSize().width;
            }
            if (this.sp.getViewportSize().height > this.height) {
                this.height = this.sp.getViewportSize().height;
            }
        }
    }
}

