/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import projections.gui.MainWindow;
import projections.gui.MyButton;

public class MainButtonPanel
extends Container
implements ActionListener {
    private MainWindow mainWindow;
    private static final int nButtons = 8;
    private MyButton[] buttonArray = new MyButton[8];
    private boolean inside = false;

    public MainButtonPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.setBackground(Color.lightGray);
        Font font = new Font("SansSerif", 0, 14);
        this.setFont(font);
        this.buttonArray[0] = new MyButton("Open File", Color.blue);
        this.buttonArray[1] = new MyButton("Graphs", Color.blue);
        this.buttonArray[2] = new MyButton("Timelines", Color.blue);
        this.buttonArray[3] = new MyButton("Usage Profile", Color.blue);
        this.buttonArray[4] = new MyButton("Animations", Color.blue);
        this.buttonArray[5] = new MyButton("View Log Files", Color.blue);
        this.buttonArray[6] = new MyButton("Histograms", Color.blue);
        this.buttonArray[7] = new MyButton("Overview", Color.blue);
        this.setLayout(new GridLayout(4, 2, 20, 20));
        int n = 0;
        while (n < 8) {
            this.add(this.buttonArray[n]);
            this.buttonArray[n].addActionListener(this);
            if (n > 0) {
                this.buttonArray[n].setEnabled(false);
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MyButton myButton = (MyButton)actionEvent.getSource();
        if (myButton == this.buttonArray[0]) {
            this.mainWindow.ShowOpenFileDialog();
        } else if (myButton == this.buttonArray[1]) {
            this.mainWindow.ShowGraphWindow();
        } else if (myButton == this.buttonArray[2]) {
            this.mainWindow.ShowTimelineWindow();
        } else if (myButton == this.buttonArray[3]) {
            this.mainWindow.ShowProfileWindow();
        } else if (myButton == this.buttonArray[4]) {
            this.mainWindow.ShowAnimationWindow();
        } else if (myButton == this.buttonArray[5]) {
            this.mainWindow.ShowLogFileViewerWindow();
        } else if (myButton == this.buttonArray[6]) {
            this.mainWindow.ShowHistogramWindow();
        } else if (myButton == this.buttonArray[7]) {
            this.mainWindow.ShowStlWindow();
        }
    }

    public void disableButtons() {
        int n = 1;
        while (n < 8) {
            this.buttonArray[n].setEnabled(false);
            ++n;
        }
    }

    public void enableButtons() {
        int n = 1;
        while (n < 8) {
            this.buttonArray[n].setEnabled(true);
            ++n;
        }
    }
}

