/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import projections.analysis.TimelineMessage;
import projections.gui.Analysis;
import projections.gui.TimelineObject;

public class TimelineMessageCanvas
extends Canvas {
    private String[] sTitles;
    private int[] width;
    private TimelineObject obj;
    private FontMetrics fm;
    private TimelineMessage[] msgs;
    private String[][] names;
    private int w;
    private int h;

    public TimelineMessageCanvas(TimelineObject timelineObject) {
        this.obj = timelineObject;
        this.w = 0;
        this.h = 0;
        this.msgs = timelineObject.getMessages();
        this.names = Analysis.getUserEntryNames();
        this.sTitles = new String[18];
        this.width = new int[18];
        int n = timelineObject.getEntry();
        this.sTitles[0] = "DETAILS FOR ENTRY: ";
        this.sTitles[1] = this.names[n][1] + " -- " + this.names[n][0];
        this.sTitles[2] = "BEGIN TIME: ";
        this.sTitles[3] = "" + timelineObject.getBeginTime();
        this.sTitles[4] = "     END TIME: ";
        this.sTitles[5] = "" + timelineObject.getEndTime();
        this.sTitles[6] = "     MSGS: ";
        this.sTitles[7] = "" + timelineObject.getNumMsgs();
        this.sTitles[8] = "CREATED BY: ";
        this.sTitles[9] = "Processor " + timelineObject.getPCreation();
        this.sTitles[10] = "      EXECUTED ON: ";
        this.sTitles[11] = "Processor " + timelineObject.getPCurrent();
        this.sTitles[12] = "MSG#";
        this.sTitles[13] = "TIME SENT";
        this.sTitles[14] = "TO ENTRY:";
        this.setBackground(Color.black);
        this.setForeground(Color.lightGray);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Graphics graphics;
        if (this.fm == null && (graphics = this.getGraphics()) != null) {
            int n;
            int n2;
            int n3;
            this.fm = graphics.getFontMetrics(graphics.getFont());
            this.h = (this.fm.getHeight() + 5) * (6 + this.obj.getNumMsgs());
            int n4 = 0;
            while (n4 <= 14) {
                this.width[n4] = this.fm.stringWidth(this.sTitles[n4]);
                ++n4;
            }
            this.width[15] = 0;
            this.width[16] = 0;
            this.width[17] = 0;
            int n5 = 0;
            while (n5 < this.obj.getNumMsgs()) {
                n3 = this.fm.stringWidth("" + n5);
                n2 = this.fm.stringWidth("" + this.msgs[n5].Time);
                n = this.fm.stringWidth(this.names[this.msgs[n5].Entry][0]);
                if (n3 > this.width[15]) {
                    this.width[15] = n3;
                }
                if (n2 > this.width[16]) {
                    this.width[16] = n2;
                }
                if (n > this.width[17]) {
                    this.width[17] = n;
                }
                ++n5;
            }
            this.w = this.width[0] + this.width[1];
            n3 = 0;
            n2 = 2;
            while (n2 <= 7) {
                n3 += this.width[n2];
                ++n2;
            }
            if (n3 > this.w) {
                this.w = n3;
            }
            n3 = 0;
            n = 8;
            while (n <= 11) {
                n3 += this.width[n];
                ++n;
            }
            if (n3 > this.w) {
                this.w = n3;
            }
            n3 = 20;
            int n6 = 12;
            while (n6 <= 14) {
                n3 += this.width[n6];
                ++n6;
            }
            if (n3 > this.w) {
                this.w = n3;
            }
            n3 = 20;
            int n7 = 15;
            while (n7 <= 17) {
                n3 += this.width[n7];
                ++n7;
            }
            if (n3 > this.w) {
                this.w = n3;
            }
            graphics.dispose();
        }
        return new Dimension(this.w, this.h);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        int n4 = (n2 - this.width[0] - this.width[1]) / 2;
        int n5 = (n2 - this.width[2] - this.width[3] - this.width[4] - this.width[5] - this.width[6] - this.width[7]) / 2;
        int n6 = (n2 - this.width[8] - this.width[9] - this.width[10] - this.width[11]) / 2;
        int n7 = (n2 - this.width[15] - this.width[16] - this.width[17]) / 4;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        int n8 = this.width[15] + (int)((double)n7 * 1.5);
        int n9 = this.width[16] + n7;
        int n10 = this.width[17] + (int)((double)n7 * 1.5);
        int n11 = n = this.fm.getHeight() + 5;
        int n12 = 0;
        graphics.setColor(Color.white);
        graphics.drawString(this.sTitles[1], (n2 - this.width[1]) / 2, n11);
        graphics.setColor(Color.red.darker());
        n12 = n5;
        graphics.drawString(this.sTitles[2], n12, n11 += n);
        graphics.drawString(this.sTitles[4], n12 += this.width[2] + this.width[3], n11);
        graphics.drawString(this.sTitles[6], n12 += this.width[4] + this.width[5], n11);
        graphics.setColor(Color.lightGray);
        n12 = n5 + this.width[2];
        graphics.drawString(this.sTitles[3], n12, n11);
        graphics.drawString(this.sTitles[5], n12 += this.width[3] + this.width[4], n11);
        graphics.drawString(this.sTitles[7], n12 += this.width[5] + this.width[6], n11);
        graphics.setColor(Color.green.darker());
        n12 = n6;
        graphics.drawString(this.sTitles[8], n12, n11 += n);
        graphics.drawString(this.sTitles[10], n12 += this.width[8] + this.width[9], n11);
        graphics.setColor(Color.lightGray);
        n12 = n6 + this.width[8];
        graphics.drawString(this.sTitles[9], n12, n11);
        graphics.drawString(this.sTitles[11], n12 += this.width[9] + this.width[10], n11);
        graphics.setColor(Color.white);
        graphics.drawString(this.sTitles[12], (n8 - this.width[12]) / 2, n11 += 2 * n);
        graphics.drawString(this.sTitles[13], (n9 - this.width[13]) / 2 + n8, n11);
        graphics.drawString(this.sTitles[14], (n10 - this.width[14]) / 2 + n8 + n9, n11);
        graphics.setColor(Color.lightGray);
        int n13 = 0;
        while (n13 < this.obj.getNumMsgs()) {
            String string = new String("" + n13);
            String string2 = new String("" + this.msgs[n13].Time);
            String string3 = new String(this.names[this.msgs[n13].Entry][0]);
            graphics.drawString(string, (n8 - this.fm.stringWidth(string)) / 2, n11 += n);
            graphics.drawString(string2, (n9 - this.fm.stringWidth(string2)) / 2 + n8, n11);
            graphics.drawString(string3, (n10 - this.fm.stringWidth(string3)) / 2 + n8 + n9, n11);
            ++n13;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

