/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import projections.analysis.PackTime;
import projections.analysis.TimelineMessage;
import projections.gui.Analysis;
import projections.gui.Bubble;
import projections.gui.TimelineData;
import projections.gui.TimelineMessageWindow;
import projections.gui.U;

public class TimelineObject
extends Component
implements MouseListener {
    private String[] bubbletext;
    private Bubble bubble;
    private TimelineMessageWindow msgwindow;
    private long beginTime;
    private long endTime;
    private int entry;
    private boolean inside = false;
    private int pCurrent;
    private int pCreation;
    private float usage;
    private float packusage;
    private long packtime;
    private TimelineData data;
    private Frame f;
    private TimelineMessage[] messages;
    private PackTime[] packs;

    public TimelineObject(TimelineData timelineData, long l, long l2, int n, TimelineMessage[] timelineMessageArray, PackTime[] packTimeArray, int n2, int n3) {
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.data = timelineData;
        this.beginTime = l;
        this.endTime = l2;
        this.entry = n;
        this.messages = timelineMessageArray;
        this.packs = packTimeArray;
        this.pCurrent = n2;
        this.pCreation = n3;
        this.f = timelineData.timelineWindow;
        this.setUsage();
        this.setPackUsage();
        if (n != -1) {
            this.bubbletext = new String[7];
            int n4 = Analysis.getUserEntryCount();
            if (n >= n4) {
                System.out.println("Fatal error: invalid entry " + n + "!");
                System.exit(1);
            }
            this.bubbletext[0] = Analysis.getUserEntryNames()[n][1] + "::" + Analysis.getUserEntryNames()[n][0];
            this.bubbletext[1] = "Begin Time: " + l;
            this.bubbletext[2] = "End Time: " + l2;
            this.bubbletext[3] = "Total Time: " + U.t(l2 - l);
            this.bubbletext[4] = "Packing: " + U.t(this.packtime);
            if (this.packtime > 0L) {
                this.bubbletext[4] = this.bubbletext[4] + " (" + 100.0f * (float)this.packtime / (float)(l2 - l + 1L) + "%)";
            }
            this.bubbletext[5] = "Msgs created: " + timelineMessageArray.length;
            this.bubbletext[6] = "Created by processor " + this.pCreation;
        } else {
            this.bubbletext = new String[4];
            this.bubbletext[0] = "IDLE TIME";
            this.bubbletext[1] = "Begin Time: " + l;
            this.bubbletext[2] = "End Time: " + l2;
            this.bubbletext[3] = "Total Time: " + U.t(l2 - l);
        }
        this.addMouseListener(this);
    }

    public void CloseMessageWindow() {
        this.msgwindow = null;
    }

    private void drawLeftArrow(Graphics graphics, Color color, int n) {
        int[] nArray = new int[]{5, 0, 5};
        int[] nArray2 = new int[]{0, n / 2, n - 1};
        graphics.setColor(color);
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(color.brighter());
        graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
        graphics.setColor(color.darker());
        graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
    }

    private void drawRightArrow(Graphics graphics, Color color, int n, int n2) {
        int[] nArray = new int[]{n2 - 6, n2, n2 - 6};
        int[] nArray2 = new int[]{0, n / 2, n - 1};
        graphics.setColor(color);
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(color.brighter());
        graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
        graphics.setColor(color.darker());
        graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getEntry() {
        return this.entry;
    }

    public TimelineMessage[] getMessages() {
        return this.messages;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getSize().width, this.getSize().height);
    }

    public float getNetUsage() {
        return this.usage - this.packusage;
    }

    public int getNumMsgs() {
        if (this.messages == null) {
            return 0;
        }
        return this.messages.length;
    }

    public float getPackUsage() {
        return this.packusage;
    }

    public int getPCreation() {
        return this.pCreation;
    }

    public int getPCurrent() {
        return this.pCurrent;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, this.getSize().height);
    }

    public float getUsage() {
        return this.usage;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.entry >= 0) {
            this.OpenMessageWindow();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.entry == -1 && !this.data.showIdle) {
            return;
        }
        if (!this.inside) {
            this.inside = true;
            TimelineObject timelineObject = this;
            Point point = timelineObject.getLocationOnScreen();
            Dimension dimension = this.getSize();
            if (this.bubble == null) {
                this.bubble = new Bubble(this, this.bubbletext);
            }
            this.bubble.setLocation(point.x + mouseEvent.getX(), point.y + dimension.height + 2);
            this.bubble.setVisible(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.inside) {
            if (this.bubble != null) {
                this.bubble.dispose();
                this.bubble = null;
            }
            this.inside = false;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void OpenMessageWindow() {
        if (this.msgwindow == null) {
            this.msgwindow = new TimelineMessageWindow(this);
        }
        this.msgwindow.setVisible(true);
    }

    public void paint(Graphics graphics) {
        long l;
        int n;
        if (this.entry == -1 && !this.data.showIdle) {
            return;
        }
        Color color = this.entry == -1 ? this.getForeground() : this.data.entryColor[this.entry];
        int n2 = this.getSize().width;
        int n3 = this.getSize().height - 5;
        int n4 = 0;
        int n5 = n2 - 1;
        long l2 = this.beginTime;
        long l3 = this.endTime;
        if (this.beginTime < this.data.beginTime) {
            this.drawLeftArrow(graphics, color, n3);
            n4 = 5;
            l2 = this.data.beginTime;
        }
        if (this.endTime > this.data.endTime) {
            this.drawRightArrow(graphics, color, n3, n2);
            n5 = n2 - 6;
            l3 = this.data.endTime;
        }
        graphics.setColor(color);
        int n6 = n5 - n4 + 1;
        graphics.fillRect(n4, 0, n6, n3);
        if (this.entry == -1) {
            graphics.setColor(this.getBackground());
            int n7 = 0;
            while (n7 < n2 + n3 - 2) {
                graphics.drawLine(n7, 0, n7 - n3, n3);
                graphics.drawLine(n7 + 1, 0, n7 - n3 + 1, n3);
                n7 += 4;
            }
        }
        if (n2 > 2) {
            graphics.setColor(color.brighter());
            graphics.drawLine(n4, 0, n5, 0);
            if (n4 == 0) {
                graphics.drawLine(0, 0, 0, n3 - 1);
            }
            graphics.setColor(color.darker());
            graphics.drawLine(n4, n3 - 1, n5, n3 - 1);
            if (n5 == n2 - 1) {
                graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 1);
            }
        }
        double d = (double)n6 / (double)(l3 - l2 + 1L);
        if (this.data.showMsgs && this.messages != null) {
            graphics.setColor(this.getForeground());
            n = 0;
            while (n < this.messages.length) {
                l = this.messages[n].Time;
                if (l >= this.data.beginTime && l <= this.data.endTime) {
                    int n8 = (int)((double)(l - l2) * d);
                    if (this.beginTime < this.data.beginTime) {
                        n8 += 5;
                    }
                    graphics.drawLine(n8, n3, n8, n3 + 5);
                }
                ++n;
            }
        }
        if (this.data.showPacks && this.packs != null) {
            graphics.setColor(Color.pink);
            n = 0;
            while (n < this.packs.length) {
                l = this.packs[n].BeginTime;
                long l4 = this.packs[n].EndTime;
                if (l4 >= this.data.beginTime && l <= this.data.endTime) {
                    int n9 = (int)((double)(l - l2) * d);
                    if (this.beginTime < this.data.beginTime) {
                        n9 += 5;
                    }
                    graphics.fillRect(n9, n3, (int)(l4 - l + 1L), 3);
                }
                ++n;
            }
        }
    }

    public void print(Graphics graphics, long l, long l2, double d, int n) {
        long l3;
        int n2;
        if (this.entry == -1 && !this.data.showIdle) {
            return;
        }
        Color color = this.entry == -1 ? Color.black : this.data.entryColor[this.entry];
        int n3 = (int)((double)(this.endTime - this.beginTime + 1L) * d / (double)n);
        if (n3 < 1) {
            n3 = 1;
        }
        if (this.beginTime < l) {
            n3 -= (int)((double)(l - this.beginTime) * d / (double)n) - 5;
        }
        if (this.endTime > l2) {
            n3 -= (int)((double)(this.endTime - l2) * d / (double)n) - 5;
        }
        int n4 = 20;
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(0, 0, n3, 25);
        int n5 = 0;
        int n6 = n3 - 1;
        long l4 = this.beginTime;
        long l5 = this.endTime;
        if (this.beginTime < l) {
            this.drawLeftArrow(graphics, color, n4);
            n5 = 5;
            l4 = l;
        }
        if (this.endTime > l2) {
            this.drawRightArrow(graphics, color, n4, n3);
            n6 = n3 - 6;
            l5 = l2;
        }
        graphics.setColor(color);
        int n7 = n6 - n5 + 1;
        graphics.fillRect(n5, 0, n7, n4);
        if (this.entry == -1) {
            graphics.setColor(Color.white);
            int n8 = 0;
            while (n8 < n3 + n4 - 2) {
                graphics.drawLine(n8, 0, n8 - n4, n4);
                graphics.drawLine(n8 + 1, 0, n8 - n4 + 1, n4);
                n8 += 4;
            }
        }
        if (n3 > 2) {
            graphics.setColor(color.brighter());
            graphics.drawLine(n5, 0, n6, 0);
            if (n5 == 0) {
                graphics.drawLine(0, 0, 0, n4 - 1);
            }
            graphics.setColor(color.darker());
            graphics.drawLine(n5, n4 - 1, n6, n4 - 1);
            if (n6 == n3 - 1) {
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            }
        }
        double d2 = (double)n7 / (double)(l5 - l4 + 1L);
        if (this.data.showMsgs && this.messages != null) {
            graphics.setColor(Color.black);
            n2 = 0;
            while (n2 < this.messages.length) {
                l3 = this.messages[n2].Time;
                if (l3 >= l && l3 <= l2) {
                    int n9 = (int)((double)(l3 - l4) * d2);
                    if (this.beginTime < l) {
                        n9 += 5;
                    }
                    graphics.drawLine(n9, n4, n9, n4 + 5);
                }
                ++n2;
            }
        }
        if (this.data.showPacks && this.packs != null) {
            graphics.setColor(Color.pink);
            n2 = 0;
            while (n2 < this.packs.length) {
                l3 = this.packs[n2].BeginTime;
                long l6 = this.packs[n2].EndTime;
                if (l6 >= l && l3 <= l2) {
                    int n10 = (int)((double)(l3 - l4) * d2);
                    if (this.beginTime < l) {
                        n10 += 5;
                    }
                    graphics.fillRect(n10, n4, (int)(l6 - l3 + 1L), 3);
                }
                ++n2;
            }
        }
        graphics.setClip(rectangle);
    }

    public void setBounds(int n) {
        long l;
        int n2;
        long l2 = this.endTime > this.data.endTime ? this.data.endTime - this.data.beginTime : this.endTime - this.data.beginTime;
        int n3 = this.data.offset + (int)((double)l2 * this.data.pixelIncrement / (double)this.data.timeIncrement);
        int n4 = n3 - (n2 = this.data.offset + (int)((double)(l = this.beginTime < this.data.beginTime ? 0L : this.beginTime - this.data.beginTime) * this.data.pixelIncrement / (double)this.data.timeIncrement)) + 1;
        if (n4 < 1) {
            n4 = 1;
        }
        if (this.endTime > this.data.endTime) {
            n4 += 5;
        }
        if (this.beginTime < this.data.beginTime) {
            n2 -= 5;
            n4 += 5;
        }
        super.setBounds(n2, this.data.tluh / 2 + n * this.data.tluh - this.data.barheight / 2, n4, this.data.barheight + 5);
    }

    public void setPackUsage() {
        this.packtime = 0L;
        if (this.packs != null) {
            int n = 0;
            while (n < this.packs.length) {
                this.packtime += this.packs[n].EndTime - this.packs[n].BeginTime + 1L;
                if (this.packs[n].BeginTime < this.data.beginTime) {
                    this.packtime -= this.data.beginTime - this.packs[n].BeginTime;
                }
                if (this.packs[n].EndTime > this.data.endTime) {
                    this.packtime -= this.packs[n].EndTime - this.data.endTime;
                }
                ++n;
            }
            this.packusage = this.packtime * 100L;
            this.packusage /= (float)(this.data.endTime - this.data.beginTime + 1L);
        }
    }

    public void setUsage() {
        this.usage = this.endTime - this.beginTime + 1L;
        if (this.beginTime < this.data.beginTime) {
            this.usage -= (float)(this.data.beginTime - this.beginTime);
        }
        if (this.endTime > this.data.endTime) {
            this.usage -= (float)(this.endTime - this.data.endTime);
        }
        this.usage *= 100.0f;
        this.usage /= (float)(this.data.endTime - this.data.beginTime + 1L);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

