/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ProgressDialog
extends Frame
implements ActionListener {
    private double curWork;
    private Bar bar;
    private Label label;
    private String oldLabel;
    private String doingWhat;
    private boolean windowShown;
    private boolean isCancelled;
    private boolean isDone;

    public ProgressDialog(String string) {
        this.doingWhat = string;
        this.curWork = 0.0;
        this.isCancelled = false;
        this.windowShown = false;
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(400L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!ProgressDialog.this.isDone) {
                    ProgressDialog.this.showWindow();
                }
            }
        }).start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.isCancelled = true;
        this.dispose();
    }

    public void done() {
        if (this.windowShown) {
            this.dispose();
        }
        this.isDone = true;
    }

    public boolean progress(double d, double d2, String string) {
        return this.progress(d / d2, string);
    }

    public boolean progress(double d, String string) {
        if (this.isCancelled) {
            return false;
        }
        if (d > 0.001 + this.curWork) {
            this.curWork = d;
            if (this.windowShown) {
                this.bar.repaint(40L);
            }
        }
        this.setLabel(string);
        return true;
    }

    public void setLabel(String string) {
        if (string != this.oldLabel) {
            this.oldLabel = string;
            if (this.label != null) {
                if (string != null) {
                    this.label.setText(this.doingWhat + " (" + string + ")");
                } else {
                    this.label.setText(this.doingWhat);
                }
            }
        }
    }

    private void showWindow() {
        this.windowShown = true;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressDialog.this.isCancelled = true;
                ProgressDialog.this.dispose();
            }
        });
        this.setTitle("Please Wait...");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.label = new Label("");
        String string = this.oldLabel;
        this.oldLabel = "";
        this.setLabel(string);
        this.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.bar = new Bar();
        this.add((Component)this.bar, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        Button button = new Button("Cancel");
        this.add((Component)button, gridBagConstraints);
        button.addActionListener(this);
        this.pack();
        this.setVisible(true);
    }

    private class Bar
    extends Canvas {
        private Bar() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            int n3 = (int)(ProgressDialog.this.curWork * (double)n);
            graphics.setColor(Color.darkGray);
            graphics.fillRect(0, 0, n3, n2);
            graphics.setColor(Color.lightGray);
            graphics.fillRect(n3, 0, n, n2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n, n2);
        }

        public Dimension getMinimumSize() {
            return new Dimension(300, 16);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }
}

