#include "pgm.h"

CkChareID mainhandle;

main::main(CkArgMsg * m)
{ 
  if(m->argc != 3)
  {
    CkPrintf("Usage: pgm <nsamples> <nchares>\n");
    CkAbort("");
  }

  ns = atoi(m->argv[1]);
  nc = atoi(m->argv[2]);
  delete m;
  CkGroupID gid = CkCreatePropMap();
  CProxy_piPart  arr = CProxy_piPart::ckNew(nc,gid);
  arr.compute(ns);
  responders = nc;
  count = 0;
  mainhandle = thishandle; // readonly initialization
  starttime = CkWallTimer();
}

void main::results(int cnt) 
{ 
  count += cnt;
  if (0 == --responders) {
    endtime = CkWallTimer();
    CkPrintf("At time %lf, pi=: %f \n", (endtime-starttime), 4.0*count/(ns*nc));
    CkExit();
  }
}

piPart::piPart()
{ 
  CrnSrand((int) this);
}

void
piPart::compute(int ns)
{
  int i;
  int count=0;
  for (i= 0; i<ns; i++) {
    double x = CrnDrand();
    double y = CrnDrand();
    if ((x*x + y*y) <= 1.0) count++;
  }
  CProxy_main mainproxy(mainhandle);
  mainproxy.results(count);
}

#include "pgm.def.h"
