#include "pgm.h"
#include "Pgm.def.h"

// EP granularity protocol
#define MIXGRAIN 0
#define FINE 1
#define MEDIUM 15
#define COARSE 20

// Message size protocol
#define SMALL 0
#define MIXSIZE 1
#define LARGE 800

main::main(CkArgMsg *m)
{ 
  CkGetChareID(&mainhandle);
  workerMessage *newMsg;
  int size[1];

  size[0] = SMALL;
  newMsg = new (size,0) workerMessage;
  newMsg->grainSize = FINE;
  newMsg->msgSize = SMALL;

  WorkerArray = CProxy_worker::ckNew(200);
  WorkerArray.receiveWork(newMsg);
  finis = 0;
  t0 = CmiWallTimer();
}

void main::workerExit()
{
  workerMessage *newMsg;
  int size[1];

  size[0] = SMALL;
  newMsg = new (size,0) workerMessage;

  finis++;
  if (finis == 200) {
    CkPrintf("Fine-grained, small messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = FINE;
    newMsg->msgSize = LARGE;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 400) {
    CkPrintf("Fine-grained, large messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = FINE;
    newMsg->msgSize = MIXSIZE;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 600) {
    CkPrintf("Fine-grained, mixed messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = MEDIUM;
    newMsg->msgSize = SMALL;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 800) {
    CkPrintf("Medium-grained, small messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = MEDIUM;
    newMsg->msgSize = LARGE;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 1000) {
    CkPrintf("Medium-grained, large messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = MEDIUM;
    newMsg->msgSize = MIXSIZE;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 1200) {
    CkPrintf("Medium-grained, mixed messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = COARSE;
    newMsg->msgSize = SMALL;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 1400) {
    CkPrintf("Coarse-grained, small messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = COARSE;
    newMsg->msgSize = LARGE;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 1600) {
    CkPrintf("Coarse-grained, large messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = COARSE;
    newMsg->msgSize = MIXSIZE;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 1800) {
    CkPrintf("Coarse-grained, mixed messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = MIXGRAIN;
    newMsg->msgSize = SMALL;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 2000) {
    CkPrintf("Mixed-grain, small messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = MIXGRAIN;
    newMsg->msgSize = LARGE;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 2200) {
    CkPrintf("Mixed-grain, large messages: %f\n", CmiWallTimer()-t0);
    newMsg->grainSize = MIXGRAIN;
    newMsg->msgSize = MIXSIZE;
    WorkerArray.receiveWork(newMsg);
    t0 = CmiWallTimer();    
  }
  else if (finis == 2400) {
    CkPrintf("Mixed-grain, mixed messages: %f\n", CmiWallTimer()-t0);
    CkExit();
  }
}

worker::worker()
{
  neighbor = (thisIndex + 1) % 200;
  count = cycle = 0;
}

void worker::receiveWork(workerMessage *m)
{
  CProxy_main *M;
  int fibber = m->grainSize, msgsizer = m->msgSize, size[1];
  workerMessage *newMsg;

  if (fibber == MIXGRAIN)
    fibber = thisIndex % 20;

  if (msgsizer == MIXSIZE)
    msgsizer = thisIndex * 4;

  size[0] = msgsizer;

  newMsg = new (size,0) workerMessage;

  newMsg->grainSize = m->grainSize;
  newMsg->msgSize = m->msgSize;

  CkFreeMsg(m);

  if (count == 0) {
    WorkerArray.receiveWork(newMsg);
    int foo = fib(fibber);
    count++;
  }
  else if ((count > 0) && (count < 200)) {
    int foo = fib(fibber);
    count++;
  }
  else {
    int foo = fib(fibber);
    M = new CProxy_main(mainhandle);
    M->workerExit();
    count = 0;
  }
}

int worker::fib(int n)
{
  if ((n==0) || (n==1))
    return 1;
  else
    return (fib(n-1) + fib(n-2));
}
