/*
 Parameter marshalling test program
  Orion Sky Lawlor, olawlor@acm.org, 4/6/2001
 
 Creates an array, and invokes a variety of
different marshalled entry methds.
*/
class flatStruct; class pupStruct;
#include "marshall.h"
#include <string.h>

class flatStruct {
	int x;
	char str[10];
public:
	void init(void) {
		x=1234;
		strcpy(str,"foo");
	}
	void check(void) {
		if (x!=1234 || 0!=strcmp(str,"foo"))
			CkAbort("flatStruct corrupted during marshalling\n");
	}
};

static int *makeArr(int tryNo,int n,int extra);
static void checkArr(int *arr,int tryNo,int n);

class parent : public PUP::able {
public:
	parent() {}
	parent(CkMigrateMessage *) {}
	virtual const char * getSignature() {return "parent";}
	PUPable_decl(parent);
};
class child : public parent {
public:
	child() {}
	child(CkMigrateMessage *m):parent(m) {}
	virtual const char * getSignature() {return "childe";}
	PUPable_decl(child);
};

class pupStruct {
	int len1;
	int *arr1;
	int len2; 
	int *arr2;
	parent *subclass;
public:
	pupStruct() {arr1=NULL;arr2=NULL;}
	~pupStruct() {delete[] arr1;delete[] arr2;}
	void init(parent *sub=new parent()) {
		static int lenCount=0;
		len1=lenCount*5+3;
		arr1=makeArr(17,len1,0);	
		len2=lenCount*3+7;
		arr2=makeArr(18,len2,0);
		subclass=sub;
	}
	parent *getSubclass(void) {return subclass;}
	void check(void) {
		checkArr(arr1,17,len1);
		checkArr(arr2,18,len2);
	}
	void pup(PUP::er &p) {
		p(len1);
		if (p.isUnpacking()) arr1=new int[len1];
		p(arr1,len1);
		p(len2);
		if (p.isUnpacking()) arr2=new int[len2];
		p(arr2,len2);
		p|subclass;
	}
//   This declaration is superceded by PUPmarshall, below
//	friend void operator|(PUP::er &p,pupStruct &f) {f.pup(p);}
};
PUPmarshall(pupStruct);


const static double basicData[10]={
	247,'v',
	-31000,65000,
	-2000000000.0,4000000000.0,
	-2000000001.0,4000000001.0,
	12.75,4123.0e23 
};


class randGen {
	unsigned int state;
public:
	randGen(unsigned int seed) {
		state=(unsigned int)(0xffffu&(seed%1280107u));
	}
	unsigned int next(void) {
		unsigned int val=(state<<16)+state;
		state=(unsigned int)(0xffffu&(val%1280107u));
		return (unsigned int)(0xffffu&val);
	}
};

static int *makeArr(int tryNo,int n,int extra)
{
	randGen g(tryNo+257*n);
	int *ret=new int[extra+n];
	for (int i=0;i<n;i++)
		ret[extra+i]=(int)g.next();
	return ret;
}
static void checkArr(int *arr,int tryNo,int n)
{
	randGen g(tryNo+257*n);
	for (int i=0;i<n;i++) {
		int expected=(int)g.next();
		if (arr[i]!=expected)
		{
			 CkError("Array marshalling error: try %d,"
					 " index %d of %d (got 0x%08x; should be 0x%08x) \n",
					tryNo,i,n,arr[i],expected);
			 CkAbort("Marshalling error");
		}
	}
}


static const int numElements=20;
static int marshallInitVal=0,eltInitVal=0;
static void marshallInit(void) 
{
	marshallInitVal=0x1234567;
}

void marshall_init(void)
{
  if (marshallInitVal!=0x1234567)
	CkAbort("initcall marshallInit never got called!\n");
  if (eltInitVal!=0x54321)
	CkAbort("initcall marshallElt::eltInit never got called!\n");
  CProxy_marshallElt ap=CProxy_marshallElt::ckNew(); 
  for (int i=0;i<numElements;i++) {
     ap[i].insert();
     ap[i].basic((unsigned char)basicData[0],(char)basicData[1],
				 (short)basicData[2],(unsigned short)basicData[3],
				 (int)basicData[4],(unsigned int)basicData[5],
				 (long)basicData[6],(unsigned long)basicData[7],
				 (float)basicData[8],(double)basicData[9]);
     flatStruct f; f.init();
     ap[i].flatRef(f);
     pupStruct p; 
     p.init();
     ap[i].pupped(p);
     pupStruct p2; 
     p2.init(new child);
     ap[i].puppedSubclass(p2);

     int n=0+13*i*i;
     int *arr=makeArr(1,n,0);
     ap[i].simpleArray(n,arr);
     delete[] arr;

     int m=1+i;
     int *arr2=makeArr(2,n*m,0);
     ap[i].fancyArray(arr2,n,m);
     delete[] arr2;

     int n1=2+7*i*i,n2=4+i;
     int *a1=makeArr(3,n1,1);
     int *a2=makeArr(4,n2+n,1);
     a1[0]=n2+1; a2[0]=n1+1;
     ap[i].crazyArray(a1,a2,n);
     delete[] a1;
     delete[] a2;     
  }
  ap.doneInserting();
  ap[0].done();
}


void marshall_moduleinit(void){}
PUPable_def(parent);
PUPable_def(child);

class marshallElt: public ArrayElement1D
{
    int count;
    void next(void) {
//CkPrintf("Marshall, pe %d> element %d at %d\n",CkMyPe(),thisIndex,count);
       if (++count == 7) 
       {//All tests passed for this element
          if (thisIndex==(::numElements-1)) finishTest();
          else  {
	    CProxy_marshallElt me(thisArrayID);
	    me[thisIndex+1].done();
	  }
       }
    }
public:
    marshallElt() { 
      count=0; 
//      CkPrintf("Created marshalling object %d\n",thisIndex);
    }
    marshallElt(CkMigrateMessage *) {}
    void done(void) {next();}

    void basic(unsigned char b,char c,
                short i,unsigned short j,
                int k,unsigned int l,
                long m,unsigned long n,
                float f,double d)
    {
       if (b!=basicData[0] || c!=basicData[1] ||
           i!=basicData[2] || j!=basicData[3] ||
           k!=basicData[4] || l!=basicData[5] ||
           m!=basicData[6] || n!=basicData[7] ||
           f!=basicData[8] || d!=basicData[9])
               CkAbort("Basic data marshalling test failed\n");
       next();
    }
    void flatRef(flatStruct &s) {s.check(); next();}
    void pupped(pupStruct &s) {s.check(); next();}
    void puppedSubclass(pupStruct &s) {
	s.check(); 
	if (0!=strcmp("childe",s.getSubclass()->getSignature()))
		CkAbort("Subclass not pup'ed properly");
	next();
    }
    void simpleArray(int n,int *arr) {checkArr(arr,1,n); next();}
    void fancyArray(int *arr2,int n,int m) {checkArr(arr2,2,n*m); next();}
    void crazyArray(int *arr1,int *arr2,int n)
    {
        checkArr(&arr1[1],3,arr2[0]-1);
        checkArr(&arr2[1],4,arr1[0]-1+n);
        next();
    }
    static void eltInit(void) {
	PUPable_reg(parent);
	PUPable_reg(child);
	eltInitVal=0x54321;
    }
};
#include "marshall.def.h"



