/*
** client.c -- client for the scheduler
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <signal.h>
#include <fcntl.h>
#include <pwd.h>
#include <sys/poll.h>

/*#define USE_UNIX*/

#ifdef USE_UNIX
#include<sys/un.h>
#define UNIX_PATH_MAX 108
#else
#include <netinet/in.h>
#endif

#ifndef strnlen
#define strnlen(s, n) strlen(s)
#endif

int PORT;   /* the port client will be connecting to */

#define MAX_COMMAND_NAME_SIZE 8
#define MAXDATASIZE 1024 /* max number of bytes we can get at once */
#define MAXARGSIZE 256

extern int errno;

void handler(int);

char RESERVEDWORDS[9][MAXARGSIZE] = {"mpirun", "charmrun", "conv-host", "-p4pg", "-np", "+p", "-machinefile", "++nodelist", ""};

void reserved_word_check(char *arg){
    char *rword;
    int count = 0;

    rword =  RESERVEDWORDS[0];
    while(strcmp(rword, "")){
        if(strcmp(arg, rword) == 0){
            printf("Reserved Words (%s) cannot used in the name or arguments of the job submitted\n", rword);
            exit(0);
        }
        rword =  RESERVEDWORDS[++count];
    }
}

int main(int argc, char **argv)
{
    int sockfd, numbytes;
    char buf[MAXDATASIZE];
    struct hostent *he;
    int maxlen = 0;
    struct passwd *cur_passwd;
    char *str;
    int status, argcount;
    struct pollfd pfd[2];

#ifdef USE_UNIX
    struct sockaddr_un their_addr; /* connector's address information */
#else
    struct sockaddr_in their_addr; /* connector's address information */
#endif

    /* SIGPIPE is received if the socket stream connection is broken.*/
    signal(SIGPIPE,handler);

    if (argc < 5) {
	printf("usage: client host_name port command_type command_name [<options>] [<args>]\n");
	printf("command_type: command/job\n");
	printf("command_type 'command'\nBasic Commands :\nListjobs, to list the jobs currently unfinished in the system, no arguments passed\n");
	printf("Kill, to kill a job running or queued, takes Job ID as argument\n\n");
	printf("command_type 'job'\nTakes <job name> <[options]> <[arguments]>\n");
	printf("Basic Options\n-stdout <filename>: The Std. Output file of the job\n");
	printf("-stderr <filename>: The Std. Error file of the job\n");
	printf("-stdin <filename>: The Std. Input file of the job\n");
	printf("-type [mpi/charm/mcharm/uni]: The type of the job\n");
	printf("-pwd <directory name>: Process Working Directory\n");
	printf("-minpe <value> : minimum number of processors used by the job\n");
	printf("-maxpe <value> : maximum number of processors used by the job\n");
	printf("#Processors allocated to the job varies between these bounds\n");
	printf("-time <hh:mm:ss> : time requested for the job\n");
        exit(1);
    }

    if ((he=gethostbyname(argv[1])) == NULL) {  /* get the host info */
        perror("gethostbyname");
        exit(1);
    }

    /* Prepare and send the command line to the scheduler.*/
    str = (char*)malloc(MAXDATASIZE);
    
    /*argv[0] = client, argv[1] = scheduler_host, argv[2] = port/filename
      argv[3] = (command/job), argv[4].... command/job info */
    
    /*Client server protocol, 
      <command/job>:<username>:command/job name and arguments*/

    cur_passwd = getpwuid(getuid());
    snprintf(buf, MAX_COMMAND_NAME_SIZE, "%s", argv[3]); 
    buf[MAX_COMMAND_NAME_SIZE] = '\0';
    snprintf(str, MAXDATASIZE, "%s:%s:%d ", buf, cur_passwd->pw_name, argc - 4);

    maxlen = MAXDATASIZE - strlen(str) - 24 - 2; /*24 for header, 2 for \n\0*/
    for(argcount = 4; argcount < argc; argcount++){

        if(strnlen(argv[argcount], MAXARGSIZE) >= MAXARGSIZE - 1){
            printf("Argument '%s' is too long, please try again\n", argv[argcount]);
            exit(0);
        }
        
        reserved_word_check(argv[argcount]);

	if(maxlen <= 2){
	    printf("Too Many Arguments, Try Again\n");
	    exit(0);
	}

	strncat(str, argv[argcount], maxlen);
	maxlen -= strlen(argv[argcount]);
	strncat(str, " ", maxlen);
	maxlen --;
    }
    
    str[strnlen(str, MAXDATASIZE - 2)] = '\n';
    str[strnlen(str, MAXDATASIZE - 2) + 1] = '\0';
    /*    printf("%s\n", str); */

    /* Establish Socket Connection and send command */

    setuid(geteuid());

    PORT = atoi(argv[2]);
#ifdef USE_UNIX
    if ((sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
	perror("socket");
	exit(1);
    }
    
    their_addr.sun_family = AF_UNIX;         /* host byte order */
    snprintf(their_addr.sun_path, UNIX_PATH_MAX, "/tmp/scheduler.%d", PORT);
    
    /*    printf("Connecting to %s\n", their_addr.sun_path);
	  printf("Connecting to Scheduler\n"); */

    if (connect(sockfd, (struct sockaddr *)&their_addr,
		strlen(their_addr.sun_path) + sizeof(short)) == -1) {
        perror("connect");
        exit(1);
    }
#else
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket");
        exit(1);
    }

    their_addr.sin_family = AF_INET;         /* host byte order */
    their_addr.sin_port = htons(PORT);     /* short, network byte order */
    their_addr.sin_addr = *((struct in_addr *)he->h_addr);
    bzero(&(their_addr.sin_zero), 8);        /* zero the rest of the struct */
    if (connect(sockfd, (struct sockaddr *)&their_addr,
		sizeof(struct sockaddr)) == -1) {
        perror("connect");
        exit(1);
    }
#endif

    write(sockfd, str, strnlen(str, MAXDATASIZE));
    errno = 0;

    /* Print to STDOUT everything that we get from the other side.*/
    while(1){
	pfd[0].fd = 0;
	pfd[0].events = POLLIN;
	pfd[0].revents = 0;
	pfd[1].fd = sockfd;
	pfd[1].events = POLLIN;
	pfd[1].revents = 0;

	poll(pfd, 2, 1000);

	if(pfd[0].revents){
	    numbytes = read(0, buf, MAXDATASIZE);
	    /*	    printf("Poll Succeded, reading %d bytes\n", numbytes); */
	    if (numbytes <= 0)
		break;
	    numbytes = write(sockfd, buf, numbytes);
	    /* printf("Writing %d bytes\n", numbytes); */
	}
	
	if(pfd[1].revents){
	    numbytes = read(sockfd, buf, MAXDATASIZE);
	    if (numbytes <= 0)
		break;
	    write(1, buf, numbytes);
	}
    }
    
    close(sockfd);
    
    return 0;
}

void  handler(int id){
  printf("SIGPIPE Received\n");
  exit(0);
}
