#include "common.h"
#include "dbinterface.h"

#define TIMEOUT 2

extern DbInterface dbi;
extern char *CONV_HOST;

#define DEFAULT_MIN_PROC 1
#define DEFAULT_MAX_PROC 8
#define DEFAULT_JOB_TYPE NCHARM
#define DEFAULT_ALLOCATED_TIME 3600    //3600 seconds.

Job::Job(int nproc){
    status = QUEUED;
    bitmap_changed = 0;

    ip = port = pid = type = 0; //priority = 0;
    client_soc_fd = dbid = 0;

    kill_node_jobs = 0;

    start_time = 0;

    argv = NULL;
    strcpy(argbuf, "");
    strcpy(userName, "");
    strcpy(name, "");
    strcpy(script_name, "");
    strcpy(nodes_file, "");

    strcpy(Stdout, "socket");
    strcpy(Stderr, "socket");
    strcpy(Stdin, "socket");
    
    min_proc = DEFAULT_MIN_PROC;
    max_proc = DEFAULT_MAX_PROC;
    type = DEFAULT_JOB_TYPE;

    allocated_time = DEFAULT_ALLOCATED_TIME;

    snprintf(working_directory, SMALL_BUF_SIZE, "%s", getenv("PWD"));

    num_system_proc = nproc;
    num_allocated_proc = 0;

    memset(bit_map, 0, num_system_proc);
    next = NULL;
}

Job::~Job(){
    
    if(!argv)
        return;
    
    printf("In destrcutor, before delete argv[1..\n");
    if(type == MCHARM){
        //        delete[] argv[1];
        delete[] argv[4];
    }/*
       else if(type == NCHARM)
       delete[] argv[1];
       else if(type == MPI)
       delete[] argv[2];
     */
    printf("In destrcutor, before delete argv\n");

    delete[] argv;
    printf("After destructor\n");
}

int Job::delete_all(char *system_bit_map){

    if(type == MCHARM){
        try{
            CcsFinalize(&svr);
        }
        catch(...){
            printf("Caught Exception %d in delete_all\n"); 
        }
    }

    for(int i=0; i < num_system_proc; i++)
	system_bit_map[i] |= bit_map[i];

    int nfreed = num_allocated_proc;
    num_allocated_proc = 0;

    status = FINISHED;
    dbi.update_status(dbid, FINISHED);

    int my_userid = geteuid();
    seteuid(0);

    char filepath[2 * SMALL_BUF_SIZE];
    sprintf(filepath, "%s/%s", working_directory, nodes_file);
    unlink(filepath);

    if(script_name[0] != '/')
	sprintf(filepath, "%s/%s", working_directory, script_name);
    else
	sprintf(filepath, "%s", script_name);
    unlink(filepath);
    seteuid(my_userid);

    return nfreed;
}

int Job::connect(){
    
    printf("In Connect %d %d\n", dbid, port);
    
    if(status >= FAILED_CONNECT){
	printf("Job removed or already connected\n");
	return -1;
    }

    skt_ip_t sktIP = {0};
    //    sktIP.tag = ip;

    try{
        CcsConnectIpWithTimeout(&svr, sktIP, port, NULL, TIMEOUT);
    }
    catch(...){
        printf("Caught Exception %d in connect\n"); 
        status = FAILED_CONNECT;
        return -1;
    }

    //Successfully connected, can do set bitmaps.
    status = CONNECTED;
    //    dbi.update_status(dbid, CONNECTED);
    return 0;
}

// Checks if the job is still alive. returns 1 if the job is alive 
// else it returns 0.
int Job::ping(int pid){
    int user_id = geteuid();
    setuid(0);
    if(kill(pid, 0) != -1)
	return 1;
    else
	return 0;
    seteuid(user_id);
}

int Job::set_bitmap(){

    printf("In setbit map\n");

    if(type != MCHARM)
	return -1;

    // BitMap has not changed.
    if(!bitmap_changed)
	return -1;

    // Not connected or could not connect, return.
    if(status != CONNECTED) //|| (status != BITMAPSET))
      return -1;

    printf("set bit map alloc = %d\n", num_allocated_proc);
    bitmap_changed = 0;
    
    //    status = BITMAPSET;

    dbi.update_bitmap(dbid, bit_map);

    int err = -1;
    try{
        err = CcsSendRequestWithTimeout(&svr, "set_bitmap",  0, num_system_proc, bit_map, TIMEOUT);
    }
    catch(...){
        printf("Caught Exception in set_bitmap\n");
    }
    return err;
}

int Job::parse_query(char *query){
    int i = 0;
    int count = 0;
    
    query[strlen(query)-1] = '\0';
   
    char tmplastsbuf[LARGE_BUF_SIZE]; 
    char *lasts = tmplastsbuf;
    count = atoi(strtok_r(query, " ", &lasts));
    char **temp_argv = new char*[count];
    for(i = 0; i < count; i++)
	temp_argv[i] = strtok_r(NULL, " ", &lasts);
    
    /*
    type = NCHARM;
    min_proc = 1;
    max_proc = num_system_proc;
    priority = 0;
    */

    int name_assigned = 0;
    int argc = 0;
    
    char tempbuf[LARGE_BUF_SIZE];
    strcpy(tempbuf, "");
    for(i = 0; i < count; i++){
	if(strncmp(temp_argv[i], "-minpe", 7) == 0){
	    if(i == count - 1){
                delete[] temp_argv;
		return -1;
            }
	    min_proc = atoi(temp_argv[i + 1]);
	    i++;
	}
	else if(strncmp(temp_argv[i], "-maxpe", 7) == 0){
	    if(i == count - 1){
                delete[] temp_argv;
		return -1;
            }
	    max_proc = atoi(temp_argv[i + 1]);
	    i++;
	}
	else if(strncmp(temp_argv[i], "-type", 6) == 0){
	    if(i == count - 1){
                delete[] temp_argv;
		return -1;
            }
	    if(strncasecmp(temp_argv[i + 1], "mcharm", 7) == 0)
		type = MCHARM;
	    else if(strncasecmp(temp_argv[i + 1], "mpi", 4) == 0)
		type = MPI;
	    else if(strncasecmp(temp_argv[i + 1], "charm", 6) == 0)
		type = NCHARM;
	    else if(strncasecmp(temp_argv[i + 1], "uni", 4) == 0)
		type = UNI;
	    else {
                delete[] temp_argv;
                return -1;
            }
	    i++;
	}
	/*
	else if(strncmp(temp_argv[i], "-priority", 10) == 0){
	    if(i == count - 1)
		return -1;
	    priority = atoi(temp_argv[i + 1]);
	    i++;
	}
	*/
	else if(strncmp(temp_argv[i], "-stdout", 7) == 0){
	    if(i == count - 1){
                delete[] temp_argv;
		return -1;
            }
	    snprintf(Stdout, SMALL_BUF_SIZE, "%s", temp_argv[i + 1]);
	    i++;
	}
	else if(strncmp(temp_argv[i], "-stdin", 6) == 0){
	    if(i == count - 1){
                delete[] temp_argv;
		return -1;
            }
	    snprintf(Stdin, SMALL_BUF_SIZE, "%s", temp_argv[i + 1]);
	    i++;
	}
	else if(strncmp(temp_argv[i], "-stderr", 7) == 0){
	    if(i == count - 1){
                delete[] temp_argv;
		return -1;
            }
	    snprintf(Stderr, SMALL_BUF_SIZE, "%s", temp_argv[i + 1]);
	    i++;
	}
	else if(strncmp(temp_argv[i], "-pwd", 5) == 0){
	    if(i == count - 1){
                delete[] temp_argv;
		return -1;
            }
	    snprintf(working_directory, SMALL_BUF_SIZE, "%s", temp_argv[i + 1]);
	    i++;
	}
	else if(strncmp(temp_argv[i], "-time", 6) == 0){
	    if(i == count - 1){
                delete[] temp_argv;
		return -1;
            }

	    int val1 = 0, val2 = 0, val3 = 0;

	    int valcount = sscanf(temp_argv[i + 1], "%d:%d:%d", &val1, &val2, &val3);

	    if(valcount == 1)
		allocated_time = val1;
	    else if(valcount == 2)
		allocated_time = val1 * 60 + val2;
	    else if(valcount == 3)
		allocated_time = val1 * 3600 + val2 * 60 + val3;
	    
	    //printf("Allocated Time %d, valcount = %d\n", allocated_time, valcount); 

	    i++;
	}
	else if(!name_assigned){
	    strncpy(name, temp_argv[i], SMALL_BUF_SIZE);
	    name[SMALL_BUF_SIZE-1] = '\0';
	    name_assigned = 1;
	}
	else{
	    strncat(tempbuf, temp_argv[i], LARGE_BUF_SIZE);
	    strcat(tempbuf, " ");                 // New seperator later.
	    argc ++;
	}
    }
    
    if(!name_assigned){
        delete[] temp_argv;
	return -1;
    }

    if(type == UNI)
	min_proc = max_proc = 1;

    if(min_proc > max_proc)
	max_proc = min_proc;

    snprintf(argbuf, LARGE_BUF_SIZE, "%s", tempbuf);
    delete[] temp_argv;

    printf("After parse query\n");

    return 0;
}

void Job::re_init(){
    sprintf(nodes_file, ".nodelist.%d", dbid);
    sprintf(script_name, ".script.%d", dbid);
}

void Job::init_arg(){    

    sprintf(nodes_file, ".nodelist.%d", dbid);
    sprintf(script_name, ".script.%d", dbid);
    int argcount = 0;	
    //    char *num_proc_string = new char[VERY_SMALL_BUF_SIZE];
    // We prepare the job's command-line arguments here.
    if(type == MCHARM){
	argv = new char*[8 + 1];
	argv[0] = CONV_HOST;
	snprintf(num_proc_string, VERY_SMALL_BUF_SIZE, "+p%d", num_system_proc);
	argv[1] = num_proc_string;
	argv[2] = "++server";
	argv[3] = "++server-port";
	argv[4] = new char[VERY_SMALL_BUF_SIZE];
	snprintf(argv[4], VERY_SMALL_BUF_SIZE, "%d", port);
	argv[5] = "++nodelist";
	argv[6] = nodes_file;
	argcount += 7;
    }
    else if(type == MPI){
	argv = new char*[7 + 1];
	argv[0] = MPIRUN;
	argv[1] = "-np";	
	snprintf(num_proc_string, VERY_SMALL_BUF_SIZE, "%d", num_allocated_proc);
	argv[2] = num_proc_string;
	argv[3] = "-machinefile";
	argv[4] = nodes_file;
	argv[5] = "-nolocal";
	argcount += 6;
        
        kill_node_jobs = 1;
    }
    else if(type == NCHARM){
	argv = new char*[5 + 1];
	argv[0] = CONV_HOST;
	snprintf(num_proc_string, VERY_SMALL_BUF_SIZE, "+p%d", num_allocated_proc);
	argv[1] = num_proc_string;
	argv[2] = "++nodelist";
	argv[3] = nodes_file;
	argcount += 4;
    }
    else if(type == UNI){
	argv = new char*[3 + 1];
	argv[0] = RSH;
        //	delete[] num_proc_string;
	argv[1] = NULL;
	argcount += 2;
    }
    argv[argcount++] = script_name; //script name;

    //    printf("init_arg %s, %s, %s, %s, %s, %s\n", argv[9], argv[10], argv[11], argv[12], argv[13], argv[14]);
    
    argv[argcount] = NULL;
    printf("Out of init arg\n");
}

void Job::add_proc(int p){
    
    num_allocated_proc++;
    if(p < num_system_proc)
	bit_map[p] = 1;
    bitmap_changed = 1;
}

int Job::delete_proc(){
    num_allocated_proc --;
    int i;
    bitmap_changed = 1;
    for(i=0; i < num_system_proc; i++)
	if(bit_map[i] == 1)
	    break;

    if(bit_map[i] == 1){
	bit_map[i] = 0;
	return i;
    }
    else return -1;
}

void Job::Kill(){
    int user_id = geteuid();
    seteuid(0);
    printf("Killing %d\n", pid);
    kill(pid, 9);
    seteuid(user_id);
}

void Job::started(){

    status = RUNNING;
    dbi.update_pid(dbid, pid);
    dbi.update_bitmap(dbid, bit_map);
    dbi.update_status(dbid, RUNNING);
    start_time = (int)getCurrentTime();
    dbi.update_startTime(dbid, start_time);
}

void* Job::operator new (size_t s)
{
    static int new_count = 0;

    new_count ++;
    printf("new_count = %d\n", new_count);

    //  std::cout << " [ new      Bytes  = " << s << " ]" << "\n";
    return malloc(s);            // The global new 
}

void Job::operator delete(void *p, size_t s)
{
    static int del_count = 0;
    
    del_count ++;
    printf("del_count = %d\n", del_count);
    
    //  std::cout << " [ delete   Bytes = " << s << " ]" << "\n";
    free(p);                               // The global delete 
}

