/*****************************************************************************
 * $Source: /cvsroot/charm/src/Common/conv-ccs/ccs-client.h,v $
 * $Author: skumar2 $
 * $Date: 2001/09/27 22:52:44 $
 * $Revision: 1.5 $
 *****************************************************************************/

/**
 * Converse Client-Server Module: Client Side
 */

#ifndef __CCS_CLIENT_H_
#define __CCS_CLIENT_H_

#include "sockRoutines.h"
#include "ccs-auth.h"

typedef struct CcsServer {
  /*CCS Server description:*/
  char hostAddr[128];
  skt_ip_t hostIP;
  unsigned int hostPort;

  /*Authentication*/
  int isAuth;
  int level;/*Security level to ask for*/
  CcsSec_secretKey key;
  int clientID,clientSalt;
  int replySalt;
  CCS_RAND_state rand;

  /*Parallel machine:*/
  int numNodes;
  int numPes;
  int *numProcs; /*# of processors for each node*/

  /*Current State:*/
  SOCKET replyFd;/*Socket for replies*/
} CcsServer;

/*All routines return -1 on failure*/
int CcsConnect(CcsServer *svr, char *host, int port,CcsSec_secretKey *key);
int CcsConnectWithTimeout(CcsServer *svr, char *host, int port,CcsSec_secretKey *key, int timeout);

int CcsConnectIp(CcsServer *svr,skt_ip_t ip, int port,CcsSec_secretKey *key);
int CcsConnectIpWithTimeout(CcsServer *svr,skt_ip_t ip, int port,CcsSec_secretKey *key, int timeout);

int CcsSendRequest(CcsServer *svr, char *hdlrID, int pe, 
		    unsigned int size, const char *msg);
int CcsSendRequestWithTimeout(CcsServer *svr, char *hdlrID, int pe, 
		    unsigned int size, const char *msg, int timeout);

int CcsRecvResponse(CcsServer *svr, 
		    unsigned int maxsize, char *recvBuffer, int timeout);
int CcsRecvResponseMsg(CcsServer *svr, 
		    unsigned int *retSize,char **newBuf, int timeout);
int CcsNumNodes(CcsServer *svr);
int CcsNumPes(CcsServer *svr);
int CcsNodeFirst(CcsServer *svr, int node);
int CcsNodeSize(CcsServer *svr,int node);
int CcsProbe(CcsServer *svr);
void CcsFinalize(CcsServer *svr);

#endif
