#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "charm++.h"

#include "receiver.h"


receiver::receiver(ArrayElementCreateMessage *m) : ArrayElement(m)
{
  msgTbl = CmmNew();
  reqTbl = CmmNew();

  callback = NULL;
  counter = 100;

  finishConstruction();
}

receiver::receiver(ArrayElementMigrateMessage *m) : ArrayElement(m)
{
  msgTbl = CmmNew();
  reqTbl = CmmNew();

  callback = NULL;
  counter = 100;

  finishMigration();
}

receiver::~receiver()
{
  CmmFree(msgTbl);
  CmmFree(reqTbl);
}

#define MIN(a,b) (a)<(b)?(a):(b)

void receiver::sendTo(int tag, char *pointer, int size, int from, int refno)
{
  int tags[3], ret_tags[3];

  tags[0] = tag; tags[1] = from; tags[2] = refno;
  tblEntry *req = (tblEntry *)CmmGet(reqTbl, 3, tags, ret_tags);

  if (req) {
    //  irecv called before; copy buffer
    memcpy(req->buf, pointer, MIN(size, req->size)); 
    delete req;
  }
  else {
    // msg come before irecv called
    tags[0] = tag; tags[1] = from; tags[2] = refno;
    req = new tblEntry;
    req->buf = new char[size];
    memcpy(req->buf, pointer, size); 
    req->size = size;
    CmmPut(msgTbl, 3, tags, req);
  }

  recvAlready();
}

void receiver::generic(receiverMsg *msg)
{
  sendTo(msg->tag, msg->buf, msg->size, msg->sendFrom, msg->refno);
  delete msg;
}

void receiver::irecv(int tag, char *pointer, int size, int senderTag, int refno)
{
  int tags[3], ret_tags[3];

  tags[0] = tag; tags[1] = senderTag; tags[2] = refno;
  tblEntry *req = (tblEntry *)CmmGet(msgTbl, 3, tags, ret_tags);

  if (req) {
    // send called before; copy buffer into
    memcpy(pointer, req->buf, MIN(size, req->size));
    delete [] req->buf;
    delete req;
  }
  else {
    // recv called before send
    tags[0] = tag; tags[1] = senderTag; tags[2] = refno;
    req = new tblEntry;
    req->buf = pointer;
    req->size = size;
    CmmPut(reqTbl, 3, tags, req);
  }

}

void receiver::iwaitAll(recvCallBack f, void *data, int ref)
{
  if (callback != NULL) 
  {
    CkPrintf("iwaitAll wrong!\n");
    CkExit();
  }
  callback = f;
  this->cb_data = data;
  counter = ref;

  recvAlready();
}

void receiver::recvAlready()
{
   if (callback == NULL) return;

   int tags[3], ret_tags[3];
   tags[0] = CmmWildCard; tags[1] = CmmWildCard; tags[2] = counter;
   tblEntry *req1 = (tblEntry *)CmmProbe(reqTbl, 3, tags, ret_tags);
   tblEntry *req2 = (tblEntry *)CmmProbe(msgTbl, 3, tags, ret_tags);
   if (req1 == NULL && req2 == NULL) 
   {
    recvCallBack tmpfn = callback;
    callback = NULL;
    tmpfn(cb_data);
   }
}

#include "receiver.def.h"


