/*****************************************************************************
 * $Source: /expand1/cvsroot/charm/src/Common/ck-ldb/ObjGraph.h,v $
 * $Author: milind $
 * $Date: 2000/03/02 11:36:19 $
 * $Revision: 1.5 $
 *****************************************************************************/

#ifndef _OBJGRAPH_H_
#define _OBJGRAPH_H_

#include "lbdb.h"
#include "CentralLB.h"

class ObjGraph {
public:
  class Edge {
    friend class ObjGraph;
  public:
    int edge_index;
    int proc;
    int index;
    int from_node;
    int to_node;
    Edge* next_from() { return nxt_out; };
    Edge* next_to() { return nxt_in; };
  private:
    Edge* nxt_out;
    Edge* nxt_in;
  };

  class Node {
    friend class ObjGraph;
  public:
    int node_index;
    int proc;
    int index;
    int n_out;
    int n_in;
    Edge* edges_from() { return outEdge; };
    Edge* edges_to() { return inEdge; };

  private:
    Edge* outEdge;
    Edge* inEdge;
    Node* nxt_hash;
  };

  ObjGraph(int count, CentralLB::LDStats* stats);
  ~ObjGraph();

  int NodeCount() { return n_objs; };
  int EdgeCount() { return n_edges; };
  Node* Start() { return nodelist; };
  Node GraphNode(int i) { return nodelist[i]; };

  double LoadOf(int i) {
    const Node n = GraphNode(i);
    const int pe = n.proc;
    const int index = n.index;
    return stats[pe].objData[index].wallTime;
  };

  double EdgeWeight(Edge* e);

private:
  enum { hash_max = 256 };

  int calc_hashval(LDOMid, LDObjid);
  Node* find_node(LDOMid, LDObjid);

  Edge* edgelist;
  Node* node_table[hash_max];

  int n_objs;
  int n_edges;
  Node* nodelist;
  CentralLB::LDStats* stats;
};

#endif
