#include "pgm.h"

CkChareID mainhandle;

void 
UserArray::doAllreduce(void)
{
  int i;
  double in=thisIndex, out;
  for(i=0;i<NITER;i++) {
    ckTempoAllReduce(TEMPO_SUM, &in, &out, 1, TEMPO_DOUBLE);
  }
  CProxy_main pm(mainhandle);
  pm.Finish();
}

main::main(CkArgMsg *m)
{
  int i;
  int nblocks = CmiNumPes();
  for(i=1;i<m->argc;i++) {
    if(strncmp(m->argv[i], "+vp", 3) == 0) {
      if (strlen(m->argv[i]) > 2) {
        sscanf(m->argv[i], "+vp%d", &nblocks);
      } else {
        if (m->argv[i+1]) {
          sscanf(m->argv[i+1], "%d", &nblocks);
        }
      }
      break;
    }
  }
  CProxy_UserArray  pua(nblocks);
  pua.doAllreduce(); // broadcast to all array elements
  mainhandle = thishandle;
  starttime = CkTimer();
}

void 
main::Finish(void)
{
  endtime = CkTimer();
  CkPrintf("Time per Allreduce = %lf microseconds\n", 
           (endtime-starttime)*1.e6/NITER);
  CkExit();
}

#include "pgm.def.h"
