#include "job.h"
#include "string.h"

Job::Job(){
}

Job::Job(job_stats jstat){
    job_id = jstat.jid;
    client_soc_fd = jstat.fd;
    num_system_proc = jstat.num_system_proc;

    num_allocated_proc = 0;
    bit_map = new char[num_system_proc];
    memset(bit_map, 0, num_system_proc);
    printf("before get arg\n");
    get_arg(jstat.cmd);
}

int Job::destroy(char *system_bit_map){
    //    printf("closing client\n");
    // char log_filename[100];
    // sprintf(log_filename,"log.%d",job_id);
    // unlink(log_filename); 

    close(client_soc_fd);
    //    delete cmd;
    
    if(type == CHARM)
      CcsFinalize(&svr);
    
    for(int i=0; i < num_system_proc; i++)
	system_bit_map[i] |= bit_map[i];

    return num_allocated_proc;
}

void Job::connect(){

    //  printf("%u,%u\n",ip,port);
    CcsConnect(&svr, ip, port);  ////  CHECK ***********
    // printf("IP=%u,port=%u\n",svr.myIP,svr.myPort);
}

void Job::ping(){}

void Job::set_bitmap(){
    if(type != CHARM)
	return;
    //    printf("IP=%u,port=%u\n",svr.myIP,svr.myPort);
    //    int i = CcsNodeNum(&svr, "thrift");
    //printSvr(&svr);
    printf("set bit map alloc = %d\n", num_allocated_proc);
    CcsSendRequest(&svr, "set_bitmap",  0, num_system_proc, bit_map);
    //    printf("sent request to process\n");
}

void Job::get_arg(char *cmd){
    int count = 0;
    char *new_cmd = cmd;
    char **temp_argv;
    
    cmd[strlen(cmd)-1] = 0;
    printf("%s\n", cmd);

    sscanf(cmd, "%d", &count);
    temp_argv = new (char *)[count];
    argv = new (char *)[count + 6];

    for(int i = 0; i < count; i++){
	new_cmd = strchr(cmd,' ');
	*new_cmd = 0;
	cmd = new_cmd +1;
	temp_argv[i] = cmd;
    }

    int argcount = 5;
    type = CHARM;
    min_proc = 1;
    max_proc = num_system_proc;
    priority = 0;
    stdout = "/dev/null";
    stdin = "/dev/null";

    for(int i = 0; i < count; i++){
	if(strcmp(temp_argv[i], "-minpe") == 0){
	    min_proc = atoi(temp_argv[i + 1]);
	    i++;
	}
	else if(strcmp(temp_argv[i], "-maxpe") == 0){
	    max_proc = atoi(temp_argv[i + 1]);
	    i++;
	}
	else if(strcmp(temp_argv[i], "-type") == 0){
	    if(strcmp(temp_argv[i + 1], "charm") == 0)
		type = CHARM;
	    else if(strcmp(temp_argv[i + 1], "mpi") == 0){
		type = MPI;
		printf("here\n");
	    }
	    i++;
	}
	else if(strcmp(temp_argv[i], "-priority") == 0){
	    priority = atoi(temp_argv[i + 1]);
	    i++;
	}
	else if(strcmp(temp_argv[i], "-stdout") == 0){
	    stdout = temp_argv[i + 1];
	    i++;
	}
	else if(strcmp(temp_argv[i], "-stdin") == 0){
	    stdin = temp_argv[i + 1];
	    i++;
	}
	else{
	    printf("%s\n", temp_argv[i]);
	    argv[argcount ++] = temp_argv[i];
	}
    }
    
    char *num_proc_string = new char[10];

    if(type == CHARM){
	argv[0] = "conv-host";
	sprintf(num_proc_string, "+p%d", num_system_proc);
	argv[1] = num_proc_string;
	argv[2] = "++server";
	argv[3] = "++server-port";
	argv[4] = NULL;
    }
    else if(type == MPI){
	printf("here\n");
	argv[0] = "mpirun";
	sprintf(num_proc_string, "-np");
	argv[1] = num_proc_string;
	argv[2] = NULL;
	argv[3] = "-machinefile";
	argv[4] = NULL;
    }

    argv[argcount] = NULL;
}

void Job::add_proc(int p){
    
    num_allocated_proc++;
    if(p < num_system_proc)
	bit_map[p] = 1;
}

int Job::delete_proc(){
    num_allocated_proc --;
    int i;
    for(i=0; i<num_system_proc; i++)
	if(bit_map[i] == 1)
	    break;

    if(bit_map[i] == 1){
	bit_map[i] = 0;
	return i;
    }
    else return -1;
}
    
