#include "scheduler.h"
#include <signal.h>

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>

extern char **environ;

void get_net_stats(FILE *fp, unsigned int & ip ,unsigned int & port){
    char *cmd = new char[MAX_SIZE]; 
    char ip_str[MAX_SIZE],port_str[MAX_SIZE];

    fgets(cmd,MAX_SIZE,fp);
    
    printf("after fgets\n");
    while(!strstr(cmd,"ccs"))
	fgets(cmd,MAX_SIZE,fp);

    fgets(cmd,MAX_SIZE,fp);
    
    while(!strstr(cmd,"ccs"))
        fgets(cmd,100,fp);

    cmd = strchr(cmd,'=') + 2;    
    sscanf(cmd,"%[0-9]",ip_str);
    
    cmd = strchr(cmd,'=') + 2;
    sscanf(cmd,"%[0-9]",port_str);
    
    ip = (unsigned int) strtoul(ip_str,(char**)NULL,10);
    port = (unsigned int) strtoul(port_str,(char**)NULL,10);
    fclose(fp);
    
    return;
}

void Scheduler::dump_stats(){
    
    FILE * fp = fopen("STATS", "w+");
    
    fprintf(fp, "%d %d\n", nproc, njobs);

    Job *jptr = jlist;
    while(jptr != NULL){
	fprintf(fp, "%s %d\n", jptr->argv[5], jptr->num_allocated_proc);
	printf("######## in loop %s %d \n", jptr->argv[5], jptr->num_allocated_proc);
	jptr = jptr->next;
    }
    fclose(fp);
}

int Scheduler::update_bitmap(Job *j){
    Job *jptr = jlist;
    int min_used_proc = 0, n_migrate_proc = 0;
    int avail = 0, max_avail = 0;
    int n_migrate_jobs = 0;

    if(jptr == NULL){
	for(int i=0; i<j->max_proc; i++){
	    j->add_proc(i);
	    free_proc_vector[i] = 0;
	    num_free_proc --;
	}
	return 0;
    }
    
    while(jptr != NULL){
	if(jptr->type == CHARM){
	    min_used_proc += jptr->min_proc;
	    n_migrate_proc += jptr->num_allocated_proc;
	    n_migrate_jobs ++;
	}
	else if(jptr->type == MPI)
	    min_used_proc += jptr->num_allocated_proc;
	jptr = jptr->next;
    }

    if(min_used_proc == nproc){
	return -1;
    }

    max_avail = nproc - min_used_proc + num_free_proc;
    avail = (n_migrate_proc + num_free_proc) / (n_migrate_jobs + 1);

    if(avail > max_avail)
	avail = max_avail;
    	
    if(max_avail < j->min_proc)
	return -1;
    
    jptr = jlist;
    int temp_proc = 0;
    int num_allocated = 0;

    if(num_free_proc > 0){
	while((num_allocated < j->max_proc) && (num_free_proc > 0))
	    for(int i=0; i<nproc; i++)
		if(free_proc_vector[i]){
		    j->add_proc(i);
		    free_proc_vector[i] = 0;
		    num_free_proc --;
		    num_allocated++;
		}
	if(num_allocated == j->max_proc)
	    return 0;
    }

    while(num_allocated < j->min_proc){
	jptr = jlist;
	while((jptr != NULL) && (num_allocated < j->min_proc))
	    if((jptr->type == CHARM) && 
	       (jptr->num_allocated_proc > jptr->min_proc)){
		temp_proc = jptr->delete_proc();
		j->add_proc(temp_proc);
		num_allocated++;
		jptr = jptr->next;
	    }	    
    }

    int alloc_flag = 0;
    while(num_allocated < avail){
	jptr = jlist;
	while((jptr != NULL) && (num_allocated < avail))
	    if((jptr->type == CHARM) && 
	       (jptr->num_allocated_proc > jptr->min_proc)
	       &&(jptr->num_allocated_proc > j->num_allocated_proc - 1)){
		temp_proc = jptr->delete_proc();
		j->add_proc(temp_proc);
		num_allocated++;
		alloc_flag = 1;
		jptr = jptr->next;
	    }	    
	if(!alloc_flag)
	    break;
	alloc_flag = 0;
    }

    return 0;
}

/*
void Scheduler::get_bitmap(char *bit_map, int jpos, int new_task_proc){

    int i;
    double start,end,width;

    width = ((double)(nproc))/(njobs);
    start = (jpos - 1)*width;
    end = jpos * width;
    
    for(i =0; i < nproc; i++){
	if((i >= (int) start) && (i < (int)end))
	    bit_map[i] = 1;
	else
	    bit_map[i] = 0;
    }
}
*/

void default_options(){
    printf("scheduler <port> <nproc> [<nodelist file>] \n");
}

void Scheduler::load_nodelist(char * node_listfile){
    FILE *fp;
    char *address = new char[100];
    int num_nodes = 0;

    fp = fopen(node_listfile, "r");
    
    node_list = new char*[nproc];
    
    fscanf(fp, "%s", address);
    while(num_nodes < nproc){
	if(strcmp(address, "host") == 0){
	    if(fscanf(fp, "%s", address) == 1){
		node_list[num_nodes++] = address;
		address = new char[100];
	    }
	    else break;
	}
	if(fscanf(fp, "%s", address) != 1)
	    break;
    }
    if(num_nodes == 0){
	printf("incorrect scheduler_nodelist file\n");
	exit(1);
    }
    if(num_nodes < nproc){
	printf("all processors not present in nodelist file\n");
	exit(1);
    }
}

int flag;
void  handler(int id);
int scheduler_port;

void main(int argc, char ** argv){
    
    if(argc < 3){
	default_options();
	exit(1);
    }
    
    flag = 0;
    signal(SIGCLD,handler);

    scheduler_port = atoi(argv[1]);
    Scheduler sch(scheduler_port, atoi(argv[2]));
    
    if(argc >= 4)
	sch.load_nodelist(argv[2]);
    else
	sch.load_nodelist("scheduler_nodelist");
    
    sch.start_scheduler();   
}

Scheduler::Scheduler(int port, int nproc){
    
    int sockfd; 
    
    job_exited = 0;
    n_wait_jobs = 0;
    jlist = NULL;
    waitq = NULL;
    this->port = port;
    max_jid = 0;
    njobs = 0;
    this->nproc = nproc;
    struct sockaddr_in my_addr;   
    
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket");
        exit(1);
    }
    
    int des_flag = fcntl(sockfd, F_GETFL);
    fcntl(sockfd, F_SETFL,O_NONBLOCK|des_flag);
    this->sch_socfd = sockfd;
    
    my_addr.sin_family = AF_INET;  
    my_addr.sin_port = htons(port); 
    my_addr.sin_addr.s_addr = INADDR_ANY;
    bzero(&(my_addr.sin_zero), 8);       

    free_proc_vector = new char[nproc];
    memset(free_proc_vector, 1, nproc);
    num_free_proc = nproc;

    if (bind(sockfd, (struct sockaddr *)&my_addr, 
	     sizeof(struct sockaddr)) == -1) {
        perror("bind");
        exit(1);
    }
}

void Scheduler::start_scheduler(){
    int client_fd;    
    socklen_t sin_size;
    struct sockaddr_in their_addr;
    char cmd[MAX_SIZE];
    FILE * client_fp;

    if (listen(sch_socfd, MAX_CONN) == -1) {
	perror("listen");
	exit(1);
    }
    
    while(1){ //Accept loop.

        if(flag){
	    remove_jobs();
	    dump_stats();
	}

	sin_size = sizeof(struct sockaddr_in);
	if ((client_fd = accept(sch_socfd, (struct sockaddr *)
				&their_addr, &sin_size))== -1) {
	  //	    perror("accept");
	    continue;
	}
	
	client_fp = fdopen(client_fd,"r");

	//	recv(client_fd,cmd,1000,0);
	
	fgets(cmd,MAX_SIZE,client_fp);
	
	max_jid++;
	njobs++;
	job_stats jstat;
	jstat.jid = max_jid;
	jstat.fd = client_fd;
	jstat.cmd = cmd;
	jstat.num_system_proc = nproc; 
	Job j(jstat);
	
	if(schedule_job(j) == -1){
	    Job * new_job = new Job;
	    *new_job = j;
	    new_job->next = waitq;
	    waitq = new_job;
	    n_wait_jobs ++;
	}
	else start_job(jlist);

	printf(" after schedule \n");
	dump_stats();
    }
}

void Scheduler::create_nodes_file(char *name, char *bitmap){
    int i;

    FILE * fp = fopen(name, "w+");
    
    for(i=0; i < nproc; i++)
	if(bitmap[i])
	    fprintf(fp, "%s\n", node_list[i]);
    
    fclose(fp);
    return;
}

int Scheduler::schedule_job(Job j){
    Job * jptr = this->jlist;
    
    printf("in schedule job %d\n",jlist);
    	
    if(update_bitmap(&j) == -1)
	return -1;

    if(j.type == MPI){
	printf("here\n");
	char *num_proc_string = new char[10];	
	sprintf(num_proc_string, "%d", j.num_allocated_proc);
	j.argv[2] = num_proc_string;
	char *nodesfile = new char[20];
	sprintf(nodesfile, "nodelist.%d", j.job_id);  
	create_nodes_file(nodesfile, j.bit_map);
	j.argv[4] = nodesfile;
    }
    else if(j.type == CHARM){
	j.argv[4] = new char[10];
	sprintf(j.argv[4], "%d", scheduler_port + j.job_id + 1);
    }

    int jcount=0;
    while(jptr != NULL){
	if(jptr->type == CHARM){
	    jptr->set_bitmap();
	}
	jptr = jptr->next;
    }

    Job * new_job = new Job;
    *new_job = j;
    new_job->next = jlist;
    jlist = new_job;
    printf("out of schedule job %d\n", jlist);
}

void Scheduler::start_job(Job *j){
    int childpid;

    printf(" in start \n");

    if(!(childpid = fork())){
	close(0);
	close(1);
	close(2);

	dup(j->client_soc_fd);
	dup(j->client_soc_fd);
	dup(j->client_soc_fd);

	if(j->type == CHARM)
	  execv("conv-host", j->argv);
	else if(j->type == MPI)
	  execv("/usr/local/bin/mpirun", j->argv);
    }
    j->pid = childpid;
    
    if(j->type == CHARM){
      j->port = scheduler_port + j->job_id + 1;
      j->ip =0;
      j->connect();
      j->set_bitmap();
    }

    return;
}

void Scheduler::remove_jobs(){
    Job *jptr,*prev = NULL;
    
    printf("In remove Job\n");
    jptr = jlist;
    int status;
    
    flag = 0;

    while((jlist != NULL) && 
	  (jlist->pid == waitpid(jlist->pid,&status,WNOHANG))){
	jlist = jlist->next;
	num_free_proc += jptr->destroy(free_proc_vector);
	jptr = jlist;
	njobs --;
    }

    prev = jptr;

    while(jptr != NULL){
	if(jptr->pid == waitpid(jptr->pid,&status,WNOHANG)){
	    prev->next = jptr->next;
	    num_free_proc += jptr->destroy(free_proc_vector);
	    njobs --;
	}
	prev = jptr;
	jptr = jptr->next;
    }
    
    jptr = waitq;
    prev = NULL;
    while(jptr != NULL){
	if(schedule_job(*jptr) != -1){
	    if(prev)
		prev->next = jptr->next;
	    else
		waitq = waitq->next;
	    n_wait_jobs --;
	    start_job(jlist);
	    delete jptr;
	    if(prev)
	      jptr = prev->next;
	    else
	      jptr = waitq;
	}
	else{
	    prev = jptr;
	    jptr = jptr->next;
	}
    }

    if(jlist == NULL)
	return;

    if(num_free_proc == 0)
	return;

    jptr = jlist;
    while((jptr->type != CHARM) && (jptr != NULL) && 
	  (jptr->num_allocated_proc >= jptr->max_proc))
	jptr = jptr->next;
    
    if(jptr == NULL)
	return;
    
    int min_pes = jptr->num_allocated_proc;
    Job * min_proc_job = jptr;
    Job * startptr = jptr;

    for(int i=0; i<nproc; i++){
	if(!free_proc_vector[i])
	    continue;
	while(jptr != NULL){
	    if((jptr->type == CHARM) && (jptr->num_allocated_proc < min_pes)
	       && (jptr->num_allocated_proc < jptr->max_proc)){
		min_proc_job = jptr;
		min_pes = jptr->num_allocated_proc;
	    }
	    jptr = jptr->next;
	}
	
	if(min_proc_job == NULL)
	    break;
	printf("adding processor %d to %d\n", i, min_proc_job->job_id);
	min_proc_job->add_proc(i);
	free_proc_vector[i] = 0;
	num_free_proc --;
	min_pes = nproc + 1;
	min_proc_job = NULL;
	jptr = startptr;
    }
    
    jptr = jlist;
    while(jptr != NULL){
	if(jptr->type == CHARM)
	    jptr->set_bitmap();
	jptr = jptr->next;
    }
}

void  handler(int id){
    //    printf("in handler \n");
    flag = 1;
}


