#ifndef _DECL_CentralLB_H_
#define _DECL_CentralLB_H_
#include "charm++.h"
#include "LBDatabase.decl.h"

/* DECLS: readonly CkGroupID loadbalancer;
 */

/* DECLS: message CLBStatsMsg;
 */
class CLBStatsMsg;
class CMessage_CLBStatsMsg:public CkArrayMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    void *operator new(size_t s, int *sz, int p);
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message CLBMigrateMsg;
 */
class CLBMigrateMsg;
class CMessage_CLBMigrateMsg:public CkArrayMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    void *operator new(size_t s, int *sz, int p);
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: group CentralLB{
void CentralLB(void);
void ProcessAtSync(void);
void ReceiveStats(CLBStatsMsg*);
void ResumeClients(void);
void ReceiveMigration(CLBMigrateMsg*);
};
 */
class CentralLB;
class CProxy_CentralLB:  public virtual _CK_GID{
  public:
    static int __idx;
    static void __register(const char *s, size_t size);
    CProxy_CentralLB(CkGroupID _gid) { _ck_gid = _gid; _setChare(0); }
    CProxy_CentralLB(CkChareID __cid) { ckSetChareId(__cid); }
    CkChareID ckGetChareId(void) { return _ck_cid; }
    void ckSetChareId(CkChareID __cid){_CHECK_CID(__cid,__idx);_ck_cid=__cid;_setChare(1);}
    CkGroupID ckGetGroupId(void) { return _ck_gid; }
    void ckSetGroupId(CkGroupID _gid){_ck_gid=_gid;_setChare(0);}
    CentralLB* ckLocalBranch(void) {
      return (CentralLB *) CkLocalBranch(_ck_gid);
    }
    static CentralLB* ckLocalBranch(CkGroupID gID) {
      return (CentralLB *) CkLocalBranch(gID);
    }
/* DECLS: void CentralLB(void);
 */
    static CkGroupID ckNew(void);
    static CkGroupID ckNewSync(void);
    CProxy_CentralLB(int retEP, CkChareID *cid);
    CProxy_CentralLB(void);
    static int  __idx_CentralLB_void;
    static int  ckIdx_CentralLB(void) { return __idx_CentralLB_void; }
    static void _call_CentralLB_void(void* msg, CentralLB* obj);

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void){
      void *msg = CkAllocSysMsg();
      if(_isChare())
        CkSendMsg(__idx_ProcessAtSync_void, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_ProcessAtSync_void, msg, _ck_gid);
    }
    void ProcessAtSync(int onPE) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranch(__idx_ProcessAtSync_void, msg, onPE, _ck_gid);
    }
    void ProcessAtSync(int npes, int *pes) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(__idx_ProcessAtSync_void, msg, npes, pes, _ck_gid);
    }
    static int  __idx_ProcessAtSync_void;
    static int  ckIdx_ProcessAtSync(void) { return __idx_ProcessAtSync_void; }
    static void _call_ProcessAtSync_void(void* msg, CentralLB* obj);

/* DECLS: void ReceiveStats(CLBStatsMsg*);
 */
    void ReceiveStats(CLBStatsMsg*msg){
      if(_isChare())
        CkSendMsg(__idx_ReceiveStats_CLBStatsMsg, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_ReceiveStats_CLBStatsMsg, msg, _ck_gid);
    }
    void ReceiveStats(CLBStatsMsg*msg, int onPE) {
      CkSendMsgBranch(__idx_ReceiveStats_CLBStatsMsg, msg, onPE, _ck_gid);
    }
    void ReceiveStats(CLBStatsMsg*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_ReceiveStats_CLBStatsMsg, msg, npes, pes, _ck_gid);
    }
    static int  __idx_ReceiveStats_CLBStatsMsg;
    static int  ckIdx_ReceiveStats(CLBStatsMsg*msg) { return __idx_ReceiveStats_CLBStatsMsg; }
    static void _call_ReceiveStats_CLBStatsMsg(void* msg, CentralLB* obj);

/* DECLS: void ResumeClients(void);
 */
    void ResumeClients(void){
      void *msg = CkAllocSysMsg();
      if(_isChare())
        CkSendMsg(__idx_ResumeClients_void, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_ResumeClients_void, msg, _ck_gid);
    }
    void ResumeClients(int onPE) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranch(__idx_ResumeClients_void, msg, onPE, _ck_gid);
    }
    void ResumeClients(int npes, int *pes) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(__idx_ResumeClients_void, msg, npes, pes, _ck_gid);
    }
    static int  __idx_ResumeClients_void;
    static int  ckIdx_ResumeClients(void) { return __idx_ResumeClients_void; }
    static void _call_ResumeClients_void(void* msg, CentralLB* obj);

/* DECLS: void ReceiveMigration(CLBMigrateMsg*);
 */
    void ReceiveMigration(CLBMigrateMsg*msg){
      if(_isChare())
        CkSendMsg(__idx_ReceiveMigration_CLBMigrateMsg, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_ReceiveMigration_CLBMigrateMsg, msg, _ck_gid);
    }
    void ReceiveMigration(CLBMigrateMsg*msg, int onPE) {
      CkSendMsgBranch(__idx_ReceiveMigration_CLBMigrateMsg, msg, onPE, _ck_gid);
    }
    void ReceiveMigration(CLBMigrateMsg*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_ReceiveMigration_CLBMigrateMsg, msg, npes, pes, _ck_gid);
    }
    static int  __idx_ReceiveMigration_CLBMigrateMsg;
    static int  ckIdx_ReceiveMigration(CLBMigrateMsg*msg) { return __idx_ReceiveMigration_CLBMigrateMsg; }
    static void _call_ReceiveMigration_CLBMigrateMsg(void* msg, CentralLB* obj);
};

extern void _registerCentralLB(void);
#endif
