#ifndef _DECL_CkArray_H_
#define _DECL_CkArray_H_
#include "charm++.h"
#include "CkReduction.decl.h"

/* DECLS: readonly CkGroupID _RRMapID;
 */

/* DECLS: message CkArrayMessage;
 */
class CkArrayMessage;
class CMessage_CkArrayMessage:public CkArrayMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message CkArrayElementCreateMsg;
 */
class CkArrayElementCreateMsg;
class CMessage_CkArrayElementCreateMsg:public CkArrayMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message CkArrayElementMigrateMessage;
 */
class CkArrayElementMigrateMessage;
class CMessage_CkArrayElementMigrateMessage:public CkArrayMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    void *operator new(size_t s, int *sz, int p);
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message CkArrayCreateMsg;
 */
class CkArrayCreateMsg;
class CMessage_CkArrayCreateMsg:public CkArrayMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message CkArrayRemoveMsg;
 */
class CkArrayRemoveMsg;
class CMessage_CkArrayRemoveMsg:public CkArrayMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message CkArrayUpdateMsg;
 */
class CkArrayUpdateMsg;
class CMessage_CkArrayUpdateMsg:public CkArrayMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: group CkArray: CkReductionMgr{
CkArray(CkArrayCreateMsg*);
void InsertElement(CkArrayMessage*);
void DoneInserting(void);
void ElementDying(CkArrayRemoveMsg*);
void Send(CkArrayMessage*);
void RecvForElement(CkArrayMessage*);
void RecvMigratedElement(CkArrayElementMigrateMessage*);
void UpdateLocation(CkArrayUpdateMsg*);
void DummyAtSync(void);
void SpringCleaning(void);
void SendBroadcast(CkArrayMessage*);
void RecvBroadcast(CkArrayMessage*);
};
 */
class CkArray;
class CProxy_CkArray:  public virtual _CK_GID, public CProxy_CkReductionMgr{
  public:
    static int __idx;
    static void __register(const char *s, size_t size);
    CProxy_CkArray(CkGroupID _gid) :CProxy_CkReductionMgr(_gid){ _ck_gid = _gid; _setChare(0); }
    CProxy_CkArray(CkChareID __cid) :CProxy_CkReductionMgr(__cid){ ckSetChareId(__cid); }
    CkChareID ckGetChareId(void) { return _ck_cid; }
    void ckSetChareId(CkChareID __cid){_CHECK_CID(__cid,__idx);_ck_cid=__cid;_setChare(1);}
    CkGroupID ckGetGroupId(void) { return _ck_gid; }
    void ckSetGroupId(CkGroupID _gid){_ck_gid=_gid;_setChare(0);}
    CkArray* ckLocalBranch(void) {
      return (CkArray *) CkLocalBranch(_ck_gid);
    }
    static CkArray* ckLocalBranch(CkGroupID gID) {
      return (CkArray *) CkLocalBranch(gID);
    }
/* DECLS: CkArray(CkArrayCreateMsg*);
 */
    static CkGroupID ckNew(CkArrayCreateMsg*msg);
    static CkGroupID ckNewSync(CkArrayCreateMsg*msg);
    CProxy_CkArray(CkArrayCreateMsg*msg, int retEP, CkChareID *cid);
    CProxy_CkArray(CkArrayCreateMsg*msg);
    static int  __idx_CkArray_CkArrayCreateMsg;
    static int  ckIdx_CkArray(CkArrayCreateMsg*msg) { return __idx_CkArray_CkArrayCreateMsg; }
    static void _call_CkArray_CkArrayCreateMsg(void* msg, CkArray* obj);

/* DECLS: void InsertElement(CkArrayMessage*);
 */
    void InsertElement(CkArrayMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_InsertElement_CkArrayMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_InsertElement_CkArrayMessage, msg, _ck_gid);
    }
    void InsertElement(CkArrayMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_InsertElement_CkArrayMessage, msg, onPE, _ck_gid);
    }
    void InsertElement(CkArrayMessage*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_InsertElement_CkArrayMessage, msg, npes, pes, _ck_gid);
    }
    static int  __idx_InsertElement_CkArrayMessage;
    static int  ckIdx_InsertElement(CkArrayMessage*msg) { return __idx_InsertElement_CkArrayMessage; }
    static void _call_InsertElement_CkArrayMessage(void* msg, CkArray* obj);

/* DECLS: void DoneInserting(void);
 */
    void DoneInserting(void){
      void *msg = CkAllocSysMsg();
      if(_isChare())
        CkSendMsg(__idx_DoneInserting_void, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_DoneInserting_void, msg, _ck_gid);
    }
    void DoneInserting(int onPE) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranch(__idx_DoneInserting_void, msg, onPE, _ck_gid);
    }
    void DoneInserting(int npes, int *pes) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(__idx_DoneInserting_void, msg, npes, pes, _ck_gid);
    }
    static int  __idx_DoneInserting_void;
    static int  ckIdx_DoneInserting(void) { return __idx_DoneInserting_void; }
    static void _call_DoneInserting_void(void* msg, CkArray* obj);

/* DECLS: void ElementDying(CkArrayRemoveMsg*);
 */
    void ElementDying(CkArrayRemoveMsg*msg){
      if(_isChare())
        CkSendMsg(__idx_ElementDying_CkArrayRemoveMsg, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_ElementDying_CkArrayRemoveMsg, msg, _ck_gid);
    }
    void ElementDying(CkArrayRemoveMsg*msg, int onPE) {
      CkSendMsgBranch(__idx_ElementDying_CkArrayRemoveMsg, msg, onPE, _ck_gid);
    }
    void ElementDying(CkArrayRemoveMsg*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_ElementDying_CkArrayRemoveMsg, msg, npes, pes, _ck_gid);
    }
    static int  __idx_ElementDying_CkArrayRemoveMsg;
    static int  ckIdx_ElementDying(CkArrayRemoveMsg*msg) { return __idx_ElementDying_CkArrayRemoveMsg; }
    static void _call_ElementDying_CkArrayRemoveMsg(void* msg, CkArray* obj);

/* DECLS: void Send(CkArrayMessage*);
 */
    void Send(CkArrayMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_Send_CkArrayMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_Send_CkArrayMessage, msg, _ck_gid);
    }
    void Send(CkArrayMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_Send_CkArrayMessage, msg, onPE, _ck_gid);
    }
    void Send(CkArrayMessage*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_Send_CkArrayMessage, msg, npes, pes, _ck_gid);
    }
    static int  __idx_Send_CkArrayMessage;
    static int  ckIdx_Send(CkArrayMessage*msg) { return __idx_Send_CkArrayMessage; }
    static void _call_Send_CkArrayMessage(void* msg, CkArray* obj);

/* DECLS: void RecvForElement(CkArrayMessage*);
 */
    void RecvForElement(CkArrayMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_RecvForElement_CkArrayMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_RecvForElement_CkArrayMessage, msg, _ck_gid);
    }
    void RecvForElement(CkArrayMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_RecvForElement_CkArrayMessage, msg, onPE, _ck_gid);
    }
    void RecvForElement(CkArrayMessage*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_RecvForElement_CkArrayMessage, msg, npes, pes, _ck_gid);
    }
    static int  __idx_RecvForElement_CkArrayMessage;
    static int  ckIdx_RecvForElement(CkArrayMessage*msg) { return __idx_RecvForElement_CkArrayMessage; }
    static void _call_RecvForElement_CkArrayMessage(void* msg, CkArray* obj);

/* DECLS: void RecvMigratedElement(CkArrayElementMigrateMessage*);
 */
    void RecvMigratedElement(CkArrayElementMigrateMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_RecvMigratedElement_CkArrayElementMigrateMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_RecvMigratedElement_CkArrayElementMigrateMessage, msg, _ck_gid);
    }
    void RecvMigratedElement(CkArrayElementMigrateMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_RecvMigratedElement_CkArrayElementMigrateMessage, msg, onPE, _ck_gid);
    }
    void RecvMigratedElement(CkArrayElementMigrateMessage*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_RecvMigratedElement_CkArrayElementMigrateMessage, msg, npes, pes, _ck_gid);
    }
    static int  __idx_RecvMigratedElement_CkArrayElementMigrateMessage;
    static int  ckIdx_RecvMigratedElement(CkArrayElementMigrateMessage*msg) { return __idx_RecvMigratedElement_CkArrayElementMigrateMessage; }
    static void _call_RecvMigratedElement_CkArrayElementMigrateMessage(void* msg, CkArray* obj);

/* DECLS: void UpdateLocation(CkArrayUpdateMsg*);
 */
    void UpdateLocation(CkArrayUpdateMsg*msg){
      if(_isChare())
        CkSendMsg(__idx_UpdateLocation_CkArrayUpdateMsg, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_UpdateLocation_CkArrayUpdateMsg, msg, _ck_gid);
    }
    void UpdateLocation(CkArrayUpdateMsg*msg, int onPE) {
      CkSendMsgBranch(__idx_UpdateLocation_CkArrayUpdateMsg, msg, onPE, _ck_gid);
    }
    void UpdateLocation(CkArrayUpdateMsg*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_UpdateLocation_CkArrayUpdateMsg, msg, npes, pes, _ck_gid);
    }
    static int  __idx_UpdateLocation_CkArrayUpdateMsg;
    static int  ckIdx_UpdateLocation(CkArrayUpdateMsg*msg) { return __idx_UpdateLocation_CkArrayUpdateMsg; }
    static void _call_UpdateLocation_CkArrayUpdateMsg(void* msg, CkArray* obj);

/* DECLS: void DummyAtSync(void);
 */
    void DummyAtSync(void){
      void *msg = CkAllocSysMsg();
      if(_isChare())
        CkSendMsg(__idx_DummyAtSync_void, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_DummyAtSync_void, msg, _ck_gid);
    }
    void DummyAtSync(int onPE) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranch(__idx_DummyAtSync_void, msg, onPE, _ck_gid);
    }
    void DummyAtSync(int npes, int *pes) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(__idx_DummyAtSync_void, msg, npes, pes, _ck_gid);
    }
    static int  __idx_DummyAtSync_void;
    static int  ckIdx_DummyAtSync(void) { return __idx_DummyAtSync_void; }
    static void _call_DummyAtSync_void(void* msg, CkArray* obj);

/* DECLS: void SpringCleaning(void);
 */
    void SpringCleaning(void){
      void *msg = CkAllocSysMsg();
      if(_isChare())
        CkSendMsg(__idx_SpringCleaning_void, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_SpringCleaning_void, msg, _ck_gid);
    }
    void SpringCleaning(int onPE) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranch(__idx_SpringCleaning_void, msg, onPE, _ck_gid);
    }
    void SpringCleaning(int npes, int *pes) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(__idx_SpringCleaning_void, msg, npes, pes, _ck_gid);
    }
    static int  __idx_SpringCleaning_void;
    static int  ckIdx_SpringCleaning(void) { return __idx_SpringCleaning_void; }
    static void _call_SpringCleaning_void(void* msg, CkArray* obj);

/* DECLS: void SendBroadcast(CkArrayMessage*);
 */
    void SendBroadcast(CkArrayMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_SendBroadcast_CkArrayMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_SendBroadcast_CkArrayMessage, msg, _ck_gid);
    }
    void SendBroadcast(CkArrayMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_SendBroadcast_CkArrayMessage, msg, onPE, _ck_gid);
    }
    void SendBroadcast(CkArrayMessage*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_SendBroadcast_CkArrayMessage, msg, npes, pes, _ck_gid);
    }
    static int  __idx_SendBroadcast_CkArrayMessage;
    static int  ckIdx_SendBroadcast(CkArrayMessage*msg) { return __idx_SendBroadcast_CkArrayMessage; }
    static void _call_SendBroadcast_CkArrayMessage(void* msg, CkArray* obj);

/* DECLS: void RecvBroadcast(CkArrayMessage*);
 */
    void RecvBroadcast(CkArrayMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_RecvBroadcast_CkArrayMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_RecvBroadcast_CkArrayMessage, msg, _ck_gid);
    }
    void RecvBroadcast(CkArrayMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_RecvBroadcast_CkArrayMessage, msg, onPE, _ck_gid);
    }
    void RecvBroadcast(CkArrayMessage*msg, int npes, int *pes) {
      CkSendMsgBranchMulti(__idx_RecvBroadcast_CkArrayMessage, msg, npes, pes, _ck_gid);
    }
    static int  __idx_RecvBroadcast_CkArrayMessage;
    static int  ckIdx_RecvBroadcast(CkArrayMessage*msg) { return __idx_RecvBroadcast_CkArrayMessage; }
    static void _call_RecvBroadcast_CkArrayMessage(void* msg, CkArray* obj);
};

/* DECLS: array ArrayElement{
ArrayElement(CkMigrateMessage*);
ArrayElement();
void destroy(void);
};
 */
class ArrayElement;
class CProxy_ArrayElement : public CProxy_CkArrayBase{
  public:
    static int __idx;
    static void __register(const char *s, size_t size);
    static CkGroupID buildArrayGroup(CkGroupID mapID=_RRMapID,int numInitial=0)
    {
        return CkArray::CreateArray(mapID,numInitial);
    }
  protected:
    CProxy_ArrayElement(const CkArrayID &aid,const CkArrayIndex &idx)
        :CProxy_CkArrayBase(aid,idx) {}
  public:
    CProxy_ArrayElement(const CkArrayID &aid) 
        :CProxy_CkArrayBase(aid) {}
    CProxy_ArrayElement(void) {}
    static CkArrayID ckNew(void) {return CkArrayID(buildArrayGroup());}
    static CkArrayID ckNew_mapped(CkGroupID mapID) {return CkArrayID(buildArrayGroup(mapID));}
/* DECLS: ArrayElement(CkMigrateMessage*);
 */
    static int  __idx_ArrayElement_CkMigrateMessage;
    static int  ckIdx_ArrayElement(CkMigrateMessage*msg) { return __idx_ArrayElement_CkMigrateMessage; }
    static void _call_ArrayElement_CkMigrateMessage(void* msg, ArrayElement* obj);

/* DECLS: ArrayElement(void);
 */
    void insert(int onPE=-1);    static int  __idx_ArrayElement_void;
    static int  ckIdx_ArrayElement(void) { return __idx_ArrayElement_void; }
    static void _call_ArrayElement_void(void* msg, ArrayElement* obj);

/* DECLS: void destroy(void);
 */
    void destroy(void) const;
    static int  __idx_destroy_void;
    static int  ckIdx_destroy(void) { return __idx_destroy_void; }
    static void _call_destroy_void(void* msg, ArrayElement* obj);
};

/* DECLS: group CkArrayMap: CkGroupInitCallback{
CkArrayMap(void);
};
 */
class CkArrayMap;
class CProxy_CkArrayMap:  public virtual _CK_GID, public CProxy_CkGroupInitCallback{
  public:
    static int __idx;
    static void __register(const char *s, size_t size);
    CProxy_CkArrayMap(CkGroupID _gid) :CProxy_CkGroupInitCallback(_gid){ _ck_gid = _gid; _setChare(0); }
    CProxy_CkArrayMap(CkChareID __cid) :CProxy_CkGroupInitCallback(__cid){ ckSetChareId(__cid); }
    CkChareID ckGetChareId(void) { return _ck_cid; }
    void ckSetChareId(CkChareID __cid){_CHECK_CID(__cid,__idx);_ck_cid=__cid;_setChare(1);}
    CkGroupID ckGetGroupId(void) { return _ck_gid; }
    void ckSetGroupId(CkGroupID _gid){_ck_gid=_gid;_setChare(0);}
    CkArrayMap* ckLocalBranch(void) {
      return (CkArrayMap *) CkLocalBranch(_ck_gid);
    }
    static CkArrayMap* ckLocalBranch(CkGroupID gID) {
      return (CkArrayMap *) CkLocalBranch(gID);
    }
/* DECLS: CkArrayMap(void);
 */
    static CkGroupID ckNew(void);
    static CkGroupID ckNewSync(void);
    CProxy_CkArrayMap(int retEP, CkChareID *cid);
    CProxy_CkArrayMap(void);
    static int  __idx_CkArrayMap_void;
    static int  ckIdx_CkArrayMap(void) { return __idx_CkArrayMap_void; }
    static void _call_CkArrayMap_void(void* msg, CkArrayMap* obj);
};

/* DECLS: group RRMap: CkArrayMap{
RRMap(void);
};
 */
class RRMap;
class CProxy_RRMap:  public virtual _CK_GID, public CProxy_CkArrayMap{
  public:
    static int __idx;
    static void __register(const char *s, size_t size);
    CProxy_RRMap(CkGroupID _gid) :CProxy_CkArrayMap(_gid){ _ck_gid = _gid; _setChare(0); }
    CProxy_RRMap(CkChareID __cid) :CProxy_CkArrayMap(__cid){ ckSetChareId(__cid); }
    CkChareID ckGetChareId(void) { return _ck_cid; }
    void ckSetChareId(CkChareID __cid){_CHECK_CID(__cid,__idx);_ck_cid=__cid;_setChare(1);}
    CkGroupID ckGetGroupId(void) { return _ck_gid; }
    void ckSetGroupId(CkGroupID _gid){_ck_gid=_gid;_setChare(0);}
    RRMap* ckLocalBranch(void) {
      return (RRMap *) CkLocalBranch(_ck_gid);
    }
    static RRMap* ckLocalBranch(CkGroupID gID) {
      return (RRMap *) CkLocalBranch(gID);
    }
/* DECLS: RRMap(void);
 */
    static CkGroupID ckNew(void);
    static CkGroupID ckNewSync(void);
    CProxy_RRMap(int retEP, CkChareID *cid);
    CProxy_RRMap(void);
    static int  __idx_RRMap_void;
    static int  ckIdx_RRMap(void) { return __idx_RRMap_void; }
    static void _call_RRMap_void(void* msg, RRMap* obj);
};

/* DECLS: mainchare CkArrayInit{
CkArrayInit();
};
 */
class CkArrayInit;
class CProxy_CkArrayInit: public virtual _CK_CID{
  public:
    static int __idx;
    static void __register(const char *s, size_t size);
    CProxy_CkArrayInit(CkChareID __cid) { ckSetChareId(__cid); }
    CkChareID ckGetChareId(void) { return _ck_cid; }
    void ckSetChareId(CkChareID __cid) {_CHECK_CID(__cid,__idx);_ck_cid=__cid;}
/* DECLS: CkArrayInit();
 */
    static void ckNew(int onPE=CK_PE_ANY);
    static void ckNew(CkChareID* pcid, int onPE=CK_PE_ANY);
    CProxy_CkArrayInit(int onPE=CK_PE_ANY);
    static int  __idx_CkArrayInit;
    static int  ckIdx_CkArrayInit() { return __idx_CkArrayInit; }
    static void _call_CkArrayInit(CkArgMsg* msg, CkArrayInit* obj);
};

extern void _registerCkArray(void);
#endif
